/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Date;
import org.openstreetmap.josm.Main;

public abstract class CacheCustomContent {
    public static final int INTERVAL_ALWAYS = -1;
    public static final int INTERVAL_HOURLY = 3600;
    public static final int INTERVAL_DAILY = 86400;
    public static final int INTERVAL_WEEKLY = 604800;
    public static final int INTERVAL_MONTHLY = 2419200;
    public static final int INTERVAL_NEVER = Integer.MAX_VALUE;
    private byte[] data = null;
    private final String ident;
    private final File path;
    private final int updateInterval;

    protected abstract byte[] updateData();

    protected boolean isCacheValid() {
        return true;
    }

    public CacheCustomContent(String string, int n) {
        this.ident = string;
        this.updateInterval = n;
        this.path = new File(Main.pref.getPreferencesDir(), string);
    }

    public byte[] updateIfRequired() {
        if ((long)(Main.pref.getInteger("cache." + this.ident, 0) + this.updateInterval) < new Date().getTime() / 1000L || !this.isCacheValid()) {
            return this.updateForce();
        }
        return this.getData();
    }

    public String updateIfRequiredString() {
        if ((long)(Main.pref.getInteger("cache." + this.ident, 0) + this.updateInterval) < new Date().getTime() / 1000L || !this.isCacheValid()) {
            return this.updateForceString();
        }
        return this.getDataString();
    }

    public byte[] updateForce() {
        this.data = this.updateData();
        this.saveToDisk();
        Main.pref.putInteger("cache." + this.ident, (int)(new Date().getTime() / 1000L));
        return this.data;
    }

    public String updateForceString() {
        this.updateForce();
        return new String(this.data);
    }

    public byte[] getData() {
        if (this.data == null) {
            this.loadFromDisk();
        }
        return this.data;
    }

    public String getDataString() {
        return new String(this.getData());
    }

    private void loadFromDisk() {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.path));
            this.data = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(this.data);
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            this.data = this.updateForce();
        }
    }

    private void saveToDisk() {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.path));
            bufferedOutputStream.write(this.data);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void flushData() {
        this.data = null;
    }
}

