/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.StyleSources;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class MapPaintPreference
implements PreferenceSetting {
    private StyleSources sources;
    private JCheckBox enableIconDefault;
    private JCheckBox enableDefault;
    private JComboBox styleCombo = new JComboBox();

    public void addGui(PreferenceDialog preferenceDialog) {
        this.enableDefault = new JCheckBox(I18n.tr("Enable built-in defaults"), Main.pref.getBoolean("mappaint.style.enable-defaults", true));
        this.enableIconDefault = new JCheckBox(I18n.tr("Enable built-in icon defaults"), Main.pref.getBoolean("mappaint.icon.enable-defaults", true));
        this.sources = new StyleSources("mappaint.style.sources", "mappaint.icon.sources", "http://josm.openstreetmap.de/styles", false, I18n.tr("Map Paint Styles"));
        TreeSet<String> treeSet = new TreeSet<String>(MapPaintStyles.getStyles().getStyleNames());
        String string = Main.pref.get("mappaint.style", "standard");
        treeSet.add(string);
        for (String object2 : treeSet) {
            this.styleCombo.addItem(object2);
        }
        this.styleCombo.setEditable(true);
        for (int i = 0; i < this.styleCombo.getItemCount(); ++i) {
            if (!((String)this.styleCombo.getItemAt(i)).equals(string)) continue;
            this.styleCombo.setSelectedIndex(i);
            break;
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)this.enableDefault, GBC.std().insets(5, 5, 5, 0));
        jPanel.add((Component)this.enableIconDefault, GBC.eol().insets(5, 5, 5, 0));
        jPanel.add((Component)new JLabel(I18n.tr("Used style")), GBC.std().insets(5, 5, 0, 5));
        jPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        jPanel.add((Component)this.styleCombo, GBC.eop().fill(2).insets(0, 0, 5, 0));
        jPanel.add((Component)this.sources, GBC.eol().fill(1));
        preferenceDialog.mapcontent.addTab(I18n.tr("Map Paint Styles"), jScrollPane);
    }

    public boolean ok() {
        Boolean bl = Main.pref.put("mappaint.style.enable-defaults", this.enableDefault.getSelectedObjects() != null);
        if (Main.pref.put("mappaint.icon.enable-defaults", this.enableIconDefault.getSelectedObjects() != null)) {
            bl = true;
        }
        if (this.sources.finish()) {
            bl = true;
        }
        Main.pref.put("mappaint.style", this.styleCombo.getEditor().getItem().toString());
        return bl;
    }

    public static void initialize() {
        MapPaintStyles.readFromPreferences();
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new MapPaintPreference();
        }
    }
}

