/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.command.PurgePrimitivesCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.gpx.WithAttributes;
import org.openstreetmap.josm.data.osm.BackreferencedDataSet;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.MapPaintVisitor;
import org.openstreetmap.josm.data.osm.visitor.MergeVisitor;
import org.openstreetmap.josm.data.osm.visitor.SimplePaintVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpBuilder;
import org.openstreetmap.josm.gui.layer.DataChangeListener;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmDataLayer
extends Layer {
    public static final String REQUIRES_SAVE_TO_DISK_PROP = OsmDataLayer.class.getName() + ".requiresSaveToDisk";
    public static final String REQUIRES_UPLOAD_TO_SERVER_PROP = OsmDataLayer.class.getName() + ".requiresUploadToServer";
    private boolean requiresSaveToFile = false;
    private boolean requiresUploadToServer = false;
    private static int dataLayerCounter = 0;
    public final DataSet data;
    private ConflictCollection conflicts;
    public final LinkedList<DataChangeListener> listenerDataChanged = new LinkedList();
    private static TexturePaint hatched;

    protected void setRequiresSaveToFile(boolean bl) {
        boolean bl2 = this.requiresSaveToFile;
        this.requiresSaveToFile = bl;
        if (bl2 != bl) {
            this.propertyChangeSupport.firePropertyChange(REQUIRES_SAVE_TO_DISK_PROP, bl2, bl);
        }
    }

    protected void setRequiresUploadToServer(boolean bl) {
        boolean bl2 = this.requiresUploadToServer;
        this.requiresUploadToServer = bl;
        if (bl2 != bl) {
            this.propertyChangeSupport.firePropertyChange(REQUIRES_UPLOAD_TO_SERVER_PROP, bl2, bl);
        }
    }

    public static String createNewName() {
        return I18n.tr("Data Layer {0}", ++dataLayerCounter);
    }

    public static void createHatchTexture() {
        BufferedImage bufferedImage = new BufferedImage(15, 15, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Main.pref.getColor(I18n.marktr("background"), Color.BLACK));
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.fillRect(0, 0, 15, 15);
        graphics2D.setColor(Main.pref.getColor(I18n.marktr("outside downloaded area"), Color.YELLOW));
        graphics2D.drawLine(0, 15, 15, 0);
        Rectangle rectangle = new Rectangle(0, 0, 15, 15);
        hatched = new TexturePaint(bufferedImage, rectangle);
    }

    public OsmDataLayer(DataSet dataSet, String string, File file) {
        super(string);
        this.data = dataSet;
        this.setAssociatedFile(file);
        this.conflicts = new ConflictCollection();
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "osmdata_small");
    }

    @Override
    public void paint(Graphics graphics, MapView mapView) {
        Object object;
        boolean bl;
        boolean bl2 = mapView.getActiveLayer() == this;
        boolean bl3 = !bl2 && Main.pref.getBoolean("draw.data.inactive_color", true);
        boolean bl4 = bl = !bl3 && mapView.isVirtualNodesEnabled();
        if (bl2 && Main.pref.getBoolean("draw.data.downloaded_area", true) && !this.data.dataSources.isEmpty()) {
            object = mapView.getBounds();
            ((Rectangle)object).grow(100, 100);
            Area area = new Area((Shape)object);
            for (DataSource dataSource : this.data.dataSources) {
                if (dataSource.bounds == null || dataSource.bounds.min.equals(dataSource.bounds.max)) continue;
                EastNorth eastNorth = mapView.getProjection().latlon2eastNorth(dataSource.bounds.min);
                EastNorth eastNorth2 = mapView.getProjection().latlon2eastNorth(dataSource.bounds.max);
                Point point = mapView.getPoint(eastNorth);
                Point point2 = mapView.getPoint(eastNorth2);
                Rectangle rectangle = new Rectangle(Math.min(point.x, point2.x), Math.min(point.y, point2.y), Math.abs(point2.x - point.x), Math.abs(point2.y - point.y));
                area.subtract(new Area(rectangle));
            }
            ((Graphics2D)graphics).setPaint(hatched);
            ((Graphics2D)graphics).fill(area);
        }
        object = Main.pref.getBoolean("draw.wireframe") ? new SimplePaintVisitor() : new MapPaintVisitor();
        ((SimplePaintVisitor)object).setGraphics(graphics);
        ((SimplePaintVisitor)object).setNavigatableComponent(mapView);
        ((SimplePaintVisitor)object).inactive = bl3;
        ((SimplePaintVisitor)object).visitAll(this.data, bl);
        Main.map.conflictDialog.paintConflicts(graphics, mapView);
    }

    @Override
    public String getToolTipText() {
        File file;
        String string = "";
        string = string + this.undeletedSize(this.data.nodes) + " " + I18n.trn("node", "nodes", this.undeletedSize(this.data.nodes)) + ", ";
        string = string + this.undeletedSize(this.data.ways) + " " + I18n.trn("way", "ways", this.undeletedSize(this.data.ways));
        if (this.data.version != null) {
            string = string + ", " + I18n.tr("version {0}", this.data.version);
        }
        if ((file = this.getAssociatedFile()) != null) {
            string = "<html>" + string + "<br>" + file.getPath() + "</html>";
        }
        return string;
    }

    @Override
    public void mergeFrom(Layer layer) {
        this.mergeFrom(((OsmDataLayer)layer).data);
    }

    public void mergeFrom(DataSet dataSet) {
        MergeVisitor mergeVisitor = new MergeVisitor(this.data, dataSet);
        mergeVisitor.merge();
        Area area = this.data.getDataSourceArea();
        for (DataSource object2 : dataSet.dataSources) {
            if (area != null && area.contains(object2.bounds.asRect())) continue;
            this.data.dataSources.add(object2);
        }
        if (this.data.version == null) {
            this.data.version = dataSet.version;
        } else if ("0.5".equals(this.data.version) ^ "0.5".equals(dataSet.version)) {
            System.err.println(I18n.tr("Warning: mixing 0.6 and 0.5 data results in version 0.5"));
            this.data.version = "0.5";
        }
        int n = 0;
        for (Conflict<?> conflict : mergeVisitor.getConflicts()) {
            if (this.conflicts.hasConflict(conflict)) continue;
            ++n;
            this.conflicts.add(conflict);
        }
        PurgePrimitivesCommand purgePrimitivesCommand = this.buildPurgeCommand();
        if (purgePrimitivesCommand != null) {
            Main.main.undoRedo.add(purgePrimitivesCommand);
        }
        this.fireDataChange();
        Main.map.mapView.repaint();
        this.warnNumNewConflicts(n, purgePrimitivesCommand == null ? 0 : purgePrimitivesCommand.getPurgedPrimitives().size());
    }

    protected void warnNumNewConflicts(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return;
        }
        String string = I18n.trn("There was {0} conflict detected.", "There were {0} conflicts detected.", n, n);
        String string2 = I18n.trn("{0} object has been purged from the local dataset because it is deleted on the server.", "{0} objects have been purged from the local dataset because they are deleted on the server.", n2, n2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>").append(string);
        if (n2 > 0) {
            stringBuffer.append("<br>").append(string2);
        }
        stringBuffer.append("<br>").append(I18n.tr("Please consult the Conflict List Dialog<br>and manually resolve them."));
        stringBuffer.append("</html>");
        if (n > 0) {
            Object[] objectArray = new JButton[]{new JButton(I18n.tr("OK")), new JButton(I18n.tr("Help"))};
            objectArray[0].setIcon(ImageProvider.get("ok"));
            objectArray[1].setIcon(ImageProvider.get("help"));
            JOptionPane jOptionPane = new JOptionPane(stringBuffer.toString(), 2, -1, null, objectArray, objectArray[0]);
            final JDialog jDialog = new JDialog(JOptionPane.getFrameForComponent(Main.parent), I18n.tr("Conflicts detected"), true);
            ((AbstractButton)objectArray[0]).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.setVisible(false);
                }
            });
            ((AbstractButton)objectArray[1]).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HelpBrowser helpBrowser = new HelpBrowser();
                    helpBrowser.setUrlForHelpTopic("Help/Concepts/Conflict");
                    helpBrowser.setVisible(true);
                }
            });
            jDialog.setContentPane(jOptionPane);
            jDialog.pack();
            HelpBuilder.setHelpContext(jDialog.getRootPane(), "Concepts/Conflict");
            WindowGeometry.centerOnScreen(jDialog.getSize()).applySafe(jDialog);
            jDialog.setVisible(true);
        }
    }

    protected PurgePrimitivesCommand buildPurgeCommand() {
        BackreferencedDataSet backreferencedDataSet = new BackreferencedDataSet(this.data);
        backreferencedDataSet.build();
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        block0: for (Conflict<?> conflict : this.conflicts) {
            if (((OsmPrimitive)conflict.getMy()).isDeleted() && !((OsmPrimitive)conflict.getTheir()).isVisible()) {
                arrayList.add((OsmPrimitive)conflict.getMy());
                continue;
            }
            if (((OsmPrimitive)conflict.getMy()).isModified() || ((OsmPrimitive)conflict.getTheir()).isVisible()) continue;
            if (conflict.getMy() instanceof Way || conflict.getMy() instanceof Relation) {
                arrayList.add((OsmPrimitive)conflict.getMy());
                continue;
            }
            for (OsmPrimitive osmPrimitive : backreferencedDataSet.getParents((OsmPrimitive)conflict.getMy())) {
                if (!osmPrimitive.isModified() || !(osmPrimitive instanceof Way)) continue;
                continue block0;
            }
            arrayList.add((OsmPrimitive)conflict.getMy());
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        PurgePrimitivesCommand purgePrimitivesCommand = new PurgePrimitivesCommand(this, arrayList);
        purgePrimitivesCommand.setBackreferenceDataSet(backreferencedDataSet);
        return purgePrimitivesCommand;
    }

    @Override
    public boolean isMergable(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        for (Node node : this.data.nodes) {
            if (!node.isUsable()) continue;
            boundingXYVisitor.visit(node);
        }
    }

    public void cleanupAfterUpload(Collection<OsmPrimitive> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Main.main.undoRedo.clean(this);
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(collection);
        Iterator<OsmPrimitive> iterator = this.data.nodes.iterator();
        while (iterator.hasNext()) {
            this.cleanIterator(iterator, hashSet);
        }
        iterator = this.data.ways.iterator();
        while (iterator.hasNext()) {
            this.cleanIterator(iterator, hashSet);
        }
        iterator = this.data.relations.iterator();
        while (iterator.hasNext()) {
            this.cleanIterator(iterator, hashSet);
        }
    }

    private void cleanIterator(Iterator<? extends OsmPrimitive> iterator, Collection<OsmPrimitive> collection) {
        OsmPrimitive osmPrimitive = iterator.next();
        if (!collection.remove(osmPrimitive)) {
            return;
        }
        osmPrimitive.setModified(false);
        if (osmPrimitive.isDeleted()) {
            iterator.remove();
        }
    }

    private int undeletedSize(Collection<? extends OsmPrimitive> collection) {
        int n = 0;
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive.isDeleted()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Object getInfoComponent() {
        DataCountVisitor dataCountVisitor = new DataCountVisitor();
        for (OsmPrimitive osmPrimitive : this.data.allPrimitives()) {
            osmPrimitive.visit(dataCountVisitor);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("{0} consists of:", this.getName())), GBC.eol());
        for (int i = 0; i < dataCountVisitor.normal.length; ++i) {
            String string = dataCountVisitor.normal[i] + " " + I18n.trn(dataCountVisitor.names[i], dataCountVisitor.names[i] + "s", dataCountVisitor.normal[i]);
            if (dataCountVisitor.deleted[i] > 0) {
                string = string + I18n.tr(" ({0} deleted.)", dataCountVisitor.deleted[i]);
            }
            jPanel.add((Component)new JLabel(string, ImageProvider.get("data", dataCountVisitor.names[i]), 0), GBC.eop().insets(15, 0, 0, 0));
        }
        jPanel.add(new JLabel(I18n.tr("API version: {0}", this.data.version != null ? this.data.version : I18n.tr("unset"))));
        return jPanel;
    }

    @Override
    public Component[] getMenuEntries() {
        if (Main.applet) {
            return new Component[]{new JMenuItem(LayerListDialog.getInstance().createActivateLayerAction(this)), new JMenuItem(LayerListDialog.getInstance().createShowHideLayerAction(this)), new JMenuItem(LayerListDialog.getInstance().createDeleteLayerAction(this)), new JSeparator(), new JMenuItem(LayerListDialog.getInstance().createMergeLayerAction(this)), new JSeparator(), new JMenuItem(new RenameLayerAction(this.getAssociatedFile(), this)), new JSeparator(), new JMenuItem(new LayerListPopup.InfoAction(this))};
        }
        return new Component[]{new JMenuItem(LayerListDialog.getInstance().createActivateLayerAction(this)), new JMenuItem(LayerListDialog.getInstance().createShowHideLayerAction(this)), new JMenuItem(LayerListDialog.getInstance().createDeleteLayerAction(this)), new JSeparator(), new JMenuItem(LayerListDialog.getInstance().createMergeLayerAction(this)), new JMenuItem(new Layer.LayerSaveAction(this)), new JMenuItem(new Layer.LayerSaveAsAction(this)), new JMenuItem(new Layer.LayerGpxExportAction(this)), new JMenuItem(new ConvertToGpxLayerAction()), new JSeparator(), new JMenuItem(new RenameLayerAction(this.getAssociatedFile(), this)), new JSeparator(), new JMenuItem(new LayerListPopup.InfoAction(this))};
    }

    public void fireDataChange() {
        this.setRequiresSaveToFile(true);
        this.setRequiresUploadToServer(true);
        for (DataChangeListener dataChangeListener : this.listenerDataChanged) {
            dataChangeListener.dataChanged(this);
        }
    }

    public static GpxData toGpxData(DataSet dataSet, File file) {
        Object object;
        WithAttributes withAttributes;
        GpxData gpxData = new GpxData();
        gpxData.storageFile = file;
        HashSet<Node> hashSet = new HashSet<Node>();
        for (Way osmPrimitive : dataSet.ways) {
            if (!osmPrimitive.isUsable()) continue;
            withAttributes = new GpxTrack();
            gpxData.tracks.add((GpxTrack)withAttributes);
            if (osmPrimitive.get("name") != null) {
                ((GpxTrack)withAttributes).attr.put("name", osmPrimitive.get("name"));
            }
            object = null;
            for (Node node : osmPrimitive.getNodes()) {
                if (!node.isUsable()) {
                    object = null;
                    continue;
                }
                if (object == null) {
                    object = new ArrayList();
                    ((GpxTrack)withAttributes).trackSegs.add((Collection<WayPoint>)object);
                }
                if (!node.isTagged()) {
                    hashSet.add(node);
                }
                WayPoint wayPoint = new WayPoint(node.getCoor());
                if (!node.isTimestampEmpty()) {
                    wayPoint.attr.put("time", DateUtils.fromDate(node.getTimestamp()));
                    wayPoint.setTime();
                }
                ((ArrayList)object).add(wayPoint);
            }
        }
        for (Node node : dataSet.nodes) {
            if (node.incomplete || node.isDeleted() || hashSet.contains(node)) continue;
            withAttributes = new WayPoint(node.getCoor());
            if (!node.isTimestampEmpty()) {
                ((WayPoint)withAttributes).attr.put("time", DateUtils.fromDate(node.getTimestamp()));
                ((WayPoint)withAttributes).setTime();
            }
            if ((object = node.get("name")) == null) continue;
            ((WayPoint)withAttributes).attr.put("name", object);
        }
        return gpxData;
    }

    public GpxData toGpxData() {
        return OsmDataLayer.toGpxData(this.data, this.getAssociatedFile());
    }

    public boolean containsPoint(LatLon latLon) {
        if (this.data.dataSources.isEmpty()) {
            return true;
        }
        boolean bl = false;
        for (DataSource dataSource : this.data.dataSources) {
            if (!dataSource.bounds.contains(latLon)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }

    public boolean requiresUploadToServer() {
        return this.requiresUploadToServer;
    }

    public boolean requiresSaveToFile() {
        return this.getAssociatedFile() != null && this.requiresSaveToFile;
    }

    public void onPostLoadFromFile() {
        this.setRequiresSaveToFile(false);
        this.setRequiresUploadToServer(this.data.isModified());
    }

    public void onPostSaveToFile() {
        this.setRequiresSaveToFile(false);
        this.setRequiresUploadToServer(this.data.isModified());
    }

    public void onPostUploadToServer() {
        this.setRequiresUploadToServer(this.data.isModified());
    }

    static {
        OsmDataLayer.createHatchTexture();
    }

    public class ConvertToGpxLayerAction
    extends AbstractAction {
        public ConvertToGpxLayerAction() {
            super(I18n.tr("Convert to GPX layer"), ImageProvider.get("converttogpx"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Main.main.addLayer(new GpxLayer(OsmDataLayer.this.toGpxData(), I18n.tr("Converted from: {0}", OsmDataLayer.this.getName())));
            Main.main.removeLayer(OsmDataLayer.this);
        }
    }

    public static interface CommandQueueListener {
        public void commandChanged(int var1, int var2);
    }

    public static final class DataCountVisitor
    extends AbstractVisitor {
        public final int[] normal = new int[3];
        public final int[] deleted = new int[3];
        public final String[] names = new String[]{OsmPrimitiveType.NODE.getAPIName(), OsmPrimitiveType.WAY.getAPIName(), OsmPrimitiveType.RELATION.getAPIName()};

        private void inc(OsmPrimitive osmPrimitive, int n) {
            int n2 = n;
            this.normal[n2] = this.normal[n2] + 1;
            if (osmPrimitive.isDeleted()) {
                int n3 = n;
                this.deleted[n3] = this.deleted[n3] + 1;
            }
        }

        public void visit(Node node) {
            this.inc(node, 0);
        }

        public void visit(Way way) {
            this.inc(way, 1);
        }

        public void visit(Relation relation) {
            this.inc(relation, 2);
        }
    }
}

