/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTaskList;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.AudioUtil;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.UrlLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GpxLayer
extends Layer {
    public GpxData data;
    private final GpxLayer me;
    protected static final double PHI = Math.toRadians(15.0);
    private boolean computeCacheInSync;
    private int computeCacheMaxLineLengthUsed;
    private Color computeCacheColorUsed;
    private colorModes computeCacheColored;
    private int computeCacheColorTracksTune;
    private boolean isLocalFile;
    private static Color[] colors = new Color[256];
    private static int ll0;
    private static int sl4;
    private static int sl9;
    private static int[][] dir;

    public GpxLayer(GpxData gpxData) {
        super((String)gpxData.attr.get("name"));
        this.data = gpxData;
        this.me = this;
        this.computeCacheInSync = false;
    }

    public GpxLayer(GpxData gpxData, String string) {
        this(gpxData);
        this.setName(string);
    }

    public GpxLayer(GpxData gpxData, String string, boolean bl) {
        this(gpxData);
        this.setName(string);
        this.isLocalFile = bl;
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "gpx_small");
    }

    @Override
    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public static Color getColor(String string) {
        return Main.pref.getColor(I18n.marktr("gps point"), string != null ? "layer " + string : null, Color.gray);
    }

    @Override
    public Component[] getMenuEntries() {
        JMenuItem jMenuItem = new JMenuItem(I18n.tr("Customize line drawing"), ImageProvider.get("mapmode/addsegment"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JRadioButton[] jRadioButtonArray = new JRadioButton[]{new JRadioButton(I18n.tr("Use global settings.")), new JRadioButton(I18n.tr("Draw lines between points for this layer.")), new JRadioButton(I18n.tr("Do not draw lines between points for this layer."))};
                ButtonGroup buttonGroup = new ButtonGroup();
                Box box = Box.createVerticalBox();
                for (JRadioButton jRadioButton : jRadioButtonArray) {
                    buttonGroup.add(jRadioButton);
                    box.add(jRadioButton);
                }
                String string = "draw.rawgps.lines.layer " + GpxLayer.this.getName();
                if (Main.pref.hasKey(string)) {
                    buttonGroup.setSelected(jRadioButtonArray[Main.pref.getBoolean(string) ? 1 : 2].getModel(), true);
                } else {
                    buttonGroup.setSelected(jRadioButtonArray[0].getModel(), true);
                }
                int n = JOptionPane.showConfirmDialog(Main.parent, box, I18n.tr("Select line drawing options"), 2, 3);
                switch (n) {
                    case -1: 
                    case 2: {
                        return;
                    }
                }
                if (buttonGroup.getSelection() == jRadioButtonArray[0].getModel()) {
                    Main.pref.put(string, null);
                } else {
                    Main.pref.put(string, buttonGroup.getSelection() == jRadioButtonArray[1].getModel());
                }
                Main.map.repaint();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(I18n.tr("Customize Color"), ImageProvider.get("colorchooser"));
        jMenuItem2.putClientProperty("help", "Action/LayerCustomizeColor");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JColorChooser jColorChooser = new JColorChooser(GpxLayer.getColor(GpxLayer.this.getName()));
                Object[] objectArray = new Object[]{I18n.tr("OK"), I18n.tr("Cancel"), I18n.tr("Default")};
                int n = JOptionPane.showOptionDialog(Main.parent, jColorChooser, I18n.tr("Choose a color"), 2, -1, null, objectArray, objectArray[0]);
                switch (n) {
                    case 0: {
                        Main.pref.putColor("layer " + GpxLayer.this.getName(), jColorChooser.getColor());
                        break;
                    }
                    case 1: {
                        return;
                    }
                    case 2: {
                        Main.pref.putColor("layer " + GpxLayer.this.getName(), null);
                    }
                }
                Main.map.repaint();
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(I18n.tr("Markers From Named Points"), ImageProvider.get("addmarkers"));
        jMenuItem3.putClientProperty("help", "Action/MarkersFromNamedPoints");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GpxData gpxData = new GpxData();
                for (GpxTrack gpxTrack : GpxLayer.this.data.tracks) {
                    for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                        for (WayPoint wayPoint : collection) {
                            if (!wayPoint.attr.containsKey("name") && !wayPoint.attr.containsKey("desc")) continue;
                            gpxData.waypoints.add(wayPoint);
                        }
                    }
                }
                MarkerLayer markerLayer = new MarkerLayer(gpxData, I18n.tr("Named Trackpoints from {0}", GpxLayer.this.getName()), GpxLayer.this.getAssociatedFile(), GpxLayer.this.me);
                if (markerLayer.data.size() > 0) {
                    Main.main.addLayer(markerLayer);
                }
            }
        });
        JMenuItem jMenuItem4 = new JMenuItem(I18n.tr("Import Audio"), ImageProvider.get("importaudio"));
        jMenuItem4.putClientProperty("help", "ImportAudio");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = Main.pref.get("markers.lastaudiodirectory");
                JFileChooser jFileChooser = new JFileChooser(string);
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.setFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().toLowerCase().endsWith(".wav");
                    }

                    public String getDescription() {
                        return I18n.tr("Wave Audio files (*.wav)");
                    }
                });
                jFileChooser.setMultiSelectionEnabled(true);
                if (jFileChooser.showOpenDialog(Main.parent) == 0) {
                    File[] fileArray;
                    if (!jFileChooser.getCurrentDirectory().getAbsolutePath().equals(string)) {
                        Main.pref.put("markers.lastaudiodirectory", jFileChooser.getCurrentDirectory().getAbsolutePath());
                    }
                    if ((fileArray = jFileChooser.getSelectedFiles()) != null && fileArray.length > 1) {
                        Arrays.sort(fileArray, new Comparator<File>(){

                            @Override
                            public int compare(File file, File file2) {
                                return file.lastModified() <= file2.lastModified() ? -1 : 1;
                            }
                        });
                    }
                    String string2 = null;
                    for (int i = 0; i < fileArray.length; ++i) {
                        string2 = string2 == null ? " (" : string2 + ", ";
                        string2 = string2 + fileArray[i].getName();
                    }
                    string2 = string2 != null ? string2 + ")" : "";
                    MarkerLayer markerLayer = new MarkerLayer(new GpxData(), I18n.tr("Audio markers from {0}", GpxLayer.this.getName()) + string2, GpxLayer.this.getAssociatedFile(), GpxLayer.this.me);
                    if (fileArray != null) {
                        double d = (double)fileArray[0].lastModified() / 1000.0 - AudioUtil.getCalibratedDuration(fileArray[0]);
                        Markers markers = new Markers();
                        for (int i = 0; i < fileArray.length; ++i) {
                            GpxLayer.this.importAudio(fileArray[i], markerLayer, d, markers);
                        }
                    }
                    Main.main.addLayer(markerLayer);
                    Main.map.repaint();
                }
            }
        });
        JMenuItem jMenuItem5 = new JMenuItem(I18n.tr("Import images"), ImageProvider.get("tagimages"));
        jMenuItem5.putClientProperty("help", "Action/ImportImages");
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(Main.pref.get("tagimages.lastdirectory"));
                jFileChooser.setFileSelectionMode(2);
                jFileChooser.setMultiSelectionEnabled(true);
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.setFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().toLowerCase().endsWith(".jpg");
                    }

                    public String getDescription() {
                        return I18n.tr("JPEG images (*.jpg)");
                    }
                });
                jFileChooser.showOpenDialog(Main.parent);
                File[] fileArray = jFileChooser.getSelectedFiles();
                if (fileArray == null || fileArray.length == 0) {
                    return;
                }
                LinkedList<File> linkedList = new LinkedList<File>();
                this.addRecursiveFiles(linkedList, fileArray);
                Main.pref.put("tagimages.lastdirectory", jFileChooser.getCurrentDirectory().getPath());
                GeoImageLayer.create(linkedList, GpxLayer.this);
            }

            private void addRecursiveFiles(LinkedList<File> linkedList, File[] fileArray) {
                for (File file : fileArray) {
                    if (file.isDirectory()) {
                        this.addRecursiveFiles(linkedList, file.listFiles());
                        continue;
                    }
                    if (!file.getName().toLowerCase().endsWith(".jpg")) continue;
                    linkedList.add(file);
                }
            }
        });
        if (Main.applet) {
            return new Component[]{new JMenuItem(LayerListDialog.getInstance().createShowHideLayerAction(this)), new JMenuItem(LayerListDialog.getInstance().createDeleteLayerAction(this)), new JSeparator(), jMenuItem2, jMenuItem, new JMenuItem(new ConvertToDataLayerAction()), new JSeparator(), new JMenuItem(new RenameLayerAction(this.getAssociatedFile(), this)), new JSeparator(), new JMenuItem(new LayerListPopup.InfoAction(this))};
        }
        return new Component[]{new JMenuItem(LayerListDialog.getInstance().createShowHideLayerAction(this)), new JMenuItem(LayerListDialog.getInstance().createDeleteLayerAction(this)), new JSeparator(), new JMenuItem(new Layer.LayerSaveAction(this)), new JMenuItem(new Layer.LayerSaveAsAction(this)), jMenuItem2, jMenuItem, jMenuItem5, jMenuItem4, jMenuItem3, new JMenuItem(new ConvertToDataLayerAction()), new JMenuItem(new DownloadAlongTrackAction()), new JSeparator(), new JMenuItem(new RenameLayerAction(this.getAssociatedFile(), this)), new JSeparator(), new JMenuItem(new LayerListPopup.InfoAction(this))};
    }

    @Override
    public String getToolTipText() {
        StringBuilder stringBuilder = new StringBuilder().append("<html>");
        if (this.data.attr.containsKey("name")) {
            stringBuilder.append(I18n.tr("Name: {0}", this.data.attr.get("meta.name"))).append("<br>");
        }
        if (this.data.attr.containsKey("desc")) {
            stringBuilder.append(I18n.tr("Description: {0}", this.data.attr.get("meta.desc"))).append("<br>");
        }
        if (this.data.tracks.size() > 0) {
            stringBuilder.append("<table><thead align=\"center\"><tr><td colspan=\"5\">" + I18n.trn("{0} track", "{0} tracks", this.data.tracks.size(), this.data.tracks.size()) + "</td></tr><tr><td>" + I18n.tr("Name") + "</td><td>" + I18n.tr("Description") + "</td><td>" + I18n.tr("Timespan") + "</td><td>" + I18n.tr("Length") + "</td><td>" + I18n.tr("URL") + "</td></tr></thead>");
            for (GpxTrack gpxTrack : this.data.tracks) {
                WayPoint wayPoint = null;
                WayPoint wayPoint2 = null;
                stringBuilder.append("<tr><td>");
                if (gpxTrack.attr.containsKey("name")) {
                    stringBuilder.append(gpxTrack.attr.get("name"));
                }
                stringBuilder.append("</td><td>");
                if (gpxTrack.attr.containsKey("desc")) {
                    stringBuilder.append(" ").append(gpxTrack.attr.get("desc"));
                }
                stringBuilder.append("</td><td>");
                for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                    for (WayPoint wayPoint3 : collection) {
                        if (wayPoint2 == null) {
                            wayPoint2 = wayPoint = wayPoint3;
                            continue;
                        }
                        if (wayPoint3.compareTo(wayPoint) < 0) {
                            wayPoint = wayPoint3;
                            continue;
                        }
                        wayPoint2 = wayPoint3;
                    }
                }
                if (wayPoint != null && wayPoint2 != null) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
                    stringBuilder.append(dateFormat.format(new Date((long)(wayPoint.time * 1000.0))) + " - " + dateFormat.format(new Date((long)(wayPoint2.time * 1000.0))));
                    int n = (int)(wayPoint2.time - wayPoint.time);
                    stringBuilder.append(" (" + n / 3600 + ":" + n % 3600 / 60 + ")");
                }
                stringBuilder.append("</td><td>");
                stringBuilder.append(new DecimalFormat("#0.00").format(gpxTrack.length() / 1000.0) + "km");
                stringBuilder.append("</td><td>");
                if (gpxTrack.attr.containsKey("url")) {
                    stringBuilder.append(gpxTrack.attr.get("url"));
                }
                stringBuilder.append("</td></tr>");
            }
            stringBuilder.append("</table><br><br>");
        }
        stringBuilder.append(I18n.tr("Length: ") + new DecimalFormat("#0.00").format(this.data.length() / 1000.0) + "km");
        stringBuilder.append("<br>");
        stringBuilder.append(I18n.trn("{0} route, ", "{0} routes, ", this.data.routes.size(), this.data.routes.size())).append(I18n.trn("{0} waypoint", "{0} waypoints", this.data.waypoints.size(), this.data.waypoints.size())).append("<br>");
        return stringBuilder.append("</html>").toString();
    }

    @Override
    public boolean isMergable(Layer layer) {
        return layer instanceof GpxLayer;
    }

    @Override
    public void mergeFrom(Layer layer) {
        this.data.mergeFrom(((GpxLayer)layer).data);
        this.computeCacheInSync = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paint(Graphics graphics, MapView mapView) {
        Point point;
        double d;
        Object object3;
        Object object22;
        Object object5;
        Color color = GpxLayer.getColor(this.getName());
        boolean bl = Main.pref.getBoolean("draw.rawgps.lines.force");
        boolean bl2 = Main.pref.getBoolean("draw.rawgps.direction");
        int n = Main.pref.getInteger("draw.rawgps.linewidth", 0);
        int n2 = this.isLocalFile ? Main.pref.getInteger("draw.rawgps.max-line-length.local", -1) : Main.pref.getInteger("draw.rawgps.max-line-length", 200);
        boolean bl3 = Main.pref.getBoolean("draw.rawgps.lines", true) || Main.pref.getBoolean("draw.rawgps.lines.localfiles") && this.isLocalFile;
        String string = "draw.rawgps.lines.layer " + this.getName();
        if (Main.pref.hasKey(string)) {
            bl3 = Main.pref.getBoolean(string);
        }
        boolean bl4 = Main.pref.getBoolean("draw.rawgps.large");
        boolean bl5 = Main.pref.getBoolean("draw.rawgps.hdopcircle", true);
        colorModes colorModes2 = colorModes.none;
        try {
            colorModes2 = colorModes.values()[Main.pref.getInteger("draw.rawgps.colors", 0)];
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl6 = Main.pref.getBoolean("draw.rawgps.alternatedirection");
        int n3 = Main.pref.getInteger("draw.rawgps.min-arrow-distance", 0);
        int n4 = Main.pref.getInteger("draw.rawgps.colorTracksTune", 45);
        if (n != 0) {
            object5 = (Graphics2D)graphics;
            ((Graphics2D)object5).setStroke(new BasicStroke(n, 1, 1));
        }
        if (this.computeCacheInSync && (this.computeCacheMaxLineLengthUsed != n2 || !color.equals(this.computeCacheColorUsed) || this.computeCacheColored != colorModes2 || this.computeCacheColorTracksTune != n4)) {
            this.computeCacheMaxLineLengthUsed = n2;
            this.computeCacheInSync = false;
            this.computeCacheColorUsed = color;
            this.computeCacheColored = colorModes2;
            this.computeCacheColorTracksTune = n4;
        }
        if (!this.computeCacheInSync) {
            object5 = null;
            for (GpxTrack gpxTrack : this.data.tracks) {
                if (!bl) {
                    object5 = null;
                }
                for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                    for (Object object22 : collection) {
                        object3 = ((WayPoint)object22).getCoor();
                        if (Double.isNaN(((LatLon)object3).lat()) || Double.isNaN(((LatLon)object3).lon())) continue;
                        ((WayPoint)object22).customColoring = color;
                        if (object5 != null) {
                            double d2 = ((LatLon)object3).greatCircleDistance(((WayPoint)object5).getCoor());
                            switch (colorModes2) {
                                case velocity: {
                                    d = ((WayPoint)object22).time - ((WayPoint)object5).time;
                                    double d3 = d2 / d;
                                    double d4 = d3 / (double)n4 * 255.0;
                                    if (d <= 0.0 || d3 < 0.0 || d4 > 255.0) {
                                        ((WayPoint)object22).customColoring = colors[255];
                                        break;
                                    }
                                    ((WayPoint)object22).customColoring = colors[(int)d4];
                                    break;
                                }
                                case dilution: {
                                    int n5;
                                    if (((WayPoint)object22).attr.get("hdop") == null) break;
                                    float f = ((Float)((WayPoint)object22).attr.get("hdop")).floatValue();
                                    if (f < 0.0f) {
                                        f = 0.0f;
                                    }
                                    int n6 = 255 - ((n5 = Math.round(f * (float)Main.pref.getInteger("hdop.factor", 25))) > 255 ? 255 : n5);
                                    ((WayPoint)object22).customColoring = colors[n6];
                                }
                            }
                            if (n2 == -1 || d2 <= (double)n2) {
                                ((WayPoint)object22).drawLine = true;
                                ((WayPoint)object22).dir = (int)((WayPoint)object5).getCoor().heading(((WayPoint)object22).getCoor());
                            } else {
                                ((WayPoint)object22).drawLine = false;
                            }
                        } else {
                            ((WayPoint)object22).drawLine = false;
                        }
                        object5 = object22;
                    }
                }
            }
            this.computeCacheInSync = true;
        }
        if (bl3) {
            object5 = null;
            for (GpxTrack gpxTrack : this.data.tracks) {
                for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                    for (Object object22 : collection) {
                        object3 = ((WayPoint)object22).getCoor();
                        if (Double.isNaN(((LatLon)object3).lat()) || Double.isNaN(((LatLon)object3).lon())) continue;
                        Point point2 = mapView.getPoint(((WayPoint)object22).getEastNorth());
                        if (((WayPoint)object22).drawLine && object5 != null && (((Point)object5).x != point2.x || ((Point)object5).y != point2.y)) {
                            graphics.setColor(((WayPoint)object22).customColoring);
                            graphics.drawLine(((Point)object5).x, ((Point)object5).y, point2.x, point2.y);
                        }
                        object5 = point2;
                    }
                }
            }
        }
        if (bl3 && bl2 && !bl6) {
            object5 = null;
            Object var17_21 = null;
            for (GpxTrack gpxTrack : this.data.tracks) {
                for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                    for (Object object3 : collection) {
                        void var17_22;
                        LatLon latLon = ((WayPoint)object3).getCoor();
                        if (Double.isNaN(latLon.lat()) || Double.isNaN(latLon.lon()) || !((WayPoint)object3).drawLine) continue;
                        point = mapView.getPoint(((WayPoint)object3).getEastNorth());
                        if (object5 != null && (var17_22 == null || point.x < var17_22.x - n3 || point.x > var17_22.x + n3 || point.y < var17_22.y - n3 || point.y > var17_22.y + n3)) {
                            graphics.setColor(((WayPoint)object3).customColoring);
                            d = Math.atan2(point.y - ((Point)object5).y, point.x - ((Point)object5).x) + Math.PI;
                            graphics.drawLine(point.x, point.y, (int)((double)point.x + 10.0 * Math.cos(d - PHI)), (int)((double)point.y + 10.0 * Math.sin(d - PHI)));
                            graphics.drawLine(point.x, point.y, (int)((double)point.x + 10.0 * Math.cos(d + PHI)), (int)((double)point.y + 10.0 * Math.sin(d + PHI)));
                            Point point3 = point;
                        }
                        object5 = point;
                    }
                }
            }
        }
        if (bl3 && bl2 && bl6) {
            object5 = null;
            Object var17_25 = null;
            for (GpxTrack gpxTrack : this.data.tracks) {
                for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                    for (Object object3 : collection) {
                        void var17_26;
                        LatLon latLon = ((WayPoint)object3).getCoor();
                        if (Double.isNaN(latLon.lat()) || Double.isNaN(latLon.lon()) || !((WayPoint)object3).drawLine) continue;
                        point = mapView.getPoint(((WayPoint)object3).getEastNorth());
                        if (object5 != null && (var17_26 == null || point.x < var17_26.x - n3 || point.x > var17_26.x + n3 || point.y < var17_26.y - n3 || point.y > var17_26.y + n3)) {
                            graphics.setColor(((WayPoint)object3).customColoring);
                            graphics.drawLine(point.x, point.y, point.x + dir[((WayPoint)object3).dir][0], point.y + dir[((WayPoint)object3).dir][1]);
                            graphics.drawLine(point.x, point.y, point.x + dir[((WayPoint)object3).dir][2], point.y + dir[((WayPoint)object3).dir][3]);
                            Point point4 = point;
                        }
                        object5 = point;
                    }
                }
            }
        }
        if (bl4 || bl5) {
            graphics.setColor(color);
            for (GpxTrack gpxTrack : this.data.tracks) {
                for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                    for (WayPoint wayPoint : collection) {
                        object22 = wayPoint.getCoor();
                        if (Double.isNaN(((LatLon)object22).lat()) || Double.isNaN(((LatLon)object22).lon())) continue;
                        object3 = mapView.getPoint(wayPoint.getEastNorth());
                        graphics.setColor(wayPoint.customColoring);
                        if (bl5 && wayPoint.attr.get("hdop") != null) {
                            float f = ((Float)wayPoint.attr.get("hdop")).floatValue();
                            if (f < 0.0f) {
                                f = 0.0f;
                            }
                            int n7 = mapView.getPoint((LatLon)new LatLon((double)wayPoint.getCoor().lat(), (double)(wayPoint.getCoor().lon() + (double)(12.0f * f * 360.0f / 4.0E7f)))).x - ((Point)object3).x;
                            graphics.drawArc(((Point)object3).x - n7 / 2, ((Point)object3).y - n7 / 2, n7, n7, 0, 360);
                        }
                        if (!bl4) continue;
                        graphics.fillRect(((Point)object3).x - 1, ((Point)object3).y - 1, 3, 3);
                    }
                }
            }
        }
        if (!bl4 && bl3) {
            graphics.setColor(color);
            for (GpxTrack gpxTrack : this.data.tracks) {
                for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                    for (WayPoint wayPoint : collection) {
                        object22 = wayPoint.getCoor();
                        if (Double.isNaN(((LatLon)object22).lat()) || Double.isNaN(((LatLon)object22).lon()) || wayPoint.drawLine) continue;
                        object3 = mapView.getPoint(wayPoint.getEastNorth());
                        graphics.drawRect(((Point)object3).x, ((Point)object3).y, 0, 0);
                    }
                }
            }
        }
        if (!bl4 && !bl3) {
            graphics.setColor(color);
            for (GpxTrack gpxTrack : this.data.tracks) {
                for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                    for (WayPoint wayPoint : collection) {
                        object22 = wayPoint.getCoor();
                        if (Double.isNaN(((LatLon)object22).lat()) || Double.isNaN(((LatLon)object22).lon())) continue;
                        object3 = mapView.getPoint(wayPoint.getEastNorth());
                        graphics.setColor(wayPoint.customColoring);
                        graphics.drawRect(((Point)object3).x, ((Point)object3).y, 0, 0);
                    }
                }
            }
        }
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        boundingXYVisitor.visit(this.data.recalculateBounds());
    }

    @Override
    public File getAssociatedFile() {
        return this.data.storageFile;
    }

    @Override
    public void setAssociatedFile(File file) {
        this.data.storageFile = file;
    }

    private static void addToDownload(Area area, Rectangle2D rectangle2D, Collection<Rectangle2D> collection, double d) {
        Area area2 = new Area(rectangle2D);
        area2.intersect(area);
        if (area2.isEmpty()) {
            return;
        }
        Rectangle2D rectangle2D2 = area2.getBounds2D();
        if (rectangle2D2.getWidth() * rectangle2D2.getHeight() > d) {
            Rectangle2D.Double double_;
            Rectangle2D.Double double_2;
            if (rectangle2D2.getWidth() > rectangle2D2.getHeight()) {
                double_2 = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth() / 2.0, rectangle2D2.getHeight());
                double_ = new Rectangle2D.Double(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0, rectangle2D2.getY(), rectangle2D2.getWidth() / 2.0, rectangle2D2.getHeight());
            } else {
                double_2 = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight() / 2.0);
                double_ = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0, rectangle2D2.getWidth(), rectangle2D2.getHeight() / 2.0);
            }
            GpxLayer.addToDownload(area, double_2, collection, d);
            GpxLayer.addToDownload(area, double_, collection, d);
        } else {
            collection.add(rectangle2D2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void importAudio(File file, MarkerLayer markerLayer, double d, Markers markers) {
        WayPoint wayPoint;
        WayPoint wayPoint2;
        String string = "file:".concat(file.getAbsolutePath());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        boolean bl2 = false;
        double d2 = Main.pref.getDouble("marker.audiofromuntimedwaypoints.distance", 0.001);
        WayPoint wayPoint3 = null;
        double d3 = -1.0;
        if (this.data.tracks != null && !this.data.tracks.isEmpty()) {
            for (GpxTrack object2 : this.data.tracks) {
                if (object2.trackSegs == null) continue;
                for (Collection<WayPoint> collection : object2.trackSegs) {
                    Iterator<WayPoint> iterator = collection.iterator();
                    if (iterator.hasNext()) {
                        WayPoint wayPoint4 = iterator.next();
                        d3 = wayPoint4.time;
                    }
                    if (!(d3 >= 0.0)) continue;
                    break;
                }
                if (!(d3 >= 0.0)) continue;
                break;
            }
        }
        if (d3 < 0.0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No GPX track available in layer to associate audio with."), I18n.tr("Error"), 0);
            return;
        }
        if (Main.pref.getBoolean("marker.audiofromexplicitwaypoints", true) && this.data.waypoints != null && !this.data.waypoints.isEmpty()) {
            for (WayPoint wayPoint5 : this.data.waypoints) {
                if (wayPoint5.time > d3) {
                    arrayList.add(wayPoint5);
                    continue;
                }
                if (!(wayPoint5.time > 0.0)) continue;
                bl = true;
            }
        }
        if (Main.pref.getBoolean("marker.audiofromuntimedwaypoints", true) && this.data.waypoints != null && !this.data.waypoints.isEmpty()) {
            for (WayPoint wayPoint6 : this.data.waypoints) {
                if (arrayList.contains(wayPoint6)) continue;
                WayPoint wayPoint7 = this.nearestPointOnTrack(wayPoint6.getEastNorth(), d2);
                if (wayPoint7 != null) {
                    Collection<WayPoint> collection;
                    collection = new WayPoint(wayPoint6.getCoor());
                    ((WayPoint)((Object)collection)).time = wayPoint7.time;
                    if (wayPoint6.attr.containsKey("name")) {
                        ((WayPoint)((Object)collection)).attr.put("name", wayPoint6.getString("name"));
                    }
                    arrayList.add(collection);
                    continue;
                }
                bl2 = true;
            }
        }
        if (Main.pref.getBoolean("marker.audiofromnamedtrackpoints", false) && this.data.tracks != null && !this.data.tracks.isEmpty()) {
            for (GpxTrack gpxTrack : this.data.tracks) {
                if (gpxTrack.trackSegs == null) continue;
                for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                    for (WayPoint wayPoint8 : collection) {
                        if (!wayPoint8.attr.containsKey("name") && !wayPoint8.attr.containsKey("desc")) continue;
                        arrayList.add(wayPoint8);
                    }
                }
            }
        }
        if (Main.pref.getBoolean("marker.audiofromwavtimestamps", false) && this.data.tracks != null && !this.data.tracks.isEmpty()) {
            double d4 = (double)file.lastModified() / 1000.0;
            double d5 = AudioUtil.getCalibratedDuration(file);
            double d6 = d4 - d5;
            d6 = d + (d6 - d) / Main.pref.getDouble("audio.calibration", "1.0");
            wayPoint2 = null;
            wayPoint = null;
            block7: for (GpxTrack gpxTrack : this.data.tracks) {
                if (gpxTrack.trackSegs == null) continue;
                for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                    for (WayPoint wayPoint9 : collection) {
                        if (d6 < wayPoint9.time) {
                            wayPoint = wayPoint9;
                            break;
                        }
                        wayPoint2 = wayPoint9;
                    }
                    if (wayPoint == null) continue;
                    continue block7;
                }
            }
            if (wayPoint2 == null || wayPoint == null) {
                bl = true;
            } else {
                wayPoint3 = new WayPoint(wayPoint2.getCoor().interpolate(wayPoint.getCoor(), (d6 - wayPoint2.time) / (wayPoint.time - wayPoint2.time)));
                wayPoint3.time = d6;
                Object object = file.getName();
                int n = ((String)object).lastIndexOf(".");
                if (n > 0) {
                    object = ((String)object).substring(0, n);
                }
                wayPoint3.attr.put("name", object);
                arrayList.add(wayPoint3);
            }
        }
        if ((Main.pref.getBoolean("marker.audiofromstart") || arrayList.isEmpty()) && this.data.tracks != null && !this.data.tracks.isEmpty()) {
            boolean bl3 = false;
            for (GpxTrack gpxTrack : this.data.tracks) {
                if (gpxTrack.trackSegs == null) continue;
                for (Collection collection : gpxTrack.trackSegs) {
                    Iterator iterator = collection.iterator();
                    if (iterator.hasNext()) {
                        wayPoint2 = (WayPoint)iterator.next();
                        wayPoint = new WayPoint(wayPoint2.getCoor());
                        wayPoint.attr.put("name", "start");
                        wayPoint.time = wayPoint2.time;
                        arrayList.add(wayPoint);
                        bl3 = true;
                    }
                    if (!bl3) continue;
                    break;
                }
                if (!bl3) continue;
                break;
            }
        }
        Collections.sort(arrayList, new Comparator<WayPoint>(){

            @Override
            public int compare(WayPoint wayPoint, WayPoint wayPoint2) {
                return wayPoint.time <= wayPoint2.time ? -1 : 1;
            }
        });
        d3 = -1.0;
        for (WayPoint wayPoint10 : arrayList) {
            void var19_47;
            if (d3 < 0.0) {
                d3 = wayPoint10.time;
            }
            double d7 = wayPoint10.time - d3;
            if (wayPoint10.attr.containsKey("name")) {
                String string2 = wayPoint10.getString("name");
            } else if (wayPoint10.attr.containsKey("desc")) {
                String string3 = wayPoint10.getString("desc");
            } else {
                String string4 = AudioMarker.inventName(d7);
            }
            AudioMarker audioMarker = AudioMarker.create(wayPoint10.getCoor(), (String)var19_47, string, markerLayer, wayPoint10.time, d7);
            if (wayPoint10 == wayPoint3) {
                audioMarker.timeFromAudio = true;
            }
            markerLayer.data.add(audioMarker);
        }
        if (bl && !markers.timedMarkersOmitted) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Some waypoints with timestamps from before the start of the track or after the end were omitted or moved to the start."));
            markers.timedMarkersOmitted = bl;
        }
        if (bl2 && !markers.untimedMarkersOmitted) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Some waypoints which were too far from the track to sensibly estimate their time were omitted."));
            markers.untimedMarkersOmitted = bl2;
        }
    }

    public WayPoint nearestPointOnTrack(EastNorth eastNorth, double d) {
        double d2 = d * d;
        Object object = null;
        double d3 = 0.0;
        double d4 = eastNorth.east();
        double d5 = eastNorth.north();
        double d6 = 0.0;
        double d7 = 0.0;
        if (this.data.tracks == null) {
            return null;
        }
        for (GpxTrack gpxTrack : this.data.tracks) {
            if (gpxTrack.trackSegs == null) continue;
            for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                double d8;
                double d9;
                double d10;
                WayPoint wayPoint = null;
                Object object2 = collection.iterator();
                while (object2.hasNext()) {
                    double d11;
                    WayPoint wayPoint2 = object2.next();
                    EastNorth eastNorth2 = wayPoint2.getEastNorth();
                    if (wayPoint == null) {
                        wayPoint = wayPoint2;
                        d6 = eastNorth2.east();
                        d10 = d4 - d6;
                        d11 = d10 * d10 + (d9 = d5 - (d7 = eastNorth2.north())) * d9;
                        if (!(d11 < d2)) continue;
                        d2 = d11;
                        object = eastNorth2;
                        d3 = wayPoint.time;
                        continue;
                    }
                    double d12 = eastNorth2.east();
                    double d13 = eastNorth2.north();
                    d11 = d13 - d7;
                    double d14 = d6 - d12;
                    double d15 = -d11 * d6 - d14 * d7;
                    double d16 = d11 * d11 + d14 * d14;
                    if (d16 == 0.0) continue;
                    double d17 = d11 * d4 + d14 * d5 + d15;
                    if ((d17 = d17 * d17 / d16) < d2) {
                        d10 = d4 - d6;
                        d9 = d5 - d7;
                        double d18 = d10 * d10 + d9 * d9;
                        d10 = d4 - d12;
                        d9 = d5 - d13;
                        double d19 = d10 * d10 + d9 * d9;
                        if (d18 - d17 <= d16 && d19 - d17 <= d16) {
                            double d20 = Math.sqrt((d18 - d17) / d16);
                            double d21 = d6 - d20 * d14;
                            double d22 = d7 + d20 * d11;
                            object = new EastNorth(d21, d22);
                            d3 = wayPoint.time + d20 * (wayPoint2.time - wayPoint.time);
                            d2 = d17;
                        }
                    }
                    wayPoint = wayPoint2;
                    d6 = d12;
                    d7 = d13;
                }
                if (wayPoint == null || !((d8 = (d10 = d4 - (d6 = ((EastNorth)(object2 = wayPoint.getEastNorth())).east())) * d10 + (d9 = d5 - (d7 = ((EastNorth)object2).north())) * d9) < d2)) continue;
                d2 = d8;
                object = object2;
                d3 = wayPoint.time;
            }
        }
        if (object == null) {
            return null;
        }
        WayPoint wayPoint = new WayPoint(Main.proj.eastNorth2latlon((EastNorth)object));
        wayPoint.time = d3;
        return wayPoint;
    }

    static {
        for (int i = 0; i < colors.length; ++i) {
            GpxLayer.colors[i] = Color.getHSBColor((float)i / 300.0f, 1.0f, 1.0f);
        }
        ll0 = 9;
        sl4 = 5;
        sl9 = 3;
        dir = new int[][]{{sl4, ll0, ll0, sl4}, {-sl9, ll0, sl9, ll0}, {-ll0, sl4, -sl4, ll0}, {-ll0, -sl9, -ll0, sl9}, {-sl4, -ll0, -ll0, -sl4}, {sl9, -ll0, -sl9, -ll0}, {ll0, -sl4, sl4, -ll0}, {ll0, sl9, ll0, -sl9}, {sl4, ll0, ll0, sl4}, {-sl9, ll0, sl9, ll0}, {-ll0, sl4, -sl4, ll0}, {-ll0, -sl9, -ll0, sl9}};
    }

    public class DownloadAlongTrackAction
    extends AbstractAction {
        public DownloadAlongTrackAction() {
            super(I18n.tr("Download from OSM along this track"), ImageProvider.get("downloadalongtrack"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            Integer[] integerArray = new Integer[]{5000, 500, 50};
            Integer[] integerArray2 = new Integer[]{20, 10, 5, 1};
            jPanel.add((Component)new JLabel(I18n.tr("Download everything within:")), GBC.eol());
            String[] stringArray = new String[integerArray.length];
            for (int i = 0; i < integerArray.length; ++i) {
                stringArray[i] = I18n.tr("{0} meters", integerArray[i]);
            }
            JList<String> jList = new JList<String>(stringArray);
            jPanel.add(jList, GBC.eol());
            jPanel.add((Component)new JLabel(I18n.tr("Maximum area per request:")), GBC.eol());
            stringArray = new String[integerArray2.length];
            for (int i = 0; i < integerArray2.length; ++i) {
                stringArray[i] = I18n.tr("{0} sq km", integerArray2[i]);
            }
            JList<String> jList2 = new JList<String>(stringArray);
            jPanel.add(jList2, GBC.eol());
            int n = JOptionPane.showConfirmDialog(Main.parent, jPanel, I18n.tr("Download from OSM along this track"), 2, 3);
            switch (n) {
                case -1: 
                case 2: {
                    return;
                }
            }
            double d = 0.0;
            int n2 = 0;
            for (GpxTrack gpxTrack : GpxLayer.this.data.tracks) {
                for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                    for (WayPoint wayPoint : collection) {
                        d += wayPoint.getCoor().lat();
                        ++n2;
                    }
                }
            }
            double d2 = d / (double)n2;
            double d3 = Math.cos(Math.toRadians(d2));
            Object object = jList.getSelectedIndex();
            int n3 = integerArray[(Integer)object < 0 ? 0 : (Integer)object];
            double d4 = (double)n3 / 100000.0;
            double d5 = d4 / d3;
            object = jList2.getSelectedIndex();
            double d6 = (double)integerArray2[(Integer)object < 0 ? 0 : (Integer)object].intValue() / 10000.0 / d3;
            Area area = new Area();
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            LatLon latLon = null;
            for (GpxTrack gpxTrack : GpxLayer.this.data.tracks) {
                for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                    for (WayPoint wayPoint : collection) {
                        LatLon latLon2 = wayPoint.getCoor();
                        if (latLon != null && !(latLon2.greatCircleDistance(latLon) > (double)n3)) continue;
                        ((Rectangle2D)double_).setRect(latLon2.lon() - d5, latLon2.lat() - d4, 2.0 * d5, 2.0 * d4);
                        area.add(new Area(double_));
                        latLon = latLon2;
                    }
                }
            }
            ArrayList arrayList = new ArrayList();
            GpxLayer.addToDownload(area, area.getBounds(), arrayList, d6);
            jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JLabel(I18n.tr("<html>This action will require {0} individual<br>download requests. Do you wish<br>to continue?</html>", arrayList.size())), GBC.eol());
            if (arrayList.size() > 1) {
                n = JOptionPane.showConfirmDialog(Main.parent, jPanel, I18n.tr("Download from OSM along this track"), 2, -1);
                switch (n) {
                    case -1: 
                    case 2: {
                        return;
                    }
                }
            }
            new DownloadOsmTaskList().download(false, arrayList, (ProgressMonitor)new PleaseWaitProgressMonitor(I18n.tr("Download data")));
        }
    }

    public class ConvertToDataLayerAction
    extends AbstractAction {
        public ConvertToDataLayerAction() {
            super(I18n.tr("Convert to data layer"), ImageProvider.get("converttoosm"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JLabel(I18n.tr("<html>Upload of unprocessed GPS data as map data is considered harmful.<br>If you want to upload traces, look here:")), GBC.eol());
            jPanel.add((Component)new UrlLabel(I18n.tr("http://www.openstreetmap.org/traces")), GBC.eop());
            if (!ConditionalOptionPaneUtil.showConfirmationDialog("convert_to_data", Main.parent, jPanel, I18n.tr("Warning"), 2, 2, 0)) {
                return;
            }
            DataSet dataSet = new DataSet();
            for (GpxTrack gpxTrack : GpxLayer.this.data.tracks) {
                for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                    ArrayList<Node> arrayList = new ArrayList<Node>();
                    for (WayPoint wayPoint : collection) {
                        Node node = new Node(wayPoint.getCoor());
                        String string = wayPoint.getString("time");
                        if (string != null) {
                            node.setTimestamp(DateUtils.fromString(string));
                        }
                        dataSet.nodes.add(node);
                        arrayList.add(node);
                    }
                    Way way = new Way();
                    way.setNodes(arrayList);
                    dataSet.ways.add(way);
                }
            }
            Main.main.addLayer(new OsmDataLayer(dataSet, I18n.tr("Converted from: {0}", GpxLayer.this.getName()), GpxLayer.this.getAssociatedFile()));
            Main.main.removeLayer(GpxLayer.this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum colorModes {
        none,
        velocity,
        dilution;

    }

    private class Markers {
        public boolean timedMarkersOmitted = false;
        public boolean untimedMarkersOmitted = false;

        private Markers() {
        }
    }
}

