/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.UrlLabel;

public class VersionInfoPanel
extends JPanel
implements Observer {
    private PointInTimeType pointInTimeType;
    private HistoryBrowserModel model;
    private JLabel lblInfo;
    private UrlLabel lblUser;
    private UrlLabel lblChangeset;

    protected void build() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.lblInfo = new JLabel();
        this.lblInfo.setHorizontalAlignment(2);
        jPanel.add(this.lblInfo);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        this.lblUser = new UrlLabel();
        jPanel2.add(new JLabel(I18n.tr("User")));
        jPanel2.add(this.lblUser);
        jPanel2.add(new JLabel(I18n.tr("Changeset")));
        this.lblChangeset = new UrlLabel();
        jPanel2.add(this.lblChangeset);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)jPanel2, gridBagConstraints);
    }

    protected HistoryOsmPrimitive getPrimitive() {
        if (this.model == null || this.pointInTimeType == null) {
            return null;
        }
        return this.model.getPointInTime(this.pointInTimeType);
    }

    protected String getInfoText() {
        HistoryOsmPrimitive historyOsmPrimitive = this.getPrimitive();
        if (historyOsmPrimitive == null) {
            return "";
        }
        String string = I18n.tr("<html>Version <strong>{0}</strong> created on <strong>{1}</strong></html>", Long.toString(historyOsmPrimitive.getVersion()), new SimpleDateFormat().format(historyOsmPrimitive.getTimestamp()));
        return string;
    }

    public VersionInfoPanel() {
        this.pointInTimeType = null;
        this.model = null;
        this.build();
    }

    public VersionInfoPanel(HistoryBrowserModel historyBrowserModel, PointInTimeType pointInTimeType) throws IllegalArgumentException {
        if (pointInTimeType == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "pointInTimeType"));
        }
        if (historyBrowserModel == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "model"));
        }
        this.model = historyBrowserModel;
        this.pointInTimeType = pointInTimeType;
        historyBrowserModel.addObserver(this);
        this.build();
    }

    public void update(Observable observable, Object object) {
        this.lblInfo.setText(this.getInfoText());
        String string = AbstractInfoAction.getBaseBrowseUrl() + "/changeset/" + this.getPrimitive().getChangesetId();
        this.lblChangeset.setUrl(string);
        this.lblChangeset.setDescription(Long.toString(this.getPrimitive().getChangesetId()));
        try {
            if (this.getPrimitive().getUid() != -1L) {
                string = AbstractInfoAction.getBaseUserUrl() + "/" + URLEncoder.encode(this.getPrimitive().getUser(), "UTF-8").replaceAll("\\+", "%20");
                this.lblUser.setUrl(string);
            } else {
                this.lblUser.setUrl(null);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            this.lblUser.setUrl(null);
        }
        this.lblUser.setDescription(this.getPrimitive().getUser());
    }
}

