/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.history.HistoryBrowser;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class HistoryBrowserDialog
extends JDialog
implements HistoryDataSetListener {
    private HistoryBrowser browser;

    protected void renderTitle(History history) {
        String string = "";
        switch (history.getEarliest().getType()) {
            case NODE: {
                string = I18n.marktr("History for node {0}");
                break;
            }
            case WAY: {
                string = I18n.marktr("History for way {0}");
                break;
            }
            case RELATION: {
                string = I18n.marktr("History for relation {0}");
            }
        }
        this.setTitle(I18n.tr(string, Long.toString(history.getId())));
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.browser = new HistoryBrowser();
        this.add((Component)this.browser, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        SideButton sideButton = new SideButton(new ReloadAction());
        sideButton.setName("btn.reload");
        jPanel.add(sideButton);
        sideButton = new SideButton(new CloseAction());
        sideButton.setName("btn.close");
        jPanel.add(sideButton);
        this.add((Component)jPanel, "South");
        this.setSize(800, 500);
    }

    public HistoryBrowserDialog(History history) {
        super(JOptionPane.getFrameForComponent(Main.parent), false);
        this.build();
        this.setHistory(history);
        this.renderTitle(history);
        HistoryDataSet.getInstance().addHistoryDataSetListener(this);
        this.addWindowListener(new WindowClosingAdapter());
    }

    protected void setHistory(History history) {
        this.browser.populate(history);
    }

    public void historyUpdated(HistoryDataSet historyDataSet, long l) {
        if (l == this.browser.getHistory().getId()) {
            this.browser.populate(historyDataSet.getHistory(l));
        } else if (l == 0L) {
            this.browser.populate(historyDataSet.getHistory(this.browser.getHistory().getId()));
        }
    }

    public HistoryBrowser getHistoryBrowser() {
        return this.browser;
    }

    class WindowClosingAdapter
    extends WindowAdapter {
        WindowClosingAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            HistoryDataSet.getInstance().removeHistoryDataSetListener(HistoryBrowserDialog.this);
            HistoryBrowserDialogManager.getInstance().hide(HistoryBrowserDialog.this);
        }
    }

    class ReloadAction
    extends AbstractAction {
        public ReloadAction() {
            this.putValue("Name", I18n.tr("Reload"));
            this.putValue("ShortDescription", I18n.tr("Reload the history from the server"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HistoryLoadTask historyLoadTask = new HistoryLoadTask();
            historyLoadTask.add(HistoryBrowserDialog.this.browser.getHistory());
            Main.worker.submit(historyLoadTask);
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            this.putValue("Name", I18n.tr("Close"));
            this.putValue("ShortDescription", I18n.tr("Close the dialog"));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HistoryDataSet.getInstance().removeHistoryDataSetListener(HistoryBrowserDialog.this);
            HistoryBrowserDialogManager.getInstance().hide(HistoryBrowserDialog.this);
        }
    }
}

