/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class RelationDialogManager
extends WindowAdapter
implements Layer.LayerChangeListener {
    static RelationDialogManager relationDialogManager;
    private HashMap<DialogContext, RelationEditor> openDialogs = new HashMap();

    public static RelationDialogManager getRelationDialogManager() {
        if (relationDialogManager == null) {
            relationDialogManager = new RelationDialogManager();
            Layer.listeners.add(relationDialogManager);
        }
        return relationDialogManager;
    }

    public void register(OsmDataLayer osmDataLayer, Relation relation, RelationEditor relationEditor) {
        if (relation == null) {
            relation = new Relation();
        }
        DialogContext dialogContext = new DialogContext(osmDataLayer, relation);
        this.openDialogs.put(dialogContext, relationEditor);
        relationEditor.addWindowListener(this);
    }

    public void updateContext(OsmDataLayer osmDataLayer, Relation relation, RelationEditor relationEditor) {
        for (DialogContext dialogContext : this.openDialogs.keySet()) {
            if (this.openDialogs.get(dialogContext) != relationEditor) continue;
            this.openDialogs.remove(dialogContext);
            break;
        }
        DialogContext dialogContext = new DialogContext(osmDataLayer, relation);
        this.openDialogs.put(dialogContext, relationEditor);
    }

    public void close(OsmDataLayer osmDataLayer, Relation relation) {
        DialogContext dialogContext = new DialogContext(osmDataLayer, relation);
        RelationEditor relationEditor = this.openDialogs.get(dialogContext);
        if (relationEditor != null) {
            relationEditor.setVisible(false);
        }
    }

    public boolean isOpenInEditor(OsmDataLayer osmDataLayer, Relation relation) {
        if (relation == null) {
            return false;
        }
        DialogContext dialogContext = new DialogContext(osmDataLayer, relation);
        return this.openDialogs.keySet().contains(dialogContext);
    }

    public RelationEditor getEditorForRelation(OsmDataLayer osmDataLayer, Relation relation) {
        if (relation == null) {
            return null;
        }
        DialogContext dialogContext = new DialogContext(osmDataLayer, relation);
        return this.openDialogs.get(dialogContext);
    }

    public void layerRemoved(Layer layer) {
        if (layer == null || !(layer instanceof OsmDataLayer)) {
            return;
        }
        OsmDataLayer osmDataLayer = (OsmDataLayer)layer;
        Iterator<Map.Entry<DialogContext, RelationEditor>> iterator = this.openDialogs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<DialogContext, RelationEditor> entry = iterator.next();
            if (!entry.getKey().matchesLayer(osmDataLayer)) continue;
            RelationEditor relationEditor = entry.getValue();
            iterator.remove();
            relationEditor.setVisible(false);
            relationEditor.dispose();
        }
    }

    public void activeLayerChange(Layer layer, Layer layer2) {
    }

    public void layerAdded(Layer layer) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        RelationEditor relationEditor = (RelationEditor)windowEvent.getWindow();
        DialogContext dialogContext = null;
        for (DialogContext dialogContext2 : this.openDialogs.keySet()) {
            if (!this.openDialogs.get(dialogContext2).equals(relationEditor)) continue;
            dialogContext = dialogContext2;
            break;
        }
        if (dialogContext != null) {
            this.openDialogs.remove(dialogContext);
        }
    }

    protected void centerOnScreen(RelationEditor relationEditor) {
        Point point = new Point(0, 0);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        point.x = (dimension.width - relationEditor.getSize().width) / 2;
        point.y = (dimension.height - relationEditor.getSize().height) / 2;
        point.x = Math.max(point.x, 0);
        point.y = Math.max(point.y, 0);
        relationEditor.setLocation(point);
    }

    protected boolean hasEditorWithCloseUpperLeftCorner(Point point) {
        for (RelationEditor relationEditor : this.openDialogs.values()) {
            Point point2 = relationEditor.getLocation();
            if (point.x < point2.x - 5 || point2.x + 5 < point.x || point.y < point2.y - 5 || point2.y + 5 < point.y) continue;
            return true;
        }
        return false;
    }

    protected void positionCloseToScreenCenter(RelationEditor relationEditor) {
        Point point = new Point(0, 0);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        point.x = (dimension.width - relationEditor.getSize().width) / 2;
        point.y = (dimension.height - relationEditor.getSize().height) / 2;
        point.x = Math.max(point.x, 0);
        point.y = Math.max(point.y, 0);
        while (this.hasEditorWithCloseUpperLeftCorner(point)) {
            point.x += 20;
            point.y += 20;
        }
        relationEditor.setLocation(point);
    }

    public void positionOnScreen(RelationEditor relationEditor) {
        if (relationEditor == null) {
            return;
        }
        if (this.openDialogs.isEmpty()) {
            this.centerOnScreen(relationEditor);
        } else {
            this.positionCloseToScreenCenter(relationEditor);
        }
    }

    private static class DialogContext {
        public Relation relation;
        public OsmDataLayer layer;

        public DialogContext(OsmDataLayer osmDataLayer, Relation relation) {
            this.layer = osmDataLayer;
            this.relation = relation;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.layer == null ? 0 : this.layer.hashCode());
            n = 31 * n + (this.relation == null ? 0 : this.relation.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            DialogContext dialogContext = (DialogContext)object;
            if (this.layer == null ? dialogContext.layer != null : !this.layer.equals(dialogContext.layer)) {
                return false;
            }
            return !(this.relation == null ? dialogContext.relation != null : !this.relation.equals(dialogContext.relation));
        }

        public boolean matchesLayer(OsmDataLayer osmDataLayer) {
            if (osmDataLayer == null) {
                return false;
            }
            return this.layer.equals(osmDataLayer);
        }

        public String toString() {
            return "[Context: layer=" + this.layer.getName() + ",relation=" + this.relation.getId() + "]";
        }
    }
}

