/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.visitor.MergeVisitor;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerBackreferenceReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentRelationLoadingTask
extends PleaseWaitRunnable {
    private boolean cancelled;
    private Exception lastException;
    private DataSet referrers;
    private boolean full;
    private OsmDataLayer layer;
    private Relation child;
    private ArrayList<Relation> parents;
    private Runnable continuation;

    public ParentRelationLoadingTask(Relation relation, OsmDataLayer osmDataLayer, boolean bl, PleaseWaitProgressMonitor pleaseWaitProgressMonitor) {
        super(I18n.tr("Download referring relations"), pleaseWaitProgressMonitor, false);
        if (relation == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "child"));
        }
        if (osmDataLayer == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "layer"));
        }
        if (relation.getId() == 0L) {
            throw new IllegalArgumentException(I18n.tr("Value of child.getId() > 0 expected. Got {1}.", relation.getId()));
        }
        this.referrers = null;
        this.layer = osmDataLayer;
        this.parents = new ArrayList();
        this.child = relation;
    }

    public void setContinuation(Runnable runnable) {
        this.continuation = runnable;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean hasError() {
        return this.lastException != null;
    }

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    public List<Relation> getParents() {
        return this.parents;
    }

    @Override
    protected void cancel() {
        this.cancelled = true;
        OsmApi.getOsmApi().cancel();
    }

    protected void showLastException() {
        String string = this.lastException.getMessage();
        if (string == null) {
            string = this.lastException.toString();
        }
        JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Error"), 0);
    }

    @Override
    protected void finish() {
        if (this.cancelled) {
            return;
        }
        if (this.lastException != null) {
            this.showLastException();
            return;
        }
        this.parents.clear();
        for (Relation relation : this.referrers.relations) {
            this.parents.add((Relation)this.getLayer().data.getPrimitiveById(relation.getId(), OsmPrimitiveType.RELATION));
        }
        if (this.continuation != null) {
            this.continuation.run();
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            this.progressMonitor.indeterminateSubTask(null);
            OsmServerBackreferenceReader osmServerBackreferenceReader = new OsmServerBackreferenceReader(this.child, this.full);
            this.referrers = osmServerBackreferenceReader.parseOsm(this.progressMonitor.createSubTaskMonitor(1, false));
            if (this.referrers != null) {
                MergeVisitor mergeVisitor = new MergeVisitor(this.getLayer().data, this.referrers);
                mergeVisitor.merge();
                for (DataSource dataSource : this.referrers.dataSources) {
                    this.getLayer().data.dataSources.add(dataSource);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ParentRelationLoadingTask.this.getLayer().fireDataChange();
                    }
                });
                if (mergeVisitor.getConflicts().isEmpty()) {
                    return;
                }
                this.getLayer().getConflicts().add(mergeVisitor.getConflicts());
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("There were {0} conflicts during import.", mergeVisitor.getConflicts().size()), I18n.tr("Warning"), 2);
            }
        }
        catch (Exception exception) {
            if (this.cancelled) {
                System.out.println(I18n.tr("Warning: Ignoring exception because task is cancelled. Exception: {0}", exception.toString()));
                return;
            }
            this.lastException = exception;
        }
    }
}

