/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.DefaultListSelectionModel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.relation.IMemberModelListener;
import org.openstreetmap.josm.gui.dialogs.relation.RelationNodeMap;
import org.openstreetmap.josm.gui.dialogs.relation.WayConnectionType;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberTableModel
extends AbstractTableModel {
    private ArrayList<RelationMember> members = new ArrayList();
    private DefaultListSelectionModel listSelectionModel;
    private CopyOnWriteArrayList<IMemberModelListener> listeners = new CopyOnWriteArrayList();
    private OsmDataLayer layer;

    public MemberTableModel(OsmDataLayer osmDataLayer) {
        this.layer = osmDataLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberModelListener(IMemberModelListener iMemberModelListener) {
        CopyOnWriteArrayList<IMemberModelListener> copyOnWriteArrayList = this.listeners;
        synchronized (copyOnWriteArrayList) {
            if (iMemberModelListener != null && !this.listeners.contains(iMemberModelListener)) {
                this.listeners.add(iMemberModelListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberModelListener(IMemberModelListener iMemberModelListener) {
        CopyOnWriteArrayList<IMemberModelListener> copyOnWriteArrayList = this.listeners;
        synchronized (copyOnWriteArrayList) {
            if (iMemberModelListener != null && this.listeners.contains(iMemberModelListener)) {
                this.listeners.remove(iMemberModelListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMakeMemberVisible(int n) {
        CopyOnWriteArrayList<IMemberModelListener> copyOnWriteArrayList = this.listeners;
        synchronized (copyOnWriteArrayList) {
            for (IMemberModelListener iMemberModelListener : this.listeners) {
                iMemberModelListener.makeMemberVisible(n);
            }
        }
    }

    public void populate(Relation relation) {
        this.members.clear();
        if (relation != null) {
            this.members.addAll(new Relation(relation).getMembers());
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.members.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.members.get(n).getRole();
            }
            case 1: {
                return this.members.get(n).getMember();
            }
            case 2: {
                return this.linked(n);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        RelationMember relationMember = this.members.get(n);
        RelationMember relationMember2 = new RelationMember(object.toString(), relationMember.getMember());
        this.members.remove(n);
        this.members.add(n, relationMember2);
    }

    public OsmPrimitive getReferredPrimitive(int n) {
        return this.members.get(n).getMember();
    }

    public void moveUp(int[] nArray) {
        if (!this.canMoveUp(nArray)) {
            return;
        }
        for (int n : nArray) {
            RelationMember relationMember = this.members.get(n);
            RelationMember relationMember2 = this.members.get(n - 1);
            this.members.set(n, relationMember2);
            this.members.set(n - 1, relationMember);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int n : nArray) {
            this.getSelectionModel().addSelectionInterval(--n, n);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(nArray[0] - 1);
    }

    public void moveDown(int[] nArray) {
        if (!this.canMoveDown(nArray)) {
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            RelationMember relationMember = this.members.get(n);
            RelationMember relationMember2 = this.members.get(n + 1);
            this.members.set(n, relationMember2);
            this.members.set(n + 1, relationMember);
        }
        this.fireTableDataChanged();
        this.getSelectionModel();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int n : nArray) {
            this.getSelectionModel().addSelectionInterval(++n, n);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(nArray[0] + 1);
    }

    public void remove(int[] nArray) {
        if (!this.canRemove(nArray)) {
            return;
        }
        int n = 0;
        for (int n2 : nArray) {
            this.members.remove(n2 -= n);
            ++n;
        }
        this.fireTableDataChanged();
    }

    public boolean canMoveUp(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        Arrays.sort(nArray);
        return nArray[0] > 0 && this.members.size() > 0;
    }

    public boolean canMoveDown(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        Arrays.sort(nArray);
        return this.members.size() > 0 && nArray[nArray.length - 1] < this.members.size() - 1;
    }

    public boolean canRemove(int[] nArray) {
        return nArray != null && nArray.length != 0;
    }

    public DefaultListSelectionModel getSelectionModel() {
        if (this.listSelectionModel == null) {
            this.listSelectionModel = new DefaultListSelectionModel();
            this.listSelectionModel.setSelectionMode(2);
        }
        return this.listSelectionModel;
    }

    public void updateMemberReferences(DataSet dataSet) {
        for (int i = 0; i < this.members.size(); ++i) {
            OsmPrimitive osmPrimitive;
            RelationMember relationMember = this.members.get(i);
            if (relationMember.getMember().getId() == 0L || (osmPrimitive = dataSet.getPrimitiveById(relationMember.getMember().getId(), OsmPrimitiveType.from(relationMember.getMember()))) == null) continue;
            RelationMember relationMember2 = new RelationMember(relationMember.getRole(), osmPrimitive);
            this.members.remove(i);
            this.members.add(i, relationMember2);
        }
        this.fireTableDataChanged();
    }

    public void removeMembersReferringTo(List<? extends OsmPrimitive> list) {
        if (list == null) {
            return;
        }
        Iterator<RelationMember> iterator = this.members.iterator();
        while (iterator.hasNext()) {
            RelationMember relationMember = iterator.next();
            if (!list.contains(relationMember.getMember())) continue;
            iterator.remove();
        }
        this.fireTableDataChanged();
    }

    public void applyToRelation(Relation relation) {
        relation.setMembers(this.members);
    }

    public boolean hasSameMembersAs(Relation relation) {
        if (relation == null) {
            return false;
        }
        if (relation.getMembersCount() != this.members.size()) {
            return false;
        }
        for (int i = 0; i < relation.getMembersCount(); ++i) {
            if (relation.getMember(i).equals(this.members.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean hasIncompleteMembers() {
        for (RelationMember relationMember : this.members) {
            if (!relationMember.getMember().incomplete) continue;
            return true;
        }
        return false;
    }

    protected List<Integer> getSelectedIndices() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.members.size(); ++i) {
            if (!this.getSelectionModel().isSelectedIndex(i)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    public void addMembersAtBeginning(List<OsmPrimitive> list) {
        if (list == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : list) {
            RelationMember relationMember = new RelationMember("", osmPrimitive);
            this.members.add(0, relationMember);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < list.size(); ++i) {
            this.getSelectionModel().addSelectionInterval(i, i);
        }
        this.fireMakeMemberVisible(0);
    }

    public void addMembersAtEnd(List<? extends OsmPrimitive> list) {
        if (list == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : list) {
            RelationMember relationMember = new RelationMember("", osmPrimitive);
            this.members.add(relationMember);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < list.size(); ++i) {
            this.getSelectionModel().addSelectionInterval(this.members.size() - 1 - i, this.members.size() - 1 - i);
        }
        this.fireMakeMemberVisible(this.members.size() - 1);
    }

    public void addMembersBeforeIdx(List<? extends OsmPrimitive> list, int n) {
        if (list == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : list) {
            RelationMember relationMember = new RelationMember("", osmPrimitive);
            this.members.add(n, relationMember);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < list.size(); ++i) {
            this.getSelectionModel().addSelectionInterval(n + i, n + i);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(n);
    }

    public void addMembersAfterIdx(List<? extends OsmPrimitive> list, int n) {
        if (list == null) {
            return;
        }
        int n2 = 1;
        for (OsmPrimitive osmPrimitive : list) {
            RelationMember relationMember = new RelationMember("", osmPrimitive);
            this.members.add(n + n2, relationMember);
            ++n2;
        }
        this.fireTableDataChanged();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < list.size(); ++i) {
            this.getSelectionModel().addSelectionInterval(n + 1 + i, n + 1 + i);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(n + 1);
    }

    public int getNumMembersWithPrimitive(OsmPrimitive osmPrimitive) {
        int n = 0;
        for (RelationMember relationMember : this.members) {
            if (!relationMember.getMember().equals(osmPrimitive)) continue;
            ++n;
        }
        return n;
    }

    public void updateRole(int[] nArray, String string) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        for (int n : nArray) {
            RelationMember relationMember = this.members.get(n);
            RelationMember relationMember2 = new RelationMember(string, relationMember.getMember());
            this.members.remove(n);
            this.members.add(n, relationMember2);
        }
        this.fireTableDataChanged();
        for (int n : nArray) {
            this.getSelectionModel().addSelectionInterval(n, n);
        }
    }

    public Collection<RelationMember> getSelectedMembers() {
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
        for (int n : this.getSelectedIndices()) {
            arrayList.add(this.members.get(n));
        }
        return arrayList;
    }

    public Set<OsmPrimitive> getSelectedChildPrimitives() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (RelationMember relationMember : this.getSelectedMembers()) {
            hashSet.add(relationMember.getMember());
        }
        return hashSet;
    }

    public Set<OsmPrimitive> getChildPrimitives(Collection<? extends OsmPrimitive> collection) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        if (collection == null) {
            return null;
        }
        for (RelationMember relationMember : this.members) {
            if (!collection.contains(relationMember.getMember())) continue;
            hashSet.add(relationMember.getMember());
        }
        return hashSet;
    }

    public boolean selectionsAreInSync() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(this.getSelectedChildPrimitives());
        if (hashSet.size() != this.layer.data.getSelected().size()) {
            return false;
        }
        hashSet.removeAll(this.layer.data.getSelected());
        return hashSet.isEmpty();
    }

    public void setSelectedMembers(Collection<RelationMember> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (RelationMember relationMember : collection) {
            for (int i = 0; i < this.members.size(); ++i) {
                if (!this.members.get(i).equals(relationMember) || arrayList.contains(i)) continue;
                arrayList.add(i);
            }
        }
        Collections.sort(arrayList);
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        Iterator<RelationMember> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)((Object)iterator.next());
            this.getSelectionModel().addSelectionInterval(n, n);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        if (arrayList.size() > 0) {
            this.fireMakeMemberVisible((Integer)arrayList.get(0));
        }
    }

    public boolean isEditableRelation(int n) {
        if (n < 0 || n >= this.members.size()) {
            return false;
        }
        RelationMember relationMember = this.members.get(n);
        if (!relationMember.isRelation()) {
            return false;
        }
        Relation relation = relationMember.getRelation();
        return !relation.incomplete;
    }

    public boolean hasMembersReferringTo(Collection<OsmPrimitive> collection) {
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (RelationMember object : this.members) {
            hashSet.add(object.getMember());
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (!hashSet.contains(osmPrimitive)) continue;
            return true;
        }
        return false;
    }

    public void selectMembersReferringTo(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            return;
        }
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < this.members.size(); ++i) {
            RelationMember relationMember = this.members.get(i);
            if (!collection.contains(relationMember.getMember())) continue;
            this.getSelectionModel().addSelectionInterval(i, i);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        if (this.getSelectedIndices().size() > 0) {
            this.fireMakeMemberVisible(this.getSelectedIndices().get(0));
        }
    }

    protected boolean isActiveLayer() {
        if (Main.map == null || Main.map.mapView == null) {
            return false;
        }
        return Main.map.mapView.getActiveLayer() == this.layer;
    }

    private static Node getUnusedNode(RelationMember relationMember, RelationMember relationMember2) {
        Node node = null;
        if (relationMember.isWay()) {
            Way way = relationMember.getWay();
            if (relationMember2.isWay()) {
                Way way2 = relationMember2.getWay();
                node = way.firstNode() == way2.firstNode() || way.firstNode() == way2.lastNode() ? way.lastNode() : way.firstNode();
            } else if (relationMember2.isNode()) {
                Node node2 = relationMember2.getNode();
                node = way.firstNode() == node2 ? way.lastNode() : way.firstNode();
            }
        } else if (relationMember.isNode()) {
            Node node3;
            node = node3 = relationMember.getNode();
        }
        return node;
    }

    void sort() {
        LinkedList<Object> linkedList;
        Serializable serializable;
        RelationNodeMap relationNodeMap = new RelationNodeMap(this.members);
        if (relationNodeMap.isEmpty()) {
            return;
        }
        Vector vector = new Vector();
        while (!relationNodeMap.isEmpty()) {
            boolean bl;
            if (vector.size() == 0 && relationNodeMap.remove(0, this.members.get(0))) {
                serializable = Integer.valueOf(0);
            } else {
                serializable = relationNodeMap.pop();
                if (serializable == null) break;
            }
            linkedList = new LinkedList();
            linkedList.add(serializable);
            vector.add(linkedList);
            do {
                Object object;
                bl = false;
                Node node = null;
                Node object2 = null;
                if (linkedList.size() == 1) {
                    object = this.members.get((Integer)linkedList.getFirst());
                    if (((RelationMember)object).isWay()) {
                        Way way = ((RelationMember)object).getWay();
                        object2 = way.lastNode();
                        if (way.lastNode() != way.firstNode()) {
                            node = way.firstNode();
                        }
                    } else if (((RelationMember)object).isNode()) {
                        Node node2;
                        object2 = node2 = ((RelationMember)object).getNode();
                    }
                } else {
                    node = MemberTableModel.getUnusedNode(this.members.get((Integer)linkedList.getFirst()), this.members.get((Integer)linkedList.get(1)));
                    object2 = MemberTableModel.getUnusedNode(this.members.get((Integer)linkedList.getLast()), this.members.get((Integer)linkedList.get(linkedList.size() - 2)));
                }
                if (node != null && (object = relationNodeMap.find(node, (Integer)linkedList.getFirst())) != null) {
                    linkedList.add(0, object);
                    relationNodeMap.remove((Integer)object, this.members.get((Integer)object));
                    bl = true;
                }
                if (object2 == null || (object = relationNodeMap.find(object2, (Integer)linkedList.getLast())) == null) continue;
                linkedList.add(linkedList.size(), object);
                relationNodeMap.remove((Integer)object, this.members.get((Integer)object));
                bl = true;
            } while (bl);
        }
        if (vector.size() > 0) {
            linkedList = new LinkedList<Object>();
            linkedList.addAll(relationNodeMap.getRemaining());
            vector.add(linkedList);
            serializable = new ArrayList();
            for (LinkedList linkedList2 : vector) {
                for (Integer n : linkedList2) {
                    ((ArrayList)serializable).add(this.members.get(n));
                }
            }
            this.members.clear();
            this.members.addAll((Collection<RelationMember>)((Object)serializable));
            this.fireTableDataChanged();
        }
    }

    private WayConnectionType linked(int n) {
        WayConnectionType wayConnectionType = WayConnectionType.none;
        RelationMember relationMember = this.members.get(n);
        RelationMember relationMember2 = this.members.get((n + 1) % this.members.size());
        Way way = null;
        Way way2 = null;
        if (relationMember.isWay()) {
            way = relationMember.getWay();
        }
        if (relationMember2.isWay()) {
            way2 = relationMember2.getWay();
        }
        if (way != null && way2 != null) {
            Node node = way.firstNode();
            Node node2 = way.lastNode();
            Node node3 = way2.firstNode();
            Node node4 = way2.lastNode();
            if (node != null && node3 != null && node == node3) {
                wayConnectionType = WayConnectionType.tail_to_tail;
            } else if (node != null && node4 != null && node == node4) {
                wayConnectionType = WayConnectionType.tail_to_head;
            } else if (node2 != null && node3 != null && node2 == node3) {
                wayConnectionType = WayConnectionType.head_to_tail;
            } else if (node2 != null && node4 != null && node2 == node4) {
                wayConnectionType = WayConnectionType.head_to_head;
            }
        }
        return wayConnectionType;
    }
}

