/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialog;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class HistoryDialog
extends ToggleDialog
implements HistoryDataSetListener {
    protected HistoryItemTableModel model;
    protected JTable historyTable;
    protected ShowHistoryAction showHistoryAction;
    protected ReloadAction reloadAction;

    protected JPanel buildButtonRow() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        this.reloadAction = new ReloadAction();
        SideButton sideButton = new SideButton(this.reloadAction);
        sideButton.setName("btn.reload");
        jPanel.add(sideButton);
        this.showHistoryAction = new ShowHistoryAction();
        sideButton = new SideButton(this.showHistoryAction);
        sideButton.setName("btn.showhistory");
        jPanel.add(sideButton);
        return jPanel;
    }

    protected void build() {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this.model = new HistoryItemTableModel(defaultListSelectionModel);
        this.historyTable = new JTable(this.model, new HistoryTableColumnModel(), defaultListSelectionModel);
        this.historyTable.setSelectionMode(2);
        this.historyTable.setName("table.historyitems");
        final TableCellRenderer tableCellRenderer = this.historyTable.getTableHeader().getDefaultRenderer();
        this.historyTable.getTableHeader().setDefaultRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (!object.equals("")) {
                    return jComponent;
                }
                JLabel jLabel = new JLabel(ImageProvider.get("misc", "showhide"));
                jLabel.setForeground(jComponent.getForeground());
                jLabel.setBackground(jComponent.getBackground());
                jLabel.setFont(jComponent.getFont());
                jLabel.setBorder(jComponent.getBorder());
                jLabel.setOpaque(true);
                return jLabel;
            }
        });
        this.historyTable.addMouseListener(new ShowHistoryMouseAdapter());
        JScrollPane jScrollPane = new JScrollPane(this.historyTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.historyTable.setTableHeader(null);
        jScrollPane.setColumnHeaderView(null);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.buildButtonRow(), "South");
        this.historyTable.getSelectionModel().addListSelectionListener(this.showHistoryAction);
        this.historyTable.getSelectionModel().addListSelectionListener(this.reloadAction);
    }

    public HistoryDialog() {
        super(I18n.tr("History"), "history", I18n.tr("Display the history of all selected items."), Shortcut.registerShortcut("subwindow:history", I18n.tr("Toggle: {0}", I18n.tr("History")), 72, 4, 1), 150);
        this.build();
        DataSet.selListeners.add(this.model);
        HistoryDataSet.getInstance().addHistoryDataSetListener(this);
    }

    public void historyUpdated(HistoryDataSet historyDataSet, long l) {
        this.model.refresh();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShowHistoryAction
    extends AbstractAction
    implements ListSelectionListener {
        public ShowHistoryAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "history"));
            this.putValue("Name", I18n.tr("Show"));
            this.putValue("ShortDescription", I18n.tr("Display the history of the selected objects."));
            this.updateEnabledState();
        }

        protected List<OsmPrimitive> filterPrimitivesWithUnloadedHistory(Collection<OsmPrimitive> collection) {
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(collection.size());
            for (OsmPrimitive osmPrimitive : collection) {
                if (HistoryDataSet.getInstance().getHistory(osmPrimitive.getId()) != null) continue;
                arrayList.add(osmPrimitive);
            }
            return arrayList;
        }

        protected void showHistory(History history) throws IllegalArgumentException {
            if (history == null) {
                throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "h"));
            }
            if (HistoryBrowserDialogManager.getInstance().existsDialog(history.getId())) {
                HistoryBrowserDialogManager.getInstance().show(history.getId());
            } else {
                HistoryBrowserDialog historyBrowserDialog = new HistoryBrowserDialog(history);
                HistoryBrowserDialogManager.getInstance().show(history.getId(), historyBrowserDialog);
            }
        }

        public void showHistory(final List<OsmPrimitive> list) {
            Runnable runnable;
            List<OsmPrimitive> list2 = this.filterPrimitivesWithUnloadedHistory(list);
            if (!list2.isEmpty()) {
                runnable = new HistoryLoadTask();
                runnable.add(list);
                Main.worker.submit(runnable);
            }
            runnable = new Runnable(){

                public void run() {
                    for (OsmPrimitive osmPrimitive : list) {
                        History history = HistoryDataSet.getInstance().getHistory(osmPrimitive.getId());
                        if (history == null) continue;
                        ShowHistoryAction.this.showHistory(history);
                    }
                }
            };
            Main.worker.submit(runnable);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = HistoryDialog.this.historyTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            this.showHistory(HistoryDialog.this.model.getPrimitives(nArray));
        }

        protected void updateEnabledState() {
            this.setEnabled(HistoryDialog.this.historyTable.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class ShowHistoryMouseAdapter
    extends MouseAdapter {
        ShowHistoryMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                int n = HistoryDialog.this.historyTable.rowAtPoint(mouseEvent.getPoint());
                new ShowHistoryAction().showHistory(Collections.singletonList(HistoryDialog.this.model.getPrimitive(n)));
            }
        }
    }

    class ReloadAction
    extends AbstractAction
    implements ListSelectionListener {
        public ReloadAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
            this.putValue("Name", I18n.tr("Reload"));
            this.putValue("ShortDescription", I18n.tr("Reload all currently selected objects and refresh the list."));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = HistoryDialog.this.historyTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            List<OsmPrimitive> list = HistoryDialog.this.model.getPrimitives(nArray);
            HistoryLoadTask historyLoadTask = new HistoryLoadTask();
            historyLoadTask.add(list);
            Main.worker.execute(historyLoadTask);
        }

        protected void updateEnabledState() {
            this.setEnabled(HistoryDialog.this.historyTable.getSelectedRowCount() > 0);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class HistoryTableColumnModel
    extends DefaultTableColumnModel {
        protected void createColumns() {
            TableColumn tableColumn = null;
            OsmPrimitivRenderer osmPrimitivRenderer = new OsmPrimitivRenderer();
            tableColumn = new TableColumn(0);
            tableColumn.setHeaderValue(I18n.tr("Object with history"));
            tableColumn.setCellRenderer(osmPrimitivRenderer);
            this.addColumn(tableColumn);
        }

        public HistoryTableColumnModel() {
            this.createColumns();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HistoryItemTableModel
    extends DefaultTableModel
    implements SelectionChangedListener {
        private ArrayList<OsmPrimitive> data = new ArrayList();
        private DefaultListSelectionModel selectionModel;

        public HistoryItemTableModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.selectionModel = defaultListSelectionModel;
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data.get(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        protected List<OsmPrimitive> getSelectedPrimitives() {
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
            for (int i = 0; i < this.data.size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                arrayList.add(this.data.get(i));
            }
            return arrayList;
        }

        protected void selectPrimitives(Collection<OsmPrimitive> collection) {
            for (OsmPrimitive osmPrimitive : collection) {
                int n = this.data.indexOf(osmPrimitive);
                if (n < 0) continue;
                this.selectionModel.addSelectionInterval(n, n);
            }
        }

        public void refresh() {
            List<OsmPrimitive> list = this.getSelectedPrimitives();
            this.data.clear();
            if (Main.main.getCurrentDataSet() == null) {
                return;
            }
            for (OsmPrimitive osmPrimitive : Main.main.getCurrentDataSet().getSelected()) {
                if (osmPrimitive.getId() == 0L) continue;
                this.data.add(osmPrimitive);
            }
            this.fireTableDataChanged();
            this.selectPrimitives(list);
        }

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
            this.refresh();
        }

        public List<OsmPrimitive> getPrimitives(int[] nArray) {
            if (nArray == null || nArray.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(nArray.length);
            for (int n : nArray) {
                arrayList.add(this.data.get(n));
            }
            return arrayList;
        }

        public OsmPrimitive getPrimitive(int n) {
            return this.data.get(n);
        }
    }
}

