/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.MultiSplitLayout;
import org.openstreetmap.josm.gui.MultiSplitPane;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogsPanel
extends JPanel {
    protected List<ToggleDialog> allDialogs = new ArrayList<ToggleDialog>();
    protected MultiSplitPane mSpltPane = new MultiSplitPane();
    protected final int DIVIDER_SIZE = 5;
    private List<JPanel> panels = new ArrayList<JPanel>();
    private boolean initialized = false;

    public void initialize(List<ToggleDialog> list) {
        JPanel jPanel;
        if (this.initialized) {
            throw new IllegalStateException();
        }
        this.initialized = true;
        this.allDialogs = list;
        Integer n = 0;
        while (n < list.size()) {
            jPanel = list.get(n);
            ((ToggleDialog)jPanel).setDialogsPanel(this);
            jPanel.setVisible(false);
            n = n + 1;
        }
        for (int i = 0; i < list.size() + 1; ++i) {
            jPanel = new JPanel(){

                public Dimension getMinimumSize() {
                    return new Dimension(0, 40);
                }
            };
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setVisible(false);
            this.mSpltPane.add((Component)jPanel, "L" + i);
            this.panels.add(jPanel);
        }
        Integer n2 = 0;
        while (n2 < list.size()) {
            jPanel = list.get(n2);
            if (((ToggleDialog)jPanel).isDialogShowing()) {
                ((ToggleDialog)jPanel).showDialog();
                if (((ToggleDialog)jPanel).isDialogInCollapsedView()) {
                    ((ToggleDialog)jPanel).collapse();
                }
            } else {
                ((ToggleDialog)jPanel).hideDialog();
            }
            n2 = n2 + 1;
        }
        this.add(this.mSpltPane);
        this.reconstruct(Action.ELEMENT_SHRINKS, null);
    }

    public void reconstruct(Action action, ToggleDialog toggleDialog) {
        int n;
        int n2;
        int n3;
        int n4;
        JPanel jPanel;
        int n5;
        int n6 = this.allDialogs.size();
        for (n5 = 0; n5 < n6; ++n5) {
            jPanel = this.panels.get(n5);
            jPanel.removeAll();
            jPanel.setVisible(false);
        }
        n5 = n6 - 1;
        jPanel = this.panels.get(n5);
        n5 = -1;
        for (n4 = n6 - 1; n4 >= 0; --n4) {
            ToggleDialog toggleDialog2 = this.allDialogs.get(n4);
            if (toggleDialog2.isDialogInDefaultView()) {
                if (n5 == -1) {
                    n5 = n6 - 1;
                } else {
                    jPanel = this.panels.get(--n5);
                }
                jPanel.add((Component)toggleDialog2, 0);
                jPanel.setVisible(true);
                continue;
            }
            if (!toggleDialog2.isDialogInCollapsedView()) continue;
            jPanel.add((Component)toggleDialog2, 0);
            jPanel.setVisible(true);
        }
        if (n5 == -1) {
            n5 = n6 - 1;
        }
        n4 = n6 - n5;
        if (action == Action.ELEMENT_SHRINKS) {
            for (n3 = 0; n3 < n6; ++n3) {
                ToggleDialog toggleDialog3 = this.allDialogs.get(n3);
                if (!toggleDialog3.isDialogInDefaultView()) continue;
                n2 = toggleDialog3.getPreferredHeight();
                n = toggleDialog3.getSize().height;
                toggleDialog3.setPreferredSize(new Dimension(Integer.MAX_VALUE, n < 20 ? n2 : n));
            }
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            ToggleDialog toggleDialog4;
            int n11;
            int n12;
            int n13;
            if (toggleDialog == null) {
                throw new IllegalArgumentException();
            }
            n3 = 0;
            int n14 = 0;
            n2 = 0;
            for (n = 0; n < n6; ++n) {
                ToggleDialog toggleDialog5 = this.allDialogs.get(n);
                if (toggleDialog5.isDialogInDefaultView()) {
                    if (toggleDialog5 == toggleDialog) continue;
                    n13 = toggleDialog5.getPreferredHeight();
                    n12 = toggleDialog5.getSize().height;
                    n3 += n13;
                    n14 += n12;
                    continue;
                }
                if (!toggleDialog5.isDialogInCollapsedView()) continue;
                n2 += toggleDialog5.getSize().height;
            }
            n = this.mSpltPane.getMultiSplitLayout().getModel().getBounds().getSize().height;
            int n15 = n - (n4 - 1) * 5 - n2;
            n13 = toggleDialog.getPreferredHeight();
            if (n13 <= 0) {
                throw new IllegalStateException();
            }
            n12 = n13 * n15 / (n13 + n3);
            toggleDialog.setPreferredSize(new Dimension(Integer.MAX_VALUE, n12));
            int n16 = n15 - n12;
            int n17 = 0;
            int n18 = 0;
            for (n11 = 0; n11 < n6; ++n11) {
                toggleDialog4 = this.allDialogs.get(n11);
                if (!toggleDialog4.isDialogInDefaultView() || toggleDialog4 == toggleDialog) continue;
                n10 = toggleDialog4.getSize().height;
                n9 = n10 * n16 / n14;
                n8 = toggleDialog4.getPreferredHeight() * n15 / (n3 + n13);
                if (n9 < n8) {
                    n7 = Math.min(n10, n8);
                    n17 += n7 - n9;
                    continue;
                }
                n18 += n9 - n8;
            }
            for (n11 = 0; n11 < n6; ++n11) {
                toggleDialog4 = this.allDialogs.get(n11);
                if (!toggleDialog4.isDialogInDefaultView() || toggleDialog4 == toggleDialog) continue;
                n10 = toggleDialog4.getSize().height;
                n9 = n10 * n16 / n14;
                n8 = toggleDialog4.getPreferredHeight() * n15 / (n3 + n13);
                if (n9 < n8) {
                    n7 = Math.min(n10, n8);
                    toggleDialog4.setPreferredSize(new Dimension(Integer.MAX_VALUE, n7));
                    continue;
                }
                try {
                    n7 = (n9 - n8) * n17 / n18;
                }
                catch (ArithmeticException arithmeticException) {
                    n7 = 0;
                }
                toggleDialog4.setPreferredSize(new Dimension(Integer.MAX_VALUE, n9 - n7));
            }
        }
        ArrayList<MultiSplitLayout.Node> arrayList = new ArrayList<MultiSplitLayout.Node>();
        for (int i = n5; i <= n6 - 1; ++i) {
            if (i != n5) {
                arrayList.add(new MultiSplitLayout.Divider());
            }
            MultiSplitLayout.Leaf leaf = new MultiSplitLayout.Leaf("L" + i);
            leaf.setWeight(1.0 / (double)n4);
            arrayList.add(leaf);
        }
        if (n4 == 1) {
            MultiSplitLayout.Node node = (MultiSplitLayout.Node)arrayList.get(0);
            this.mSpltPane.getMultiSplitLayout().setModel(node);
        } else {
            MultiSplitLayout.Split split = new MultiSplitLayout.Split();
            split.setRowLayout(false);
            split.setChildren(arrayList);
            this.mSpltPane.getMultiSplitLayout().setModel(split);
        }
        this.mSpltPane.getMultiSplitLayout().setDividerSize(5);
        this.mSpltPane.getMultiSplitLayout().setFloatingDividers(true);
        this.mSpltPane.revalidate();
    }

    public void destroy() {
        for (ToggleDialog toggleDialog : this.allDialogs) {
            toggleDialog.closeDetachedDialog();
        }
    }

    public <T> T getToggleDialog(Class<T> clazz) {
        for (ToggleDialog toggleDialog : this.allDialogs) {
            if (!clazz.isInstance(toggleDialog)) continue;
            return clazz.cast(toggleDialog);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        INVISIBLE_TO_DEFAULT,
        COLLAPSED_TO_DEFAULT,
        ELEMENT_SHRINKS;

    }
}

