/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.tags;

import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.tools.I18n;

public class TagMergeItem {
    private String key = null;
    private String myTagValue = null;
    private String theirTagValue = null;
    private MergeDecisionType mergeDecision = MergeDecisionType.UNDECIDED;

    public TagMergeItem(String string, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "key"));
        }
        this.key = string;
        this.myTagValue = string2;
        this.theirTagValue = string3;
        this.mergeDecision = MergeDecisionType.UNDECIDED;
    }

    public TagMergeItem(String string, OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        if (string == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "key"));
        }
        if (osmPrimitive == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "my"));
        }
        if (osmPrimitive2 == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "their"));
        }
        this.key = string;
        this.myTagValue = osmPrimitive.get(string);
        this.theirTagValue = osmPrimitive2.get(string);
    }

    public void decide(MergeDecisionType mergeDecisionType) throws IllegalArgumentException {
        if (mergeDecisionType == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "decision"));
        }
        this.mergeDecision = mergeDecisionType;
    }

    public String getKey() {
        return this.key;
    }

    public String getMyTagValue() {
        return this.myTagValue;
    }

    public String getTheirTagValue() {
        return this.theirTagValue;
    }

    public MergeDecisionType getMergeDecision() {
        return this.mergeDecision;
    }

    public void applyToMyPrimitive(OsmPrimitive osmPrimitive) throws IllegalArgumentException, IllegalStateException {
        if (osmPrimitive == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "primitive"));
        }
        if (this.mergeDecision == MergeDecisionType.UNDECIDED) {
            throw new IllegalStateException(I18n.tr("Cannot apply undecided tag merge item."));
        }
        if (this.mergeDecision == MergeDecisionType.KEEP_THEIR) {
            if (this.theirTagValue == null) {
                osmPrimitive.remove(this.key);
            } else if (this.theirTagValue != null) {
                osmPrimitive.put(this.key, this.theirTagValue);
            }
        } else if (this.mergeDecision == MergeDecisionType.KEEP_MINE) {
            if (this.myTagValue == null) {
                osmPrimitive.remove(this.key);
            } else if (this.myTagValue != null) {
                osmPrimitive.put(this.key, this.myTagValue);
            }
        }
    }
}

