/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.properties.PropertiesMergeModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class PropertiesMerger
extends JPanel
implements Observer {
    private static DecimalFormat COORD_FORMATTER = new DecimalFormat("###0.0000");
    public static final Color BGCOLOR_NO_CONFLICT = new Color(234, 234, 234);
    public static final Color BGCOLOR_UNDECIDED = new Color(255, 197, 197);
    public static final Color BGCOLOR_DECIDED = new Color(217, 255, 217);
    private JLabel lblMyVersion;
    private JLabel lblMergedVersion;
    private JLabel lblTheirVersion;
    private JLabel lblMyCoordinates;
    private JLabel lblMergedCoordinates;
    private JLabel lblTheirCoordinates;
    private JLabel lblMyDeletedState;
    private JLabel lblMergedDeletedState;
    private JLabel lblTheirDeletedState;
    private JLabel lblMyVisibleState;
    private JLabel lblMergedVisibleState;
    private JLabel lblTheirVisibleState;
    private final PropertiesMergeModel model = new PropertiesMergeModel();

    protected JLabel buildValueLabel(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setName(string);
        jLabel.setHorizontalAlignment(0);
        jLabel.setOpaque(true);
        jLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        return jLabel;
    }

    protected void buildHeaderRow() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.lblMyVersion = new JLabel(I18n.tr("My version"));
        this.lblMyVersion.setToolTipText(I18n.tr("Properties in my dataset, i.e. the local dataset"));
        this.add((Component)this.lblMyVersion, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.lblMergedVersion = new JLabel(I18n.tr("Merged version"));
        this.lblMergedVersion.setToolTipText(I18n.tr("Properties in the merged element. They will replace properties in my elements when merge decisions are applied."));
        this.add((Component)this.lblMergedVersion, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        this.lblTheirVersion = new JLabel(I18n.tr("Their version"));
        this.lblTheirVersion.setToolTipText(I18n.tr("Properties in their dataset, i.e. the server dataset"));
        this.add((Component)this.lblTheirVersion, gridBagConstraints);
    }

    protected void buildCoordinateConflictRows() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)new JLabel(I18n.tr("Coordinates:")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        this.lblMyCoordinates = this.buildValueLabel("label.mycoordinates");
        this.add((Component)this.lblMyCoordinates, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        KeepMyCoordinatesAction keepMyCoordinatesAction = new KeepMyCoordinatesAction();
        this.model.addObserver(keepMyCoordinatesAction);
        JButton jButton = new JButton(keepMyCoordinatesAction);
        jButton.setName("button.keepmycoordinates");
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        this.lblMergedCoordinates = this.buildValueLabel("label.mergedcoordinates");
        this.add((Component)this.lblMergedCoordinates, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        KeepTheirCoordinatesAction keepTheirCoordinatesAction = new KeepTheirCoordinatesAction();
        this.model.addObserver(keepTheirCoordinatesAction);
        JButton jButton2 = new JButton(keepTheirCoordinatesAction);
        this.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        this.lblTheirCoordinates = this.buildValueLabel("label.theircoordinates");
        this.add((Component)this.lblTheirCoordinates, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 20, 5);
        UndecideCoordinateConflictAction undecideCoordinateConflictAction = new UndecideCoordinateConflictAction();
        this.model.addObserver(undecideCoordinateConflictAction);
        JButton jButton3 = new JButton(undecideCoordinateConflictAction);
        this.add((Component)jButton3, gridBagConstraints);
    }

    protected void buildDeletedStateConflictRows() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)new JLabel(I18n.tr("Deleted State:")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        this.lblMyDeletedState = this.buildValueLabel("label.mydeletedstate");
        this.add((Component)this.lblMyDeletedState, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        KeepMyDeletedStateAction keepMyDeletedStateAction = new KeepMyDeletedStateAction();
        this.model.addObserver(keepMyDeletedStateAction);
        JButton jButton = new JButton(keepMyDeletedStateAction);
        jButton.setName("button.keepmydeletedstate");
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        this.lblMergedDeletedState = this.buildValueLabel("label.mergeddeletedstate");
        this.add((Component)this.lblMergedDeletedState, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        KeepTheirDeletedStateAction keepTheirDeletedStateAction = new KeepTheirDeletedStateAction();
        this.model.addObserver(keepTheirDeletedStateAction);
        JButton jButton2 = new JButton(keepTheirDeletedStateAction);
        jButton2.setName("button.keeptheirdeletedstate");
        this.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        this.lblTheirDeletedState = this.buildValueLabel("label.theirdeletedstate");
        this.add((Component)this.lblTheirDeletedState, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        UndecideDeletedStateConflictAction undecideDeletedStateConflictAction = new UndecideDeletedStateConflictAction();
        this.model.addObserver(undecideDeletedStateConflictAction);
        JButton jButton3 = new JButton(undecideDeletedStateConflictAction);
        jButton3.setName("button.undecidedeletedstate");
        this.add((Component)jButton3, gridBagConstraints);
    }

    protected void buildVisibleStateRows() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)new JLabel(I18n.tr("Visible State:")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        this.lblMyVisibleState = this.buildValueLabel("label.myvisiblestate");
        this.add((Component)this.lblMyVisibleState, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        KeepMyVisibleStateAction keepMyVisibleStateAction = new KeepMyVisibleStateAction();
        this.model.addObserver(keepMyVisibleStateAction);
        JButton jButton = new JButton(keepMyVisibleStateAction);
        jButton.setName("button.keepmyvisiblestate");
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        this.lblMergedVisibleState = this.buildValueLabel("label.mergedvisiblestate");
        this.add((Component)this.lblMergedVisibleState, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        KeepTheirVisibleStateAction keepTheirVisibleStateAction = new KeepTheirVisibleStateAction();
        this.model.addObserver(keepTheirVisibleStateAction);
        JButton jButton2 = new JButton(keepTheirVisibleStateAction);
        jButton2.setName("button.keeptheirvisiblestate");
        this.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        this.lblTheirVisibleState = this.buildValueLabel("label.theirvisiblestate");
        this.add((Component)this.lblTheirVisibleState, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        UndecideVisibleStateConflictAction undecideVisibleStateConflictAction = new UndecideVisibleStateConflictAction();
        this.model.addObserver(undecideVisibleStateConflictAction);
        JButton jButton3 = new JButton(undecideVisibleStateConflictAction);
        jButton3.setName("button.undecidevisiblestate");
        this.add((Component)jButton3, gridBagConstraints);
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.buildHeaderRow();
        this.buildCoordinateConflictRows();
        this.buildDeletedStateConflictRows();
        this.buildVisibleStateRows();
    }

    public PropertiesMerger() {
        this.model.addObserver(this);
        this.build();
    }

    public String coordToString(LatLon latLon) {
        if (latLon == null) {
            return I18n.tr("(none)");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append(COORD_FORMATTER.format(latLon.lat())).append(",").append(COORD_FORMATTER.format(latLon.lon())).append(")");
        return stringBuilder.toString();
    }

    public String deletedStateToString(Boolean bl) {
        if (bl == null) {
            return I18n.tr("(none)");
        }
        if (bl.booleanValue()) {
            return I18n.tr("deleted");
        }
        return I18n.tr("not deleted");
    }

    public String visibleStateToString(Boolean bl) {
        if (bl == null) {
            return I18n.tr("(none)");
        }
        if (bl.booleanValue()) {
            return I18n.tr("visible (on the server)");
        }
        return I18n.tr("not visible (on the server)");
    }

    public String visibleStateToStringMerged(Boolean bl) {
        if (bl == null) {
            return I18n.tr("(none)");
        }
        if (bl.booleanValue()) {
            return I18n.tr("Keep a clone of the local version");
        }
        return I18n.tr("Physically delete from local dataset");
    }

    protected void updateCoordinates() {
        this.lblMyCoordinates.setText(this.coordToString(this.model.getMyCoords()));
        this.lblMergedCoordinates.setText(this.coordToString(this.model.getMergedCoords()));
        this.lblTheirCoordinates.setText(this.coordToString(this.model.getTheirCoords()));
        if (!this.model.hasCoordConflict()) {
            this.lblMyCoordinates.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblMergedCoordinates.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblTheirCoordinates.setBackground(BGCOLOR_NO_CONFLICT);
        } else if (!this.model.isDecidedCoord()) {
            this.lblMyCoordinates.setBackground(BGCOLOR_UNDECIDED);
            this.lblMergedCoordinates.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblTheirCoordinates.setBackground(BGCOLOR_UNDECIDED);
        } else {
            this.lblMyCoordinates.setBackground(this.model.isCoordMergeDecision(MergeDecisionType.KEEP_MINE) ? BGCOLOR_DECIDED : BGCOLOR_NO_CONFLICT);
            this.lblMergedCoordinates.setBackground(BGCOLOR_DECIDED);
            this.lblTheirCoordinates.setBackground(this.model.isCoordMergeDecision(MergeDecisionType.KEEP_THEIR) ? BGCOLOR_DECIDED : BGCOLOR_NO_CONFLICT);
        }
    }

    protected void updateDeletedState() {
        this.lblMyDeletedState.setText(this.deletedStateToString(this.model.getMyDeletedState()));
        this.lblMergedDeletedState.setText(this.deletedStateToString(this.model.getMergedDeletedState()));
        this.lblTheirDeletedState.setText(this.deletedStateToString(this.model.getTheirDeletedState()));
        if (!this.model.hasDeletedStateConflict()) {
            this.lblMyDeletedState.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblMergedDeletedState.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblTheirDeletedState.setBackground(BGCOLOR_NO_CONFLICT);
        } else if (!this.model.isDecidedDeletedState()) {
            this.lblMyDeletedState.setBackground(BGCOLOR_UNDECIDED);
            this.lblMergedDeletedState.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblTheirDeletedState.setBackground(BGCOLOR_UNDECIDED);
        } else {
            this.lblMyDeletedState.setBackground(this.model.isDeletedStateDecision(MergeDecisionType.KEEP_MINE) ? BGCOLOR_DECIDED : BGCOLOR_NO_CONFLICT);
            this.lblMergedDeletedState.setBackground(BGCOLOR_DECIDED);
            this.lblTheirDeletedState.setBackground(this.model.isDeletedStateDecision(MergeDecisionType.KEEP_THEIR) ? BGCOLOR_DECIDED : BGCOLOR_NO_CONFLICT);
        }
    }

    protected void updateVisibleState() {
        this.lblMyVisibleState.setText(this.visibleStateToString(this.model.getMyVisibleState()));
        this.lblMergedVisibleState.setText(this.visibleStateToStringMerged(this.model.getMergedVisibleState()));
        this.lblTheirVisibleState.setText(this.visibleStateToString(this.model.getTheirVisibleState()));
        if (!this.model.hasVisibleStateConflict()) {
            this.lblMyVisibleState.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblMergedVisibleState.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblTheirVisibleState.setBackground(BGCOLOR_NO_CONFLICT);
        } else if (!this.model.isDecidedVisibleState()) {
            this.lblMyVisibleState.setBackground(BGCOLOR_UNDECIDED);
            this.lblMergedVisibleState.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblTheirVisibleState.setBackground(BGCOLOR_UNDECIDED);
        } else {
            this.lblMyVisibleState.setBackground(this.model.isVisibleStateDecision(MergeDecisionType.KEEP_MINE) ? BGCOLOR_DECIDED : BGCOLOR_NO_CONFLICT);
            this.lblMergedVisibleState.setBackground(BGCOLOR_DECIDED);
            this.lblTheirVisibleState.setBackground(this.model.isVisibleStateDecision(MergeDecisionType.KEEP_THEIR) ? BGCOLOR_DECIDED : BGCOLOR_NO_CONFLICT);
        }
    }

    public void update(Observable observable, Object object) {
        this.updateCoordinates();
        this.updateDeletedState();
        this.updateVisibleState();
    }

    public PropertiesMergeModel getModel() {
        return this.model;
    }

    class UndecideVisibleStateConflictAction
    extends AbstractAction
    implements Observer {
        public UndecideVisibleStateConflictAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagundecide"));
            this.putValue("ShortDescription", I18n.tr("Undecide conflict between visible state"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideVisibleStateConflict(MergeDecisionType.UNDECIDED);
        }

        public void update(Observable observable, Object object) {
            this.setEnabled(PropertiesMerger.this.model.hasVisibleStateConflict() && PropertiesMerger.this.model.isDecidedVisibleState());
        }
    }

    class KeepTheirVisibleStateAction
    extends AbstractAction
    implements Observer {
        public KeepTheirVisibleStateAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeeptheir"));
            this.putValue("ShortDescription", I18n.tr("Keep their visible state"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.confirmKeepTheir()) {
                PropertiesMerger.this.model.decideVisibleStateConflict(MergeDecisionType.KEEP_THEIR);
            }
        }

        public void update(Observable observable, Object object) {
            this.setEnabled(PropertiesMerger.this.model.hasVisibleStateConflict() && !PropertiesMerger.this.model.isDecidedVisibleState());
        }

        protected boolean confirmKeepTheir() {
            Object[] objectArray = new String[]{I18n.tr("Yes, purge it"), I18n.tr("No, abort")};
            int n = JOptionPane.showOptionDialog(null, I18n.tr("<html>JOSM will have to remove your local primitive with id {0}<br>from the dataset.<br>Do you agree?</html>", PropertiesMerger.this.model.getMyPrimitive().getId()), I18n.tr("Remove from dataset"), 0, 3, null, objectArray, objectArray[1]);
            return n == 0;
        }
    }

    class KeepMyVisibleStateAction
    extends AbstractAction
    implements Observer {
        public KeepMyVisibleStateAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeepmine"));
            this.putValue("ShortDescription", I18n.tr("Keep my visible state"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.confirmKeepMine()) {
                PropertiesMerger.this.model.decideVisibleStateConflict(MergeDecisionType.KEEP_MINE);
            }
        }

        public void update(Observable observable, Object object) {
            this.setEnabled(PropertiesMerger.this.model.hasVisibleStateConflict() && !PropertiesMerger.this.model.isDecidedVisibleState());
        }

        protected boolean confirmKeepMine() {
            Object[] objectArray = new String[]{I18n.tr("Yes, reset the id"), I18n.tr("No, abort")};
            int n = JOptionPane.showOptionDialog(null, I18n.tr("<html>To keep your local version, JOSM<br>has to reset the id of primitive {0} to 0.<br>On the next upload the server will assign<br>it a new id.<br>Do yo agree?</html>", PropertiesMerger.this.model.getMyPrimitive().getId()), I18n.tr("Reset id to 0"), 0, 3, null, objectArray, objectArray[1]);
            return n == 0;
        }
    }

    class UndecideDeletedStateConflictAction
    extends AbstractAction
    implements Observer {
        public UndecideDeletedStateConflictAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagundecide"));
            this.putValue("ShortDescription", I18n.tr("Undecide conflict between deleted state"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideDeletedStateConflict(MergeDecisionType.UNDECIDED);
        }

        public void update(Observable observable, Object object) {
            this.setEnabled(PropertiesMerger.this.model.hasDeletedStateConflict() && PropertiesMerger.this.model.isDecidedDeletedState());
        }
    }

    class KeepTheirDeletedStateAction
    extends AbstractAction
    implements Observer {
        public KeepTheirDeletedStateAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeeptheir"));
            this.putValue("ShortDescription", I18n.tr("Keep their deleted state"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideDeletedStateConflict(MergeDecisionType.KEEP_THEIR);
        }

        public void update(Observable observable, Object object) {
            this.setEnabled(PropertiesMerger.this.model.hasDeletedStateConflict() && !PropertiesMerger.this.model.isDecidedDeletedState());
        }
    }

    class KeepMyDeletedStateAction
    extends AbstractAction
    implements Observer {
        public KeepMyDeletedStateAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeepmine"));
            this.putValue("ShortDescription", I18n.tr("Keep my deleted state"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideDeletedStateConflict(MergeDecisionType.KEEP_MINE);
        }

        public void update(Observable observable, Object object) {
            this.setEnabled(PropertiesMerger.this.model.hasDeletedStateConflict() && !PropertiesMerger.this.model.isDecidedDeletedState());
        }
    }

    class UndecideCoordinateConflictAction
    extends AbstractAction
    implements Observer {
        public UndecideCoordinateConflictAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagundecide"));
            this.putValue("ShortDescription", I18n.tr("Undecide conflict between different coordinates"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideCoordsConflict(MergeDecisionType.UNDECIDED);
        }

        public void update(Observable observable, Object object) {
            this.setEnabled(PropertiesMerger.this.model.hasCoordConflict() && PropertiesMerger.this.model.isDecidedCoord());
        }
    }

    class KeepTheirCoordinatesAction
    extends AbstractAction
    implements Observer {
        public KeepTheirCoordinatesAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeeptheir"));
            this.putValue("ShortDescription", I18n.tr("Keep their coordiates"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideCoordsConflict(MergeDecisionType.KEEP_THEIR);
        }

        public void update(Observable observable, Object object) {
            this.setEnabled(PropertiesMerger.this.model.hasCoordConflict() && !PropertiesMerger.this.model.isDecidedCoord());
        }
    }

    class KeepMyCoordinatesAction
    extends AbstractAction
    implements Observer {
        public KeepMyCoordinatesAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeepmine"));
            this.putValue("ShortDescription", I18n.tr("Keep my coordiates"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideCoordsConflict(MergeDecisionType.KEEP_MINE);
        }

        public void update(Observable observable, Object object) {
            this.setEnabled(PropertiesMerger.this.model.hasCoordConflict() && !PropertiesMerger.this.model.isDecidedCoord());
        }
    }
}

