/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.gui.conflict.pair.ComparePairType;
import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListMergeModel<T>
extends Observable {
    public static final String FROZEN_PROP = ListMergeModel.class.getName() + ".frozen";
    protected HashMap<ListRole, ArrayList<T>> entries = new HashMap();
    protected DefaultTableModel myEntriesTableModel;
    protected DefaultTableModel theirEntriesTableModel;
    protected DefaultTableModel mergedEntriesTableModel;
    protected EntriesSelectionModel myEntriesSelectionModel;
    protected EntriesSelectionModel theirEntriesSelectionModel;
    protected EntriesSelectionModel mergedEntriesSelectionModel;
    private final ArrayList<PropertyChangeListener> listeners;
    private boolean isFrozen = false;
    private final ComparePairListModel comparePairListModel;

    protected abstract T cloneEntryForMergedList(T var1);

    public abstract boolean isEqualEntry(T var1, T var2);

    protected abstract void setValueAt(DefaultTableModel var1, Object var2, int var3, int var4);

    protected void buildMyEntriesTableModel() {
        this.myEntriesTableModel = new EntriesTableModel(ListRole.MY_ENTRIES);
    }

    protected void buildTheirEntriesTableModel() {
        this.theirEntriesTableModel = new EntriesTableModel(ListRole.THEIR_ENTRIES);
    }

    protected void buildMergedEntriesTableModel() {
        this.mergedEntriesTableModel = new EntriesTableModel(ListRole.MERGED_ENTRIES);
    }

    protected ArrayList<T> getMergedEntries() {
        return this.entries.get((Object)ListRole.MERGED_ENTRIES);
    }

    protected ArrayList<T> getMyEntries() {
        return this.entries.get((Object)ListRole.MY_ENTRIES);
    }

    protected ArrayList<T> getTheirEntries() {
        return this.entries.get((Object)ListRole.THEIR_ENTRIES);
    }

    public int getMyEntriesSize() {
        return this.getMyEntries().size();
    }

    public int getMergedEntriesSize() {
        return this.getMergedEntries().size();
    }

    public int getTheirEntriesSize() {
        return this.getTheirEntries().size();
    }

    public ListMergeModel() {
        for (ListRole listRole : ListRole.values()) {
            this.entries.put(listRole, new ArrayList());
        }
        this.buildMyEntriesTableModel();
        this.buildTheirEntriesTableModel();
        this.buildMergedEntriesTableModel();
        this.myEntriesSelectionModel = new EntriesSelectionModel(this.entries.get((Object)ListRole.MY_ENTRIES));
        this.theirEntriesSelectionModel = new EntriesSelectionModel(this.entries.get((Object)ListRole.THEIR_ENTRIES));
        this.mergedEntriesSelectionModel = new EntriesSelectionModel(this.entries.get((Object)ListRole.MERGED_ENTRIES));
        this.listeners = new ArrayList();
        this.comparePairListModel = new ComparePairListModel();
        this.setFrozen(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        ArrayList<PropertyChangeListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (propertyChangeListener != null && !this.listeners.contains(propertyChangeListener)) {
                this.listeners.add(propertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        ArrayList<PropertyChangeListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (propertyChangeListener != null && this.listeners.contains(propertyChangeListener)) {
                this.listeners.remove(propertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFrozenChanged(boolean bl, boolean bl2) {
        ArrayList<PropertyChangeListener> arrayList = this.listeners;
        synchronized (arrayList) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, FROZEN_PROP, bl, bl2);
            for (PropertyChangeListener propertyChangeListener : this.listeners) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    public void setFrozen(boolean bl) {
        boolean bl2 = this.isFrozen;
        this.isFrozen = bl;
        this.fireFrozenChanged(bl2, this.isFrozen);
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public TableModel getMyTableModel() {
        return this.myEntriesTableModel;
    }

    public TableModel getTheirTableModel() {
        return this.theirEntriesTableModel;
    }

    public TableModel getMergedTableModel() {
        return this.mergedEntriesTableModel;
    }

    public EntriesSelectionModel getMySelectionModel() {
        return this.myEntriesSelectionModel;
    }

    public EntriesSelectionModel getTheirSelectionModel() {
        return this.theirEntriesSelectionModel;
    }

    public EntriesSelectionModel getMergedSelectionModel() {
        return this.mergedEntriesSelectionModel;
    }

    protected void fireModelDataChanged() {
        this.myEntriesTableModel.fireTableDataChanged();
        this.theirEntriesTableModel.fireTableDataChanged();
        this.mergedEntriesTableModel.fireTableDataChanged();
        this.setChanged();
        this.notifyObservers();
    }

    protected void copyToTop(ListRole listRole, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            T t = this.entries.get((Object)listRole).get(n);
            this.entries.get((Object)ListRole.MERGED_ENTRIES).add(0, this.cloneEntryForMergedList(t));
        }
        this.fireModelDataChanged();
        this.mergedEntriesSelectionModel.setSelectionInterval(0, nArray.length - 1);
    }

    public void copyMyToTop(int[] nArray) {
        this.copyToTop(ListRole.MY_ENTRIES, nArray);
    }

    public void copyTheirToTop(int[] nArray) {
        this.copyToTop(ListRole.THEIR_ENTRIES, nArray);
    }

    public void copyToEnd(ListRole listRole, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        ArrayList<T> arrayList = this.getMergedEntries();
        for (int n : nArray) {
            T t = this.entries.get((Object)listRole).get(n);
            arrayList.add(this.cloneEntryForMergedList(t));
        }
        this.fireModelDataChanged();
        this.mergedEntriesSelectionModel.setSelectionInterval(arrayList.size() - nArray.length, arrayList.size() - 1);
    }

    public void copyMyToEnd(int[] nArray) {
        this.copyToEnd(ListRole.MY_ENTRIES, nArray);
    }

    public void copyTheirToEnd(int[] nArray) {
        this.copyToEnd(ListRole.THEIR_ENTRIES, nArray);
    }

    protected void copyBeforeCurrent(ListRole listRole, int[] nArray, int n) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        ArrayList<T> arrayList = this.getMergedEntries();
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException(I18n.tr("Parameter current out of range. Got {0}.", n));
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n2 = nArray[i];
            T t = this.entries.get((Object)listRole).get(n2);
            arrayList.add(n, this.cloneEntryForMergedList(t));
        }
        this.fireModelDataChanged();
        this.mergedEntriesSelectionModel.setSelectionInterval(n, n + nArray.length - 1);
    }

    public void copyMyBeforeCurrent(int[] nArray, int n) {
        this.copyBeforeCurrent(ListRole.MY_ENTRIES, nArray, n);
    }

    public void copyTheirBeforeCurrent(int[] nArray, int n) {
        this.copyBeforeCurrent(ListRole.THEIR_ENTRIES, nArray, n);
    }

    protected void copyAfterCurrent(ListRole listRole, int[] nArray, int n) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        ArrayList<T> arrayList = this.getMergedEntries();
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException(I18n.tr("Parameter current out of range. Got {0}.", n));
        }
        if (n == arrayList.size() - 1) {
            this.copyToEnd(listRole, nArray);
        } else {
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n2 = nArray[i];
                T t = this.entries.get((Object)listRole).get(n2);
                arrayList.add(n + 1, this.cloneEntryForMergedList(t));
            }
        }
        this.fireModelDataChanged();
        this.mergedEntriesSelectionModel.setSelectionInterval(n + 1, n + nArray.length - 1);
        this.notifyObservers();
    }

    public void copyMyAfterCurrent(int[] nArray, int n) {
        this.copyAfterCurrent(ListRole.MY_ENTRIES, nArray, n);
    }

    public void copyTheirAfterCurrent(int[] nArray, int n) {
        this.copyAfterCurrent(ListRole.THEIR_ENTRIES, nArray, n);
    }

    public void moveUpMerged(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (nArray[0] == 0) {
            return;
        }
        ArrayList<T> arrayList = this.getMergedEntries();
        for (int n : nArray) {
            T t = arrayList.get(n);
            arrayList.remove(n);
            arrayList.add(n - 1, t);
        }
        this.fireModelDataChanged();
        this.notifyObservers();
        this.mergedEntriesSelectionModel.clearSelection();
        for (int n : nArray) {
            this.mergedEntriesSelectionModel.addSelectionInterval(n - 1, n - 1);
        }
    }

    public void moveDownMerged(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        ArrayList<T> arrayList = this.getMergedEntries();
        if (nArray[nArray.length - 1] == arrayList.size() - 1) {
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            T t = arrayList.get(n);
            arrayList.remove(n);
            arrayList.add(n + 1, t);
        }
        this.fireModelDataChanged();
        this.notifyObservers();
        this.mergedEntriesSelectionModel.clearSelection();
        for (int n : nArray) {
            this.mergedEntriesSelectionModel.addSelectionInterval(n + 1, n + 1);
        }
    }

    public void removeMerged(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        ArrayList<T> arrayList = this.getMergedEntries();
        for (int i = nArray.length - 1; i >= 0; --i) {
            arrayList.remove(nArray[i]);
        }
        this.fireModelDataChanged();
        this.notifyObservers();
        this.mergedEntriesSelectionModel.clearSelection();
    }

    protected boolean myAndTheirEntriesEqual() {
        if (this.getMyEntries().size() != this.getTheirEntries().size()) {
            return false;
        }
        for (int i = 0; i < this.getMyEntries().size(); ++i) {
            if (this.isEqualEntry(this.getMyEntries().get(i), this.getTheirEntries().get(i))) continue;
            return false;
        }
        return true;
    }

    public ComparePairListModel getComparePairListModel() {
        return this.comparePairListModel;
    }

    public class ComparePairListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private int selectedIdx;
        private final ArrayList<ComparePairType> compareModes = new ArrayList();

        public ComparePairListModel() {
            this.compareModes.add(ComparePairType.MY_WITH_THEIR);
            this.compareModes.add(ComparePairType.MY_WITH_MERGED);
            this.compareModes.add(ComparePairType.THEIR_WITH_MERGED);
            this.selectedIdx = 0;
        }

        public Object getElementAt(int n) {
            if (n < this.compareModes.size()) {
                return this.compareModes.get(n);
            }
            throw new IllegalArgumentException(I18n.tr("Unexpected value of parameter ''index''. Got {0}.", n));
        }

        public int getSize() {
            return this.compareModes.size();
        }

        public Object getSelectedItem() {
            return this.compareModes.get(this.selectedIdx);
        }

        public void setSelectedItem(Object object) {
            int n = this.compareModes.indexOf(object);
            if (n < 0) {
                throw new IllegalStateException(I18n.tr("Item {0} not found in list.", object));
            }
            this.selectedIdx = n;
            ListMergeModel.this.fireModelDataChanged();
        }

        public ComparePairType getSelectedComparePair() {
            return this.compareModes.get(this.selectedIdx);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntriesSelectionModel
    extends DefaultListSelectionModel {
        private final ArrayList<T> entries;

        public EntriesSelectionModel(ArrayList<T> arrayList) {
            this.entries = arrayList;
        }

        @Override
        public void addSelectionInterval(int n, int n2) {
            if (this.entries.isEmpty()) {
                return;
            }
            if (n > this.entries.size() - 1) {
                return;
            }
            n = Math.min(this.entries.size() - 1, n);
            n2 = Math.min(this.entries.size() - 1, n2);
            super.addSelectionInterval(n, n2);
        }

        @Override
        public void insertIndexInterval(int n, int n2, boolean bl) {
            if (this.entries.isEmpty()) {
                return;
            }
            if (bl) {
                int n3 = Math.min(this.entries.size() - 1, n);
                if (n3 < n - n2) {
                    return;
                }
                super.insertIndexInterval(n3, n2 -= n - n3, bl);
            } else {
                if (n > this.entries.size() - 1) {
                    return;
                }
                n2 = Math.min(this.entries.size() - 1 - n, n2);
                super.insertIndexInterval(n, n2, bl);
            }
        }

        @Override
        public void moveLeadSelectionIndex(int n) {
            if (this.entries.isEmpty()) {
                return;
            }
            n = Math.max(0, n);
            n = Math.min(this.entries.size() - 1, n);
            super.moveLeadSelectionIndex(n);
        }

        @Override
        public void removeIndexInterval(int n, int n2) {
            if (this.entries.isEmpty()) {
                return;
            }
            n = Math.max(0, n);
            n = Math.min(this.entries.size() - 1, n);
            n2 = Math.max(0, n2);
            n2 = Math.min(this.entries.size() - 1, n2);
            super.removeIndexInterval(n, n2);
        }

        @Override
        public void removeSelectionInterval(int n, int n2) {
            if (this.entries.isEmpty()) {
                return;
            }
            n = Math.max(0, n);
            n = Math.min(this.entries.size() - 1, n);
            n2 = Math.max(0, n2);
            n2 = Math.min(this.entries.size() - 1, n2);
            super.removeSelectionInterval(n, n2);
        }

        @Override
        public void setAnchorSelectionIndex(int n) {
            if (this.entries.isEmpty()) {
                return;
            }
            n = Math.min(this.entries.size() - 1, n);
            super.setAnchorSelectionIndex(n);
        }

        @Override
        public void setLeadSelectionIndex(int n) {
            if (this.entries.isEmpty()) {
                return;
            }
            n = Math.min(this.entries.size() - 1, n);
            super.setLeadSelectionIndex(n);
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
            if (this.entries.isEmpty()) {
                return;
            }
            n = Math.max(0, n);
            n = Math.min(this.entries.size() - 1, n);
            n2 = Math.max(0, n2);
            n2 = Math.min(this.entries.size() - 1, n2);
            super.setSelectionInterval(n, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntriesTableModel
    extends DefaultTableModel {
        private final ListRole role;

        public EntriesTableModel(ListRole listRole) {
            this.role = listRole;
        }

        @Override
        public int getRowCount() {
            int n = Math.max(ListMergeModel.this.getMyEntries().size(), ListMergeModel.this.getMergedEntries().size());
            n = Math.max(n, ListMergeModel.this.getTheirEntries().size());
            return n;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < ListMergeModel.this.entries.get((Object)this.role).size()) {
                return ListMergeModel.this.entries.get((Object)this.role).get(n);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ListMergeModel.this.setValueAt(this, object, n, n2);
        }

        public ListMergeModel getListMergeModel() {
            return ListMergeModel.this;
        }

        public boolean isParticipatingInCurrentComparePair() {
            return ListMergeModel.this.getComparePairListModel().getSelectedComparePair().isParticipatingIn(this.role);
        }

        public boolean isSamePositionInOppositeList(int n) {
            if (!this.isParticipatingInCurrentComparePair()) {
                throw new IllegalStateException(I18n.tr("List in role {0} is currently not participating in a compare pair.", this.role.toString()));
            }
            if (n >= this.getEntries().size()) {
                return false;
            }
            if (n >= this.getOppositeEntries().size()) {
                return false;
            }
            Object t = this.getEntries().get(n);
            Object t2 = this.getOppositeEntries().get(n);
            return ListMergeModel.this.isEqualEntry(t, t2);
        }

        public boolean isIncludedInOppositeList(int n) {
            if (!this.isParticipatingInCurrentComparePair()) {
                throw new IllegalStateException(I18n.tr("List in role {0} is currently not participating in a compare pair.", this.role.toString()));
            }
            if (n >= this.getEntries().size()) {
                return false;
            }
            Object t = this.getEntries().get(n);
            for (Object t2 : this.getOppositeEntries()) {
                if (!ListMergeModel.this.isEqualEntry(t, t2)) continue;
                return true;
            }
            return false;
        }

        protected ArrayList<T> getEntries() {
            return ListMergeModel.this.entries.get((Object)this.role);
        }

        protected ArrayList<T> getOppositeEntries() {
            ListRole listRole = ListMergeModel.this.getComparePairListModel().getSelectedComparePair().getOppositeRole(this.role);
            return ListMergeModel.this.entries.get((Object)listRole);
        }

        public ListRole getRole() {
            return this.role;
        }
    }
}

