/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.EventQueue;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public abstract class PleaseWaitRunnable
implements Runnable,
ProgressMonitor.CancelListener {
    private boolean cancelled = false;
    private boolean ignoreException;
    private final String title;
    protected final ProgressMonitor progressMonitor;

    public PleaseWaitRunnable(String string) {
        this(string, false);
    }

    public PleaseWaitRunnable(String string, boolean bl) {
        this(string, new PleaseWaitProgressMonitor(string), bl);
    }

    public PleaseWaitRunnable(String string, ProgressMonitor progressMonitor, boolean bl) {
        this.title = string;
        this.progressMonitor = progressMonitor == null ? new PleaseWaitProgressMonitor(string) : progressMonitor;
        this.ignoreException = bl;
        this.progressMonitor.addCancelListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRealRun() {
        block21: {
            try {
                try {
                    this.progressMonitor.beginTask(this.title);
                    try {
                        this.realRun();
                    }
                    catch (Throwable throwable) {
                        if (EventQueue.isDispatchThread()) {
                            this.finish();
                        } else {
                            EventQueue.invokeAndWait(new Runnable(){

                                public void run() {
                                    PleaseWaitRunnable.this.finish();
                                }
                            });
                        }
                        throw throwable;
                    }
                    if (EventQueue.isDispatchThread()) {
                        this.finish();
                    } else {
                        EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                    this.progressMonitor.setErrorMessage(I18n.tr("Error while parsing") + ": " + sAXException.getMessage());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                    this.progressMonitor.setErrorMessage(I18n.tr("File not found") + ": " + fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    this.progressMonitor.setErrorMessage(iOException.getMessage());
                }
                catch (OsmTransferException osmTransferException) {
                    osmTransferException.printStackTrace();
                    if (osmTransferException.getCause() != null) {
                        this.progressMonitor.setErrorMessage(osmTransferException.getCause().getMessage());
                    } else {
                        this.progressMonitor.setErrorMessage(osmTransferException.getMessage());
                    }
                }
                finally {
                    this.progressMonitor.finishTask();
                }
            }
            catch (Throwable throwable) {
                if (this.ignoreException) break block21;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        throw new RuntimeException(throwable);
                    }
                });
            }
        }
    }

    public final void run() {
        if (this.cancelled) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            new Thread(new Runnable(){

                public void run() {
                    PleaseWaitRunnable.this.doRealRun();
                }
            }).start();
        } else {
            this.doRealRun();
        }
    }

    public void operationCanceled() {
        this.cancel();
    }

    protected abstract void cancel();

    protected abstract void realRun() throws SAXException, IOException, OsmTransferException;

    protected abstract void finish();

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }
}

