/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class PleaseWaitDialog
extends JDialog {
    private final JProgressBar progressBar = new JProgressBar();
    public final JLabel currentAction = new JLabel("");
    private final JLabel customText = new JLabel("");
    public final BoundedRangeModel progress = this.progressBar.getModel();
    public final JButton cancel = new JButton(I18n.tr("Cancel"));

    private void initDialog() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)this.currentAction, GBC.eol().fill(2));
        jPanel.add((Component)this.customText, GBC.eol().fill(2));
        jPanel.add((Component)this.progressBar, GBC.eop().fill(2));
        jPanel.add((Component)this.cancel, GBC.eol().anchor(10));
        this.setContentPane(jPanel);
        this.setCustomText("");
        this.setLocationRelativeTo(Main.parent);
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                int n = PleaseWaitDialog.this.getWidth();
                if (n > 200) {
                    Main.pref.putInteger("progressdialog.size", n);
                }
            }
        });
    }

    public PleaseWaitDialog(Frame frame) {
        super(frame, true);
        this.initDialog();
    }

    public PleaseWaitDialog(Dialog dialog) {
        super(dialog, true);
        this.initDialog();
    }

    public void setIndeterminate(boolean bl) {
        UIManager.put("ProgressBar.cycleTime", UIManager.getInt("ProgressBar.repaintInterval") * 100);
        this.progressBar.setIndeterminate(bl);
    }

    public void setCustomText(String string) {
        if (string.length() == 0) {
            this.customText.setVisible(false);
            this.setSize(Main.pref.getInteger("progressdialog.size", 600), 100);
            return;
        }
        this.customText.setVisible(true);
        this.customText.setText(string);
        this.setSize(Main.pref.getInteger("progressdialog.size", 600), 120);
    }
}

