/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.ImageProvider;

public class OsmPrimitivRenderer
implements ListCellRenderer,
TableCellRenderer {
    private DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();
    private DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Component component = this.defaultListCellRenderer.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        return this.renderer(component, (OsmPrimitive)object);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = this.defaultTableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        return this.renderer(component, (OsmPrimitive)object);
    }

    private Component renderer(Component component, OsmPrimitive osmPrimitive) {
        if (component != null && osmPrimitive != null && component instanceof JLabel) {
            ((JLabel)component).setText(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
            ((JLabel)component).setIcon(ImageProvider.get(OsmPrimitiveType.from(osmPrimitive)));
            ((JLabel)component).setToolTipText(this.buildToolTipText(osmPrimitive));
        }
        return component;
    }

    public String buildToolTipText(OsmPrimitive osmPrimitive) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<strong>id</strong>=").append(osmPrimitive.getId()).append("<br>");
        ArrayList<String> arrayList = new ArrayList<String>(osmPrimitive.keySet());
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append("<br>");
            }
            String string = arrayList.get(i);
            stringBuilder.append("<strong>").append(string).append("</strong>").append("=");
            String string2 = osmPrimitive.get(string);
            while (string2.length() != 0) {
                stringBuilder.append(string2.substring(0, Math.min(50, string2.length())));
                if (string2.length() > 50) {
                    stringBuilder.append("<br>");
                    string2 = string2.substring(50);
                    continue;
                }
                string2 = "";
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }
}

