/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmChangesetCloseException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionDialogUtil {
    private ExceptionDialogUtil() {
    }

    public static void explainOsmApiInitializationException(OsmApiInitializationException osmApiInitializationException) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainOsmApiInitializationException(osmApiInitializationException), I18n.tr("Error"), 0);
    }

    public static void explainOsmChangesetCloseException(OsmChangesetCloseException osmChangesetCloseException) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainOsmChangesetCloseException(osmChangesetCloseException), I18n.tr("Error"), 0);
    }

    public static void explainPreconditionFailed(OsmApiException osmApiException) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainPreconditionFailed(osmApiException), I18n.tr("Precondition violation"), 0);
    }

    public static void explainGeneric(Exception exception) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainGeneric(exception), I18n.tr("Error"), 0);
    }

    public static void explainSecurityException(OsmTransferException osmTransferException) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainSecurityException(osmTransferException), I18n.tr("Security exception"), 0);
    }

    public static void explainNestedSocketException(OsmTransferException osmTransferException) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainNestedSocketException(osmTransferException), I18n.tr("Network exception"), 0);
    }

    public static void explainNestedIOException(OsmTransferException osmTransferException) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainNestedIOException(osmTransferException), I18n.tr("IO Exception"), 0);
    }

    public static void explainInternalServerError(OsmTransferException osmTransferException) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainInternalServerError(osmTransferException), I18n.tr("Internal Server Error"), 0);
    }

    public static void explainBadRequest(OsmApiException osmApiException) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainBadRequest(osmApiException), I18n.tr("Bad Request"), 0);
    }

    public static void explainNotFound(OsmApiException osmApiException) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainNotFound(osmApiException), I18n.tr("Not Found"), 0);
    }

    public static void explainNestedUnkonwnHostException(OsmTransferException osmTransferException) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainNestedUnkonwnHostException(osmTransferException), I18n.tr("Unknown host"), 0);
    }

    protected static <T> T getNestedException(Exception exception, Class<T> clazz) {
        Throwable throwable;
        for (throwable = exception; throwable != null && !clazz.isInstance(throwable); throwable = throwable.getCause()) {
        }
        if (throwable == null) {
            return null;
        }
        if (clazz.isInstance(throwable)) {
            return clazz.cast(throwable);
        }
        return null;
    }

    public static void explainOsmTransferException(OsmTransferException osmTransferException) {
        if (ExceptionDialogUtil.getNestedException(osmTransferException, SecurityException.class) != null) {
            ExceptionDialogUtil.explainSecurityException(osmTransferException);
            return;
        }
        if (ExceptionDialogUtil.getNestedException(osmTransferException, SocketException.class) != null) {
            ExceptionDialogUtil.explainNestedSocketException(osmTransferException);
            return;
        }
        if (ExceptionDialogUtil.getNestedException(osmTransferException, UnknownHostException.class) != null) {
            ExceptionDialogUtil.explainNestedUnkonwnHostException(osmTransferException);
            return;
        }
        if (ExceptionDialogUtil.getNestedException(osmTransferException, IOException.class) != null) {
            ExceptionDialogUtil.explainNestedIOException(osmTransferException);
            return;
        }
        if (osmTransferException instanceof OsmApiInitializationException) {
            ExceptionDialogUtil.explainOsmApiInitializationException((OsmApiInitializationException)osmTransferException);
            return;
        }
        if (osmTransferException instanceof OsmChangesetCloseException) {
            ExceptionDialogUtil.explainOsmChangesetCloseException((OsmChangesetCloseException)osmTransferException);
            return;
        }
        if (osmTransferException instanceof OsmApiException) {
            OsmApiException osmApiException = (OsmApiException)osmTransferException;
            if (osmApiException.getResponseCode() == 412) {
                ExceptionDialogUtil.explainPreconditionFailed(osmApiException);
                return;
            }
            if (osmApiException.getResponseCode() == 410) {
                ExceptionDialogUtil.explainGoneForUnknownPrimitive(osmApiException);
                return;
            }
            if (osmApiException.getResponseCode() == 500) {
                ExceptionDialogUtil.explainInternalServerError(osmApiException);
                return;
            }
            if (osmApiException.getResponseCode() == 400) {
                ExceptionDialogUtil.explainBadRequest(osmApiException);
                return;
            }
            if (osmApiException.getResponseCode() == 404) {
                ExceptionDialogUtil.explainNotFound(osmApiException);
                return;
            }
        }
        ExceptionDialogUtil.explainGeneric(osmTransferException);
    }

    public static void explainGoneForUnknownPrimitive(OsmApiException osmApiException) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainGoneForUnknownPrimitive(osmApiException), I18n.tr("Object deleted"), 0);
    }

    public static void explainException(Exception exception) {
        if (exception instanceof OsmTransferException) {
            ExceptionDialogUtil.explainOsmTransferException((OsmTransferException)exception);
            return;
        }
        ExceptionDialogUtil.explainGeneric(exception);
    }
}

