/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.io.IOException;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.tools.I18n;

public class BookmarkList
extends JList {
    public BookmarkList() {
        this.setModel(new DefaultListModel());
        this.load();
        this.setVisibleRowCount(7);
    }

    public void load() {
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        defaultListModel.removeAllElements();
        try {
            for (Preferences.Bookmark bookmark : Main.pref.loadBookmarks()) {
                defaultListModel.addElement(bookmark);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Could not read bookmarks from<br>''{0}''<br>Error was: {1}</html>", Main.pref.getBookmarksFile(), iOException.getMessage()), I18n.tr("Error"), 0);
        }
    }

    public void save() {
        try {
            LinkedList<Preferences.Bookmark> linkedList = new LinkedList<Preferences.Bookmark>();
            for (Object object : ((DefaultListModel)this.getModel()).toArray()) {
                linkedList.add((Preferences.Bookmark)object);
            }
            Main.pref.saveBookmarks(linkedList);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Could not write bookmark.<br>{0}</html>", iOException.getMessage()), I18n.tr("Error"), 0);
        }
    }
}

