/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;

public class UTM_20N_France_DOM {
    private static final double Xs = 500000.0;
    private static double Ys = 0.0;
    protected double lg0;
    int zone = 20;
    private boolean isNorth = true;
    double tx = 0.0;
    double ty = 0.0;
    double tz = 0.0;
    double rx = 0.0;
    double ry = 0.0;
    double rz = 0.0;
    double scaleDiff = 0.0;
    public static final double epsilon = 1.0E-11;
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;

    public UTM_20N_France_DOM(double[] dArray, double[] dArray2, double d) {
        this.tx = dArray[0];
        this.ty = dArray[1];
        this.tz = dArray[2];
        this.rx = dArray2[0] / 206264.80624709636;
        this.ry = dArray2[1] / 206264.80624709636;
        this.rz = dArray2[2] / 206264.80624709636;
        this.scaleDiff = d;
    }

    public EastNorth latlon2eastNorth(LatLon latLon) {
        LatLon latLon2 = this.GRS802Hayford(latLon);
        return this.MTProjection(latLon2, Ellipsoid.hayford.a, Ellipsoid.hayford.e);
    }

    private LatLon GRS802Hayford(LatLon latLon) {
        double d = Math.toRadians(latLon.lat());
        double d2 = Math.toRadians(latLon.lon());
        double d3 = Ellipsoid.GRS80.a / Math.sqrt(1.0 - Ellipsoid.GRS80.e2 * Math.sin(d) * Math.sin(d));
        double d4 = d3 * Math.cos(d) * Math.cos(d2);
        double d5 = d3 * Math.cos(d) * Math.sin(d2);
        double d6 = d3 * (1.0 - Ellipsoid.GRS80.e2) * Math.sin(d);
        double[] dArray = this.invSevenParametersTransformation(d4, d5, d6);
        return this.Geographic(dArray[0], dArray[1], dArray[2], Ellipsoid.hayford);
    }

    private LatLon Geographic(double d, double d2, double d3, Ellipsoid ellipsoid) {
        double d4;
        double d5 = Math.sqrt(d * d + d2 * d2);
        double d6 = 2.0 * Math.atan(d2 / (d + d5));
        double d7 = Math.atan(d3 / (d5 * (1.0 - ellipsoid.a * ellipsoid.e2 / Math.sqrt(d * d + d2 * d2 + d3 * d3))));
        double d8 = 1.0;
        while (d8 > 1.0E-11) {
            d4 = Math.sin(d7);
            d4 *= d4;
            double d9 = Math.atan(d3 / d5 / (1.0 - ellipsoid.a * ellipsoid.e2 * Math.cos(d7) / (d5 * Math.sqrt(1.0 - ellipsoid.e2 * d4))));
            d8 = Math.abs(d9 - d7);
            d7 = d9;
        }
        d4 = Math.sin(d7);
        d4 *= d4;
        return new LatLon(d7, d6);
    }

    private EastNorth MTProjection(LatLon latLon, double d, double d2) {
        double d3 = 0.9996 * d;
        Ys = latLon.lat() >= 0.0 ? 0.0 : 1.0E7;
        double d4 = 0.10471975511965977;
        this.lg0 = d4 * ((double)this.zone - 0.5) - Math.PI;
        double d5 = d2 * d2;
        double d6 = d5 * d5;
        double d7 = d6 * d5;
        double d8 = d6 * d6;
        double[] dArray = new double[]{1.0 - d5 / 4.0 - 3.0 * d6 / 64.0 - 5.0 * d7 / 256.0 - 175.0 * d8 / 16384.0, d5 / 8.0 - d6 / 96.0 - 9.0 * d7 / 1024.0 - 901.0 * d8 / 184320.0, 13.0 * d6 / 768.0 + 17.0 * d7 / 5120.0 - 311.0 * d8 / 737280.0, 61.0 * d7 / 15360.0 + 899.0 * d8 / 430080.0, 49561.0 * d8 / 4.128768E7};
        double d9 = d2 * Math.sin(latLon.lat());
        double d10 = Math.log(Math.tan(0.7853981633974483 + latLon.lat() / 2.0) * Math.pow((1.0 - d9) / (1.0 + d9), d2 / 2.0));
        double d11 = Math.asin(Math.sin(latLon.lon() - this.lg0) / ((Math.exp(d10) + Math.exp(-d10)) / 2.0));
        double d12 = Math.log(Math.tan(0.7853981633974483 + d11 / 2.0));
        double d13 = Math.atan((Math.exp(d10) - Math.exp(-d10)) / 2.0 / Math.cos(latLon.lon() - this.lg0));
        double d14 = dArray[0] * d13;
        double d15 = dArray[0] * d12;
        for (int i = 1; i < 5; ++i) {
            double d16 = 2.0 * (double)i * d13;
            double d17 = 2.0 * (double)i * d12;
            double d18 = Math.exp(d17);
            double d19 = Math.exp(-d17);
            double d20 = Math.sin(d16) / 2.0 * (d18 + d19);
            double d21 = Math.cos(d16) / 2.0 * (d18 - d19);
            d14 += dArray[i] * d20;
            d15 += dArray[i] * d21;
        }
        d15 *= d3;
        d14 *= d3;
        return new EastNorth(d15 += 500000.0, d14 += Ys);
    }

    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        this.MTProjection(eastNorth.east(), eastNorth.north(), this.zone, this.isNorth);
        LatLon latLon = this.Geographic(eastNorth, Ellipsoid.hayford.a, Ellipsoid.hayford.e, 0.0);
        double d = Ellipsoid.hayford.a / Math.sqrt(1.0 - Ellipsoid.hayford.e2 * Math.sin(latLon.lat()) * Math.sin(latLon.lat()));
        double d2 = d * Math.cos(latLon.lat()) * Math.cos(latLon.lon());
        double d3 = d * Math.cos(latLon.lat()) * Math.sin(latLon.lon());
        double d4 = d * (1.0 - Ellipsoid.hayford.e2) * Math.sin(latLon.lat());
        double[] dArray = this.sevenParametersTransformation(d2, d3, d4);
        LatLon latLon2 = this.cart2LatLon(dArray[0], dArray[1], dArray[2], Ellipsoid.GRS80);
        return new LatLon(Math.toDegrees(latLon2.lat()), Math.toDegrees(latLon2.lon()));
    }

    private void MTProjection(double d, double d2, int n, boolean bl) {
        Ys = bl ? 0.0 : 1.0E7;
        double d3 = 0.10471975511965977;
        this.lg0 = d3 * ((double)n - 0.5) - Math.PI;
    }

    public double scaleFactor() {
        return 0.15915494309189535;
    }

    private LatLon Geographic(EastNorth eastNorth, double d, double d2, double d3) {
        double d4;
        double d5;
        double d6 = 0.9996 * d;
        double d7 = d2 * d2;
        double d8 = d7 * d7;
        double d9 = d8 * d7;
        double d10 = d8 * d8;
        double[] dArray = new double[]{1.0 - d7 / 4.0 - 3.0 * d8 / 64.0 - 5.0 * d9 / 256.0 - 175.0 * d10 / 16384.0, d7 / 8.0 + d8 / 48.0 + 7.0 * d9 / 2048.0 + d10 / 61440.0, d8 / 768.0 + 3.0 * d9 / 1280.0 + 559.0 * d10 / 368640.0, 17.0 * d9 / 30720.0 + 283.0 * d10 / 430080.0, 4397.0 * d10 / 4.128768E7};
        double d11 = (eastNorth.north() - Ys) / (d6 * dArray[0]);
        double d12 = (eastNorth.east() - 500000.0) / (d6 * dArray[0]);
        double d13 = d11;
        double d14 = d12;
        for (int i = 1; i < 5; ++i) {
            double d15 = 2.0 * (double)i * d13;
            double d16 = 2.0 * (double)i * d14;
            double d17 = Math.exp(d16);
            double d18 = Math.exp(-d16);
            double d19 = Math.sin(d15) / 2.0 * (d17 + d18);
            double d20 = Math.cos(d15) / 2.0 * (d17 - d18);
            d11 -= dArray[i] * d19;
            d12 -= dArray[i] * d20;
        }
        double d21 = this.lg0 + Math.atan((Math.exp(d12) - Math.exp(-d12)) / 2.0 / Math.cos(d11));
        double d22 = Math.asin(Math.sin(d11) / ((Math.exp(d12) + Math.exp(-d12)) / 2.0));
        d11 = Math.log(Math.tan(0.7853981633974483 + d22 / 2.0));
        double d23 = 2.0 * Math.atan(Math.exp(d11)) - 1.5707963267948966;
        do {
            d4 = d23;
        } while (Math.abs((d23 = 2.0 * Math.atan(Math.pow((1.0 + (d5 = d2 * Math.sin(d23))) / (1.0 - d5), d2 / 2.0) * Math.exp(d11)) - 1.5707963267948966) - d4) >= 1.0E-11);
        return new LatLon(d23, d21);
    }

    private LatLon cart2LatLon(double d, double d2, double d3, Ellipsoid ellipsoid) {
        double d4;
        double d5 = Math.sqrt(d * d + d2 * d2);
        double d6 = 2.0 * Math.atan(d2 / (d + d5));
        double d7 = Math.atan(d3 / (d5 * (1.0 - ellipsoid.a * ellipsoid.e2 / Math.sqrt(d * d + d2 * d2 + d3 * d3))));
        double d8 = 1.0;
        while (d8 > 1.0E-11) {
            d4 = Math.sin(d7);
            d4 *= d4;
            double d9 = Math.atan(d3 / d5 / (1.0 - ellipsoid.a * ellipsoid.e2 * Math.cos(d7) / (d5 * Math.sqrt(1.0 - ellipsoid.e2 * d4))));
            d8 = Math.abs(d9 - d7);
            d7 = d9;
        }
        d4 = Math.sin(d7);
        d4 *= d4;
        return new LatLon(d7, d6);
    }

    private double[] sevenParametersTransformation(double d, double d2, double d3) {
        double d4 = this.tx + d * (1.0 + this.scaleDiff) + d3 * this.ry - d2 * this.rz;
        double d5 = this.ty + d2 * (1.0 + this.scaleDiff) + d * this.rz - d3 * this.rx;
        double d6 = this.tz + d3 * (1.0 + this.scaleDiff) + d2 * this.rx - d * this.ry;
        return new double[]{d4, d5, d6};
    }

    private double[] invSevenParametersTransformation(double d, double d2, double d3) {
        double d4 = (1.0 - this.scaleDiff) * (-this.tx + d + ((-this.tz + d3) * -this.ry - (-this.ty + d2) * -this.rz));
        double d5 = (1.0 - this.scaleDiff) * (-this.ty + d2 + ((-this.tx + d) * -this.rz - (-this.tz + d3) * -this.rx));
        double d6 = (1.0 - this.scaleDiff) * (-this.tz + d3 + ((-this.ty + d2) * -this.rx - (-this.tx + d) * -this.ry));
        return new double[]{d4, d5, d6};
    }
}

