/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.tools.I18n;

public class LambertEST
implements Projection {
    public static final double ef = 500000.0;
    public static final double nf = 6375000.0;
    public static final double lat1 = Math.toRadians(59.333333333333336);
    public static final double lat2 = Math.toRadians(58.0);
    public static final double latf = Math.toRadians(57.51755393055556);
    public static final double lonf = Math.toRadians(24.0);
    public static final double a = 6378137.0;
    public static final double ee = 0.08181919104281579;
    public static final double m1 = Math.cos(lat1) / Math.sqrt(1.0 - 0.006694380022900788 * Math.pow(Math.sin(lat1), 2.0));
    public static final double m2 = Math.cos(lat2) / Math.sqrt(1.0 - 0.006694380022900788 * Math.pow(Math.sin(lat2), 2.0));
    public static final double t1 = Math.tan(0.7853981633974483 - lat1 / 2.0) / Math.pow((1.0 - 0.08181919104281579 * Math.sin(lat1)) / (1.0 + 0.08181919104281579 * Math.sin(lat1)), 0.040909595521407896);
    public static final double t2 = Math.tan(0.7853981633974483 - lat2 / 2.0) / Math.pow((1.0 - 0.08181919104281579 * Math.sin(lat2)) / (1.0 + 0.08181919104281579 * Math.sin(lat2)), 0.040909595521407896);
    public static final double tf = Math.tan(0.7853981633974483 - latf / 2.0) / Math.pow((1.0 - 0.08181919104281579 * Math.sin(latf)) / (1.0 + 0.08181919104281579 * Math.sin(latf)), 0.040909595521407896);
    public static final double n = (Math.log(m1) - Math.log(m2)) / (Math.log(t1) - Math.log(t2));
    public static final double f = m1 / (n * Math.pow(t1, n));
    public static final double rf = 6378137.0 * f * Math.pow(tf, n);
    public static final double epsilon = 1.0E-11;

    public EastNorth latlon2eastNorth(LatLon latLon) {
        double d = Math.tan(0.7853981633974483 - Math.toRadians(latLon.lat()) / 2.0) / Math.pow((1.0 - 0.08181919104281579 * Math.sin(Math.toRadians(latLon.lat()))) / (1.0 + 0.08181919104281579 * Math.sin(Math.toRadians(latLon.lat()))), 0.040909595521407896);
        double d2 = 6378137.0 * f * Math.pow(d, n);
        double d3 = n * (Math.toRadians(latLon.lon()) - lonf);
        double d4 = 500000.0 + d2 * Math.sin(d3);
        double d5 = 6375000.0 + rf - d2 * Math.cos(d3);
        return new EastNorth(d4, d5);
    }

    public static double IterateAngle(double d, double d2) {
        double d3 = 0.0;
        double d4 = Math.PI;
        double d5 = 1.5707963267948966;
        double d6 = 1.5707963267948966 - 2.0 * Math.atan(d2 * Math.pow((1.0 - d * Math.sin(d5)) / (1.0 + d * Math.sin(d5)), d / 2.0));
        while (Math.abs(d5 - d6) > 1.0E-11) {
            d5 = d3 + (d4 - d3) / 2.0;
            d6 = 1.5707963267948966 - 2.0 * Math.atan(d2 * Math.pow((1.0 - d * Math.sin(d5)) / (1.0 + d * Math.sin(d5)), d / 2.0));
            if (d3 == d4) {
                return 0.0;
            }
            if (d6 > d5) {
                d3 = d5;
                continue;
            }
            d4 = d5;
        }
        return d6;
    }

    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        double d = Math.sqrt(Math.pow(eastNorth.getX() - 500000.0, 2.0) + Math.pow(rf - eastNorth.getY() + 6375000.0, 2.0)) * Math.signum(n);
        double d2 = Math.pow(d / (6378137.0 * f), 1.0 / n);
        double d3 = Math.atan((eastNorth.getX() - 500000.0) / (rf - eastNorth.getY() + 6375000.0));
        double d4 = d3 / n + lonf;
        double d5 = LambertEST.IterateAngle(0.08181919104281579, d2);
        return new LatLon(Math.toDegrees(d5), Math.toDegrees(d4));
    }

    public String toString() {
        return I18n.tr("Lambert Zone (Estonia)");
    }

    public String toCode() {
        return "EPSG:3301";
    }

    public String getCacheDirectoryName() {
        return "lambertest";
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(-90.0, -180.0), new LatLon(90.0, 180.0));
    }

    public double getDefaultZoomInPPD() {
        return 0.0;
    }
}

