/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.tools.I18n;

public class MergeSourceBuildingVisitor
extends AbstractVisitor {
    private DataSet selectionBase;
    private DataSet hull;
    private HashMap<OsmPrimitive, OsmPrimitive> mappedPrimitives;

    public MergeSourceBuildingVisitor(DataSet dataSet) throws IllegalArgumentException {
        if (dataSet == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "selectionBase"));
        }
        this.selectionBase = dataSet;
        this.hull = new DataSet();
        this.mappedPrimitives = new HashMap();
    }

    protected void rememberNode(Node node) {
        if (this.isAlreadyRemembered(node)) {
            return;
        }
        Node node2 = new Node(node);
        this.mappedPrimitives.put(node, node2);
    }

    protected void rememberWay(Way way) {
        if (this.isAlreadyRemembered(way)) {
            return;
        }
        Way way2 = new Way(way);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : way.getNodes()) {
            arrayList.add((Node)this.mappedPrimitives.get(node));
        }
        way2.setNodes(arrayList);
        this.mappedPrimitives.put(way, way2);
    }

    protected void rememberRelation(Relation relation) {
        Relation relation2;
        if (this.mappedPrimitives.keySet().contains(relation)) {
            relation2 = (Relation)this.mappedPrimitives.get(relation);
            relation2.cloneFrom(relation);
        } else {
            relation2 = new Relation(relation);
        }
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
        for (RelationMember relationMember : relation.getMembers()) {
            arrayList.add(new RelationMember(relationMember.getRole(), this.mappedPrimitives.get(relationMember.getMember())));
        }
        relation2.setMembers(arrayList);
        if (!this.mappedPrimitives.keySet().contains(relation)) {
            this.mappedPrimitives.put(relation, relation2);
        }
    }

    protected void rememberRelationPartial(Relation relation) {
        if (this.isAlreadyRemembered(relation)) {
            return;
        }
        Relation relation2 = new Relation(relation);
        relation2.setMembers(null);
        this.mappedPrimitives.put(relation, relation2);
    }

    protected void rememberIncomplete(OsmPrimitive osmPrimitive) {
        if (this.isAlreadyRemembered(osmPrimitive)) {
            return;
        }
        OsmPrimitive osmPrimitive2 = null;
        if (osmPrimitive instanceof Node) {
            osmPrimitive2 = new Node(osmPrimitive.getId());
        } else if (osmPrimitive instanceof Way) {
            osmPrimitive2 = new Way(osmPrimitive.getId());
        } else if (osmPrimitive instanceof Relation) {
            osmPrimitive2 = new Relation(osmPrimitive.getId());
        }
        osmPrimitive2.incomplete = true;
        this.mappedPrimitives.put(osmPrimitive, osmPrimitive2);
    }

    protected void rememberNodeIncomplete(Node node) {
        if (this.isAlreadyRemembered(node)) {
            return;
        }
        Node node2 = new Node(node);
        node2.incomplete = true;
        this.mappedPrimitives.put(node, node2);
    }

    protected void rememberWayIncomplete(Way way) {
        if (this.isAlreadyRemembered(way)) {
            return;
        }
        Way way2 = new Way(way);
        way2.setNodes(null);
        way2.incomplete = true;
        this.mappedPrimitives.put(way, way2);
    }

    protected void rememberRelationIncomplete(Relation relation) {
        Relation relation2;
        if (this.isAlreadyRemembered(relation)) {
            relation2 = (Relation)this.mappedPrimitives.get(relation);
            relation2.cloneFrom(relation);
        } else {
            relation2 = new Relation(relation);
        }
        relation2.setMembers(null);
        relation2.incomplete = true;
        if (!this.isAlreadyRemembered(relation)) {
            this.mappedPrimitives.put(relation, relation2);
        }
    }

    public void visit(Node node) {
        this.rememberNode(node);
    }

    public void visit(Way way) {
        for (Node node : way.getNodes()) {
            if (this.isAlreadyRemembered(node)) continue;
            node.visit(this);
        }
        this.rememberWay(way);
    }

    protected boolean isNew(OsmPrimitive osmPrimitive) {
        return osmPrimitive.getId() == 0L;
    }

    protected boolean isInSelectionBase(OsmPrimitive osmPrimitive) {
        return this.selectionBase.getSelected().contains(osmPrimitive);
    }

    protected boolean isAlreadyRemembered(OsmPrimitive osmPrimitive) {
        return this.mappedPrimitives.keySet().contains(osmPrimitive);
    }

    public void visit(Relation relation) {
        this.rememberRelationPartial(relation);
        for (RelationMember relationMember : relation.getMembers()) {
            OsmPrimitive osmPrimitive;
            if (this.isAlreadyRemembered(relationMember.getMember())) continue;
            if (relationMember.isNode()) {
                osmPrimitive = relationMember.getNode();
                if (this.isInSelectionBase(osmPrimitive)) {
                    this.rememberNode((Node)osmPrimitive);
                    continue;
                }
                if (this.isNew(osmPrimitive)) {
                    this.rememberNode((Node)osmPrimitive);
                    continue;
                }
                this.rememberNodeIncomplete((Node)osmPrimitive);
                continue;
            }
            if (relationMember.isWay()) {
                osmPrimitive = relationMember.getWay();
                if (this.isInSelectionBase(osmPrimitive)) {
                    ((Way)osmPrimitive).visit(this);
                    continue;
                }
                if (this.isNew(osmPrimitive)) {
                    ((Way)osmPrimitive).visit(this);
                    continue;
                }
                this.rememberWayIncomplete((Way)osmPrimitive);
                continue;
            }
            if (!relationMember.isRelation()) continue;
            osmPrimitive = relationMember.getRelation();
            if (this.isInSelectionBase(relationMember.getMember())) {
                ((Relation)osmPrimitive).visit(this);
                continue;
            }
            if (this.isNew(osmPrimitive)) {
                ((Relation)osmPrimitive).visit(this);
                continue;
            }
            this.rememberRelationIncomplete((Relation)osmPrimitive);
        }
        this.rememberRelation(relation);
    }

    protected void buildHull() {
        for (OsmPrimitive osmPrimitive : this.mappedPrimitives.keySet()) {
            OsmPrimitive osmPrimitive2 = this.mappedPrimitives.get(osmPrimitive);
            if (osmPrimitive2 instanceof Node) {
                this.hull.nodes.add((Node)osmPrimitive2);
                continue;
            }
            if (osmPrimitive2 instanceof Way) {
                this.hull.ways.add((Way)osmPrimitive2);
                continue;
            }
            if (!(osmPrimitive2 instanceof Relation)) continue;
            this.hull.relations.add((Relation)osmPrimitive2);
        }
    }

    public DataSet build() {
        for (OsmPrimitive osmPrimitive : this.selectionBase.getSelected()) {
            osmPrimitive.visit(this);
        }
        this.buildHull();
        return this.hull;
    }
}

