/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagCollection
implements Iterable<Tag> {
    private HashSet<Tag> tags = new HashSet();

    public static TagCollection from(OsmPrimitive osmPrimitive) {
        TagCollection tagCollection = new TagCollection();
        for (String string : osmPrimitive.keySet()) {
            tagCollection.add(new Tag(string, osmPrimitive.get(string)));
        }
        return tagCollection;
    }

    public static TagCollection unionOfAllPrimitives(Collection<? extends OsmPrimitive> collection) {
        TagCollection tagCollection = new TagCollection();
        if (collection == null) {
            return tagCollection;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive == null) continue;
            tagCollection.add(TagCollection.from(osmPrimitive));
        }
        return tagCollection;
    }

    public static TagCollection commonToAllPrimitives(Collection<? extends OsmPrimitive> collection) {
        TagCollection tagCollection = new TagCollection();
        if (collection == null || collection.isEmpty()) {
            return tagCollection;
        }
        tagCollection.add(TagCollection.from(collection.iterator().next()));
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive == null) continue;
            tagCollection.add(tagCollection.intersect(TagCollection.from(osmPrimitive)));
        }
        return tagCollection;
    }

    public static TagCollection unionOfAllPrimitives(DataSet dataSet) {
        TagCollection tagCollection = new TagCollection();
        if (dataSet == null) {
            return tagCollection;
        }
        tagCollection.add(TagCollection.unionOfAllPrimitives(dataSet.nodes));
        tagCollection.add(TagCollection.unionOfAllPrimitives(dataSet.ways));
        tagCollection.add(TagCollection.unionOfAllPrimitives(dataSet.relations));
        return tagCollection;
    }

    public TagCollection() {
    }

    public TagCollection(TagCollection tagCollection) {
        this();
        if (tagCollection != null) {
            this.tags.addAll(tagCollection.tags);
        }
    }

    public int size() {
        return this.tags.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void add(Tag tag) {
        if (tag == null) {
            return;
        }
        if (this.tags.contains(tag)) {
            return;
        }
        this.tags.add(tag);
    }

    public void add(Collection<Tag> collection) {
        if (collection == null) {
            return;
        }
        for (Tag tag : collection) {
            this.add(tag);
        }
    }

    public void add(TagCollection tagCollection) {
        if (tagCollection == null) {
            return;
        }
        this.tags.addAll(tagCollection.tags);
    }

    public void remove(Tag tag) {
        if (tag == null) {
            return;
        }
        this.tags.remove(tag);
    }

    public void remove(Collection<Tag> collection) {
        if (collection == null) {
            return;
        }
        this.tags.removeAll(collection);
    }

    public void remove(TagCollection tagCollection) {
        if (tagCollection == null) {
            return;
        }
        this.tags.removeAll(tagCollection.tags);
    }

    public void removeByKey(String string) {
        if (string == null) {
            return;
        }
        Iterator<Tag> iterator = this.tags.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().matchesKey(string)) continue;
            iterator.remove();
        }
    }

    public void removeByKey(Collection<String> collection) {
        if (collection == null) {
            return;
        }
        for (String string : collection) {
            this.removeByKey(string);
        }
    }

    public boolean contains(Tag tag) {
        return this.tags.contains(tag);
    }

    public boolean containsKey(String string) {
        if (string == null) {
            return false;
        }
        for (Tag tag : this.tags) {
            if (!tag.matchesKey(string)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection<Tag> collection) {
        if (collection == null) {
            return false;
        }
        return collection.containsAll(collection);
    }

    public boolean containsAllKeys(Collection<String> collection) {
        if (collection == null) {
            return false;
        }
        for (String string : collection) {
            if (string == null || this.containsKey(string)) continue;
            return false;
        }
        return true;
    }

    public int getNumTagsFor(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        for (Tag tag : this.tags) {
            if (!tag.matchesKey(string)) continue;
            ++n;
        }
        return n;
    }

    public boolean hasTagsFor(String string) {
        return this.getNumTagsFor(string) > 0;
    }

    public boolean hasValuesFor(String string) {
        if (string == null) {
            return false;
        }
        Set<String> set = this.getTagsFor(string).getValues();
        set.remove("");
        return !set.isEmpty();
    }

    public boolean hasUniqueNonEmptyValue(String string) {
        if (string == null) {
            return false;
        }
        Set<String> set = this.getTagsFor(string).getValues();
        return set.size() == 1 && !set.contains("");
    }

    public boolean hasEmptyValue(String string) {
        if (string == null) {
            return false;
        }
        Set<String> set = this.getTagsFor(string).getValues();
        return set.contains("");
    }

    public boolean hasUniqueEmptyValue(String string) {
        if (string == null) {
            return false;
        }
        Set<String> set = this.getTagsFor(string).getValues();
        return set.size() == 1 && set.contains("");
    }

    public TagCollection getTagsFor(String string) {
        TagCollection tagCollection = new TagCollection();
        if (string == null) {
            return tagCollection;
        }
        for (Tag tag : this.tags) {
            if (!tag.matchesKey(string)) continue;
            tagCollection.add(tag);
        }
        return tagCollection;
    }

    public TagCollection getTagsFor(Collection<String> collection) {
        TagCollection tagCollection = new TagCollection();
        if (collection == null) {
            return tagCollection;
        }
        for (String string : collection) {
            if (string == null) continue;
            tagCollection.add(this.getTagsFor(string));
        }
        return tagCollection;
    }

    public Set<Tag> asSet() {
        return new HashSet<Tag>(this.tags);
    }

    public List<Tag> asList() {
        return new ArrayList<Tag>(this.tags);
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.tags.iterator();
    }

    public Set<String> getKeys() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Tag tag : this.tags) {
            hashSet.add(tag.getKey());
        }
        return hashSet;
    }

    public Set<String> getKeysWithMultipleValues() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Tag object : this.tags) {
            Integer n = (Integer)hashMap.get(object.getKey());
            hashMap.put(object.getKey(), n == null ? 1 : n + 1);
        }
        HashSet hashSet = new HashSet();
        for (Map.Entry entry : hashMap.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    public void setUniqueForKey(Tag tag) {
        if (tag == null) {
            return;
        }
        this.removeByKey(tag.getKey());
        this.add(tag);
    }

    public void setUniqueForKey(String string, String string2) {
        Tag tag = new Tag(string, string2);
        this.setUniqueForKey(tag);
    }

    public Set<String> getValues() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Tag tag : this.tags) {
            hashSet.add(tag.getValue());
        }
        return hashSet;
    }

    public Set<String> getValues(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (string == null) {
            return hashSet;
        }
        for (Tag tag : this.tags) {
            if (!tag.matchesKey(string)) continue;
            hashSet.add(tag.getValue());
        }
        return hashSet;
    }

    public boolean isApplicableToPrimitive() {
        return this.size() == this.getKeys().size();
    }

    public void applyTo(OsmPrimitive osmPrimitive) throws IllegalStateException {
        if (osmPrimitive == null) {
            return;
        }
        if (!this.isApplicableToPrimitive()) {
            throw new IllegalStateException(I18n.tr("Tag collection can't be applied to a primitive because there are keys with multiple values."));
        }
        for (Tag tag : this.tags) {
            if (tag.getValue() == null || tag.getValue().equals("")) {
                osmPrimitive.remove(tag.getKey());
                continue;
            }
            osmPrimitive.put(tag.getKey(), tag.getValue());
        }
    }

    public void applyTo(Collection<? extends OsmPrimitive> collection) throws IllegalStateException {
        if (collection == null) {
            return;
        }
        if (!this.isApplicableToPrimitive()) {
            throw new IllegalStateException(I18n.tr("Tag collection can't be applied to a primitive because there are keys with multiple values."));
        }
        for (OsmPrimitive osmPrimitive : collection) {
            this.applyTo(osmPrimitive);
        }
    }

    public void replaceTagsOf(OsmPrimitive osmPrimitive) throws IllegalStateException {
        if (osmPrimitive == null) {
            return;
        }
        if (!this.isApplicableToPrimitive()) {
            throw new IllegalStateException(I18n.tr("Tag collection can't be applied to a primitive because there are keys with multiple values."));
        }
        osmPrimitive.removeAll();
        for (Tag tag : this.tags) {
            osmPrimitive.put(tag.getKey(), tag.getValue());
        }
    }

    public void replaceTagsOf(Collection<? extends OsmPrimitive> collection) throws IllegalStateException {
        if (collection == null) {
            return;
        }
        if (!this.isApplicableToPrimitive()) {
            throw new IllegalStateException(I18n.tr("Tag collection can't be applied to a primitive because there are keys with multiple values."));
        }
        for (OsmPrimitive osmPrimitive : collection) {
            this.replaceTagsOf(osmPrimitive);
        }
    }

    public TagCollection intersect(TagCollection tagCollection) {
        if (tagCollection == null) {
            new TagCollection();
        }
        TagCollection tagCollection2 = new TagCollection(this);
        for (Tag tag : this.tags) {
            if (!tagCollection.contains(tag)) continue;
            tagCollection2.add(tag);
        }
        return tagCollection2;
    }

    public TagCollection minus(TagCollection tagCollection) {
        TagCollection tagCollection2 = new TagCollection(this);
        if (tagCollection != null) {
            tagCollection2.remove(tagCollection);
        }
        return tagCollection2;
    }

    public TagCollection union(TagCollection tagCollection) {
        TagCollection tagCollection2 = new TagCollection(this);
        if (tagCollection != null) {
            tagCollection2.add(tagCollection);
        }
        return tagCollection2;
    }

    public TagCollection emptyTagsForKeysMissingIn(TagCollection tagCollection) {
        TagCollection tagCollection2 = new TagCollection();
        for (String string : this.minus(tagCollection).getKeys()) {
            tagCollection2.add(new Tag(string));
        }
        return tagCollection2;
    }

    public String getJoinedValues(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>(this.getValues(string));
        arrayList.remove("");
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }
}

