/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.QuadTiling;
import org.openstreetmap.josm.data.osm.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadBuckets
implements Collection<Node> {
    public static boolean debug = false;
    static boolean consistency_testing = false;
    long last_out = -1L;
    public static int NR_LEVELS = 24;
    public static double WORLD_PARTS = 1 << NR_LEVELS;
    public static int MAX_OBJECTS_PER_LEVEL = 16;
    public static int TILES_PER_LEVEL_SHIFT = 2;
    public static int TILES_PER_LEVEL = 1 << TILES_PER_LEVEL_SHIFT;
    private QBLevel root;
    private QBLevel search_cache;

    static void abort(String string) {
        QuadBuckets.out(string);
        Object object = null;
        object.hashCode();
    }

    static void out(String string) {
        System.out.println(string);
    }

    void pout(String string) {
        long l = System.currentTimeMillis();
        if (l - this.last_out < 300L) {
            return;
        }
        this.last_out = l;
        System.out.print(string + "\r");
    }

    void pout(String string, int n, int n2) {
        long l = System.currentTimeMillis();
        if (l - this.last_out < 300L && n + 1 < n2) {
            return;
        }
        this.last_out = l;
        System.out.print(string + " " + (float)((double)(n + 1) * 100.0 / (double)n2) + "% done    \r");
    }

    public QuadBuckets() {
        this.clear();
    }

    @Override
    public void clear() {
        this.root = new QBLevel(null);
        this.search_cache = null;
        if (debug) {
            QuadBuckets.out("QuadBuckets() cleared: " + this);
        }
    }

    @Override
    public boolean add(Node node) {
        if (debug) {
            QuadBuckets.out(this + " QuadBuckets() add: " + node + " size now: " + this.size());
        }
        int n = -1;
        if (consistency_testing) {
            n = this.root.size();
        }
        boolean bl = this.root.add(node);
        if (consistency_testing) {
            int n2 = this.root.size();
            if (bl) {
                --n2;
            }
            if (n != n2) {
                QuadBuckets.abort("size inconsistency before add: " + n + " after: " + n2);
            }
        }
        return bl;
    }

    public void unsupported() {
        QuadBuckets.out("unsupported operation");
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection collection) {
        for (Node node : this) {
            if (collection.contains(node) || this.remove(node)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection collection) {
        for (Object e : collection) {
            if (!(e instanceof Node)) {
                return false;
            }
            Node node = (Node)e;
            if (this.remove(node)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection collection) {
        for (Object e : collection) {
            if (!(e instanceof Node)) {
                return false;
            }
            Node node = (Node)e;
            if (this.add(node)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection collection) {
        boolean bl = true;
        for (Object e : collection) {
            if (!(e instanceof Node)) {
                return false;
            }
            Node node = (Node)e;
            if (this.contains(node)) continue;
            return false;
        }
        return true;
    }

    private void check_type(Object object) {
        if (object instanceof Node) {
            return;
        }
        this.unsupported();
    }

    @Override
    public boolean remove(Object object) {
        this.check_type(object);
        return this.remove((Node)object);
    }

    public boolean remove(Node node) {
        QBLevel qBLevel = this.root.find_exact(node);
        if (!qBLevel.isLeaf()) {
            QuadBuckets.abort("found branch where leaf expected");
        }
        return qBLevel.content.remove(node);
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof Node)) {
            return false;
        }
        QBLevel qBLevel = this.root.find_exact((Node)object);
        return qBLevel != null;
    }

    public ArrayList<Node> toArrayList() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this) {
            arrayList.add(node);
        }
        QuadBuckets.out("returning array list with size: " + arrayList.size());
        return arrayList;
    }

    @Override
    public Object[] toArray() {
        return this.toArrayList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.toArrayList().toArray(TArray);
    }

    @Override
    public Iterator<Node> iterator() {
        return new QuadBucketIterator(this);
    }

    @Override
    public int size() {
        int n = this.root.size();
        if (debug) {
            QuadBuckets.out(this + " QuadBuckets size: " + n);
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public BBox search_to_bbox(LatLon latLon, double d) {
        BBox bBox = new BBox(latLon.lon() - d, latLon.lat() - d, latLon.lon() + d, latLon.lat() + d);
        if (debug) {
            QuadBuckets.out("search bbox before sanity: " + bBox);
        }
        bBox.sanity();
        if (debug) {
            QuadBuckets.out("search bbox after sanity: " + bBox);
        }
        return bBox;
    }

    List<Node> search(LatLon latLon, double d) {
        return this.search(this.search_to_bbox(latLon, d), latLon, d);
    }

    List<Node> search(BBox bBox) {
        return this.search(bBox, null, -1.0);
    }

    public List<Node> search(LatLon latLon, LatLon latLon2) {
        BBox bBox = new BBox(latLon.lon(), latLon.lat(), latLon2.lon(), latLon2.lat());
        bBox.sanity();
        return this.search(bBox);
    }

    List<Node> search(BBox bBox, LatLon latLon, double d) {
        if (debug) {
            QuadBuckets.out("qb root search at " + latLon + " around: " + d);
            QuadBuckets.out("root bbox: " + this.root.bbox());
        }
        Object var5_4 = null;
        boolean bl = true;
        if (bl) {
            if (this.search_cache == null) {
                this.search_cache = this.root;
            }
            while (!this.search_cache.bbox().bounds(bBox)) {
                this.search_cache = this.search_cache.parent;
            }
        } else {
            this.search_cache = this.root;
        }
        return this.search_cache.search(bBox, latLon, d);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QuadBucketIterator
    implements Iterator<Node> {
        QBLevel current_leaf;
        int index_in_leaf;
        int iterated_over;

        QBLevel next_leaf(QBLevel qBLevel) {
            if (qBLevel == null) {
                return null;
            }
            QBLevel qBLevel2 = qBLevel;
            QBLevel qBLevel3 = qBLevel.nextLeaf();
            if (consistency_testing && qBLevel2 == qBLevel3) {
                QuadBuckets.abort("got same leaf back leaf: " + qBLevel.isLeaf());
            }
            return qBLevel3;
        }

        public QuadBucketIterator(QuadBuckets quadBuckets2) {
            if (debug) {
                QuadBuckets.out(this + " is a new iterator qb.root: " + quadBuckets2.root + " size: " + quadBuckets2.size());
            }
            this.current_leaf = quadBuckets2.root.isLeaf() ? quadBuckets2.root : this.next_leaf(quadBuckets2.root);
            if (debug) {
                QuadBuckets.out("\titerator first leaf: " + this.current_leaf);
            }
            this.iterated_over = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.peek() == null) {
                if (debug) {
                    QuadBuckets.out(this + " no hasNext(), but iterated over so far: " + this.iterated_over);
                }
                return false;
            }
            return true;
        }

        Node peek() {
            if (this.current_leaf == null) {
                if (debug) {
                    QuadBuckets.out("null current leaf, nowhere to go");
                }
                return null;
            }
            while (this.current_leaf.content == null || this.index_in_leaf >= this.current_leaf.content.size()) {
                if (debug) {
                    QuadBuckets.out("moving to next leaf");
                }
                this.index_in_leaf = 0;
                this.current_leaf = this.next_leaf(this.current_leaf);
                if (this.current_leaf != null) continue;
            }
            if (this.current_leaf == null || this.current_leaf.content == null) {
                if (debug) {
                    QuadBuckets.out("late nowhere to go " + this.current_leaf);
                }
                return null;
            }
            return this.current_leaf.content.get(this.index_in_leaf);
        }

        @Override
        public Node next() {
            Node node = this.peek();
            ++this.index_in_leaf;
            if (debug) {
                QuadBuckets.out("iteration[" + this.iterated_over + "] " + this.index_in_leaf + " leaf: " + this.current_leaf);
            }
            ++this.iterated_over;
            if (node == null && debug) {
                QuadBuckets.out(this + " no next node, but iterated over so far: " + this.iterated_over);
            }
            return node;
        }

        @Override
        public void remove() {
            --this.index_in_leaf;
            this.current_leaf.content.remove(this.index_in_leaf);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QBLevel {
        int level;
        long quad;
        QBLevel parent;
        public List<Node> content;
        public QBLevel[] children;
        double width = Double.NEGATIVE_INFINITY;
        BBox bbox = null;

        public QBLevel(QBLevel qBLevel) {
            this.init(qBLevel);
        }

        String quads(Node node) {
            return Long.toHexString(QuadTiling.quadTile(node.getCoor()));
        }

        void split() {
            if (debug) {
                QuadBuckets.out("splitting " + this.bbox() + " level " + this.level + " with " + this.content.size() + " entries (my dimensions: " + this.bbox.width() + ", " + this.bbox.height() + ")");
            }
            if (this.children != null) {
                QuadBuckets.abort("overwrote children");
            }
            this.children = new QBLevel[QuadTiling.TILES_PER_LEVEL];
            List<Node> list = this.content;
            this.content = null;
            for (Node node : list) {
                int n = QuadTiling.index(node, this.level);
                if (this.children[n] == null) {
                    this.children[n] = new QBLevel(this, n);
                }
                QBLevel qBLevel = this.children[n];
                if (debug) {
                    QuadBuckets.out("putting " + node + "(q:" + this.quads(node) + ") into [" + n + "] " + qBLevel.bbox());
                }
                qBLevel.add(node);
            }
        }

        void add_leaf(Node node) {
            LatLon latLon = node.getCoor();
            QBLevel qBLevel = this;
            if (this.content == null) {
                if (debug) {
                    QuadBuckets.out("   new content array");
                }
                this.content = new LinkedList<Node>();
            }
            this.content.add(node);
            if (this.content.size() > MAX_OBJECTS_PER_LEVEL) {
                int n;
                if (debug) {
                    QuadBuckets.out("[" + this.level + "] deciding to split");
                }
                if (this.level >= NR_LEVELS - 1) {
                    QuadBuckets.out("can not split, but too deep: " + this.level + " size: " + this.content.size());
                    return;
                }
                int n2 = -1;
                if (consistency_testing) {
                    n2 = this.size();
                }
                this.split();
                if (consistency_testing && n2 != (n = this.size())) {
                    QuadBuckets.abort("[" + this.level + "] split done before: " + n2 + " after: " + n);
                }
                return;
            }
            if (debug) {
                QuadBuckets.out("   plain content put now have " + this.content.size());
                if (this.content.contains(latLon)) {
                    QuadBuckets.out("   and I already have that one");
                }
            }
        }

        List<Node> search(BBox bBox, LatLon latLon, double d) {
            if (this.isLeaf()) {
                return this.search_leaf(bBox, latLon, d);
            }
            return this.search_branch(bBox, latLon, d);
        }

        private List<Node> search_leaf(BBox bBox, LatLon latLon, double d) {
            if (debug) {
                QuadBuckets.out("searching contents in tile " + this.bbox() + " for " + bBox);
            }
            if (this.content == null) {
                return null;
            }
            LinkedList<Node> linkedList = new LinkedList<Node>();
            for (Node node : this.content) {
                if (latLon == null) {
                    linkedList.add(node);
                    continue;
                }
                LatLon latLon2 = node.getCoor();
                double d2 = latLon2.greatCircleDistance(latLon);
                if (debug) {
                    QuadBuckets.out("[" + this.level + "] Checking coor: " + latLon2 + " dist: " + d2 + " vs. " + d + " " + this.quads(node));
                }
                if (d2 > d) continue;
                if (debug) {
                    QuadBuckets.out("hit in quad: " + Long.toHexString(this.quad) + "\n");
                }
                linkedList.add(node);
            }
            if (debug) {
                QuadBuckets.out("done searching quad " + Long.toHexString(this.quad));
            }
            return linkedList;
        }

        boolean isLeaf() {
            return this.children == null;
        }

        QBLevel next_sibling() {
            boolean bl = false;
            if (this.parent == null) {
                return null;
            }
            int n = 0;
            for (QBLevel qBLevel : this.parent.children) {
                int n2 = ++n - 1;
                if (qBLevel == null) {
                    if (!debug) continue;
                    QuadBuckets.out("[" + this.level + "] null child nr: " + n2);
                    continue;
                }
                if (qBLevel == this) {
                    if (debug) {
                        QuadBuckets.out("[" + this.level + "] I was child nr: " + n2);
                    }
                    bl = true;
                    continue;
                }
                if (bl) {
                    if (debug) {
                        QuadBuckets.out("[" + this.level + "] next sibling was child nr: " + n2);
                    }
                    return qBLevel;
                }
                if (!debug) continue;
                QuadBuckets.out("[" + this.level + "] nr: " + n2 + " is before me, ignoring...");
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        QBLevel nextLeaf() {
            QBLevel qBLevel = this;
            if (this.isLeaf()) {
                void var2_3;
                QBLevel object = qBLevel.next_sibling();
                while (var2_3 == null) {
                    if (debug) {
                        QuadBuckets.out("no siblings at level[" + qBLevel.level + "], moving to parent");
                    }
                    if ((qBLevel = qBLevel.parent) == null) break;
                    QBLevel qBLevel2 = qBLevel.next_sibling();
                }
                qBLevel = var2_3;
            }
            if (qBLevel == null) {
                return null;
            }
            block1: while (!qBLevel.isLeaf()) {
                if (debug) {
                    QuadBuckets.out("[" + qBLevel.level + "] next node is a branch, moving down...");
                }
                for (QBLevel qBLevel3 : qBLevel.children) {
                    if (qBLevel3 == null) continue;
                    qBLevel = qBLevel3;
                    continue block1;
                }
            }
            return qBLevel;
        }

        int size() {
            if (this.isLeaf()) {
                return this.size_leaf();
            }
            return this.size_branch();
        }

        private int size_leaf() {
            if (this.content == null) {
                if (debug) {
                    QuadBuckets.out("[" + this.level + "] leaf size: null content, children? " + this.children);
                }
                return 0;
            }
            if (debug) {
                QuadBuckets.out("[" + this.level + "] leaf size: " + this.content.size());
            }
            return this.content.size();
        }

        private int size_branch() {
            int n = 0;
            for (QBLevel qBLevel : this.children) {
                if (qBLevel == null) continue;
                n += qBLevel.size();
            }
            if (debug) {
                QuadBuckets.out("[" + this.level + "] branch size: " + n);
            }
            return n;
        }

        boolean contains(Node node) {
            QBLevel qBLevel = this.find_exact(node);
            return qBLevel != null;
        }

        QBLevel find_exact(Node node) {
            if (this.isLeaf()) {
                return this.find_exact_leaf(node);
            }
            return this.find_exact_branch(node);
        }

        QBLevel find_exact_leaf(Node node) {
            QBLevel qBLevel = null;
            if (this.content != null && this.content.contains(node)) {
                qBLevel = this;
            }
            return qBLevel;
        }

        QBLevel find_exact_branch(Node node) {
            QBLevel qBLevel = null;
            for (QBLevel qBLevel2 : this.children) {
                if (qBLevel2 != null && (qBLevel = qBLevel2.find_exact(node)) != null) break;
            }
            return qBLevel;
        }

        boolean add(Node node) {
            if (this.isLeaf()) {
                this.add_leaf(node);
            } else {
                this.add_branch(node);
            }
            return true;
        }

        QBLevel add_branch(Node node) {
            LatLon latLon = node.getCoor();
            int n = QuadTiling.index(node, this.level);
            if (debug) {
                QuadBuckets.out("[" + this.level + "]: " + node + " index " + n + " levelquad:" + this.quads() + " level bbox:" + this.bbox());
            }
            if (debug) {
                QuadBuckets.out("   put in child[" + n + "]");
            }
            if (this.children[n] == null) {
                this.children[n] = new QBLevel(this, n);
            }
            this.children[n].add(node);
            if (consistency_testing) {
                for (int i = 0; i < this.children.length; ++i) {
                    QBLevel qBLevel = this.children[i];
                    if (qBLevel == null || !qBLevel.bbox().bounds(latLon) || i == n) continue;
                    QuadBuckets.out("multible bounding?? expected: " + n + " but saw at " + i + " " + qBLevel.quads());
                    QuadBuckets.out("child[" + i + "] bbox: " + qBLevel.bbox());
                }
            }
            return this;
        }

        private List<Node> search_branch(BBox bBox, LatLon latLon, double d) {
            List<Node> list = null;
            if (debug) {
                System.out.print("[" + this.level + "] qb bbox: " + this.bbox() + " ");
            }
            if (!this.bbox().intersects(bBox)) {
                if (debug) {
                    QuadBuckets.out("miss " + Long.toHexString(this.quad));
                }
                return list;
            }
            if (debug) {
                QuadBuckets.out("hit " + this.quads());
            }
            if (debug) {
                QuadBuckets.out("[" + this.level + "] not leaf, moving down");
            }
            int n = 0;
            for (QBLevel qBLevel : this.children) {
                List<Node> list2;
                if (qBLevel == null) continue;
                ++n;
                if (debug) {
                    System.out.print(n + ": ");
                }
                if ((list2 = qBLevel.search(bBox, latLon, d)) == null) continue;
                if (list == null) {
                    list = list2;
                } else {
                    list.addAll(list2);
                }
                if (!qBLevel.bbox().bounds(bBox)) continue;
                QuadBuckets.this.search_cache = qBLevel;
                if (list2.size() <= 0) continue;
                if (!debug) break;
                QuadBuckets.out("break early");
                break;
            }
            return list;
        }

        public String quads() {
            return Long.toHexString(this.quad);
        }

        public void init(QBLevel qBLevel) {
            this.parent = qBLevel;
            if (qBLevel != null) {
                this.level = qBLevel.level + 1;
            }
            this.quad = 0L;
        }

        int index_of(QBLevel qBLevel) {
            if (this.isLeaf()) {
                return -1;
            }
            for (int i = 0; i < QuadTiling.TILES_PER_LEVEL; ++i) {
                if (this.children[i] != qBLevel) continue;
                return i;
            }
            return -1;
        }

        public QBLevel(QBLevel qBLevel, int n) {
            this.init(qBLevel);
            this.level = qBLevel.level + 1;
            this.parent = qBLevel;
            int n2 = (NR_LEVELS - this.level) * 2;
            long l = 1L;
            if (n2 >= 30) {
                n2 -= 30;
                l = 0x40000000L;
            }
            long l2 = l * (long)(n << n2);
            this.quad = qBLevel.quad | l2;
            if (debug) {
                QuadBuckets.out("new level[" + this.level + "] bbox[" + n + "]: " + this.bbox() + " coor: " + this.coor() + " quadpart: " + Long.toHexString(l2) + " quad: " + Long.toHexString(this.quad));
            }
        }

        double width() {
            if (this.width != Double.NEGATIVE_INFINITY) {
                return this.width;
            }
            this.width = this.level == 0 ? this.bbox().width() : this.parent.width() / 2.0;
            return this.width;
        }

        double height() {
            return this.width() / 2.0;
        }

        public BBox bbox() {
            if (this.bbox != null) {
                this.bbox.sanity();
                return this.bbox;
            }
            if (this.level == 0) {
                this.bbox = new BBox(-180.0, 90.0, 180.0, -90.0);
            } else {
                LatLon latLon = this.coor();
                double d = latLon.lat() + this.height();
                double d2 = latLon.lon() + this.width();
                LatLon latLon2 = new LatLon(d, d2);
                this.bbox = new BBox(latLon, latLon2);
            }
            this.bbox.sanity();
            return this.bbox;
        }

        LatLon coor() {
            return QuadTiling.tile2LatLon(this.quad);
        }
    }

    class BBox {
        private double xmin;
        private double xmax;
        private double ymin;
        private double ymax;

        void sanity() {
            if (this.xmin < -180.0) {
                this.xmin = -180.0;
            }
            if (this.xmax > 180.0) {
                this.xmax = 180.0;
            }
            if (this.ymin < -90.0) {
                this.ymin = -90.0;
            }
            if (this.ymax > 90.0) {
                this.ymax = 90.0;
            }
            if (this.xmin < -180.0 || this.xmax > 180.0 || this.ymin < -90.0 || this.ymax > 90.0) {
                QuadBuckets.out("bad BBox: " + this);
                Object object = null;
                object.hashCode();
            }
        }

        public String toString() {
            return "[ " + this.xmin + " -> " + this.xmax + ", " + this.ymin + " -> " + this.ymax + " ]";
        }

        double min(double d, double d2) {
            if (d < d2) {
                return d;
            }
            return d2;
        }

        double max(double d, double d2) {
            if (d > d2) {
                return d;
            }
            return d2;
        }

        public BBox(LatLon latLon, LatLon latLon2) {
            this.xmin = this.min(latLon.lon(), latLon2.lon());
            this.xmax = this.max(latLon.lon(), latLon2.lon());
            this.ymin = this.min(latLon.lat(), latLon2.lat());
            this.ymax = this.max(latLon.lat(), latLon2.lat());
            this.sanity();
        }

        public BBox(double d, double d2, double d3, double d4) {
            this.xmin = this.min(d, d3);
            this.xmax = this.max(d, d3);
            this.ymin = this.min(d2, d4);
            this.ymax = this.max(d2, d4);
            this.sanity();
        }

        public double height() {
            return this.ymax - this.ymin;
        }

        public double width() {
            return this.xmax - this.xmin;
        }

        boolean bounds(BBox bBox) {
            return this.xmin <= bBox.xmin && this.xmax >= bBox.xmax && this.ymin <= bBox.ymin && this.ymax >= bBox.ymax;
        }

        boolean bounds(LatLon latLon) {
            return this.xmin <= latLon.lon() && this.xmax >= latLon.lon() && this.ymin <= latLon.lat() && this.ymax >= latLon.lat();
        }

        boolean inside(BBox bBox) {
            if (this.xmin >= bBox.xmax) {
                return false;
            }
            if (this.xmax <= bBox.xmin) {
                return false;
            }
            if (this.ymin >= bBox.ymax) {
                return false;
            }
            return !(this.ymax <= bBox.ymin);
        }

        boolean intersects(BBox bBox) {
            return this.inside(bBox) || bBox.inside(this);
        }
    }
}

