/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OsmPrimitive
implements Comparable<OsmPrimitive>,
Tagged {
    private static final int FLAG_MODIFIED = 1;
    private static final int FLAG_VISIBLE = 2;
    private static final int FLAG_DISABLED = 4;
    private static final int FLAG_DELETED = 8;
    private static final int FLAG_FILTERED = 16;
    private static final int FLAG_SELECTED = 32;
    private static final int FLAG_HAS_DIRECTIONS = 64;
    private static final int FLAG_TAGGED = 128;
    public ElemStyle mappaintStyle = null;
    public Integer mappaintVisibleCode = 0;
    public Integer mappaintDrawnCode = 0;
    public Collection<String> errors;
    private long id = 0L;
    private volatile byte flags = (byte)2;
    public User user = null;
    public boolean incomplete = false;
    private int version = 0;
    public volatile boolean highlighted = false;
    private int timestamp;
    private static Collection<String> uninteresting = null;
    private static Collection<String> directionKeys = null;
    private Map<String, String> keys;

    public static <T extends OsmPrimitive> List<T> getFilteredList(Collection<OsmPrimitive> collection, Class<T> clazz) {
        if (collection == null) {
            return Collections.emptyList();
        }
        LinkedList<T> linkedList = new LinkedList<T>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!clazz.isInstance(osmPrimitive)) continue;
            linkedList.add(clazz.cast(osmPrimitive));
        }
        return linkedList;
    }

    public static <T extends OsmPrimitive> Set<T> getFilteredSet(Collection<OsmPrimitive> collection, Class<T> clazz) {
        if (collection == null) {
            return Collections.emptySet();
        }
        HashSet<T> hashSet = new HashSet<T>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!clazz.isInstance(osmPrimitive)) continue;
            hashSet.add(clazz.cast(osmPrimitive));
        }
        return hashSet;
    }

    public void putError(String string, Boolean bl) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        String string2 = bl != false ? I18n.tr("Error: {0}", string) : I18n.tr("Warning: {0}", string);
        this.errors.add(string2);
    }

    public void clearErrors() {
        this.errors = null;
    }

    protected void clearCached() {
        this.mappaintVisibleCode = 0;
        this.mappaintDrawnCode = 0;
        this.mappaintStyle = null;
    }

    public OsmPrimitive() {
        this(0L);
    }

    public OsmPrimitive(long l) throws IllegalArgumentException {
        if (l < 0L) {
            throw new IllegalArgumentException(I18n.tr("Expected ID >= 0. Got {0}.", l));
        }
        this.id = l;
        this.version = 0;
        this.incomplete = l > 0L;
    }

    public void setDisabled(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    public boolean isDisabled() {
        return (this.flags & 4) != 0;
    }

    public void setFiltered(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
    }

    public boolean isFiltered() {
        return (this.flags & 0x10) != 0;
    }

    public void setSelected(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 0x20) : (byte)(this.flags & 0xFFFFFFDF);
    }

    public boolean isSelected() {
        return (this.flags & 0x20) != 0;
    }

    public void setModified(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public boolean isModified() {
        return (this.flags & 1) != 0;
    }

    public boolean isDeleted() {
        return (this.flags & 8) != 0;
    }

    public boolean isUsable() {
        return !this.isDeleted() && !this.incomplete && !this.isDisabled();
    }

    public boolean isVisible() {
        return (this.flags & 2) != 0;
    }

    public void setVisible(boolean bl) throws IllegalStateException {
        if (this.id == 0L && !bl) {
            throw new IllegalStateException(I18n.tr("A primitive with ID = 0 can't be invisible."));
        }
        this.flags = bl ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    public long getVersion() {
        return this.version;
    }

    public long getId() {
        return this.id;
    }

    public void setOsmId(long l, int n) {
        if (l <= 0L) {
            throw new IllegalArgumentException(I18n.tr("ID > 0 expected. Got {0}.", l));
        }
        if (n <= 0) {
            throw new IllegalArgumentException(I18n.tr("Version > 0 expected. Got {0}.", n));
        }
        this.id = l;
        this.version = n;
        this.incomplete = false;
    }

    public void clearOsmId() {
        this.id = 0L;
        this.version = 0;
        this.incomplete = false;
    }

    public void setTimestamp(Date date) {
        this.timestamp = (int)(date.getTime() / 1000L);
    }

    public Date getTimestamp() {
        return new Date((long)this.timestamp * 1000L);
    }

    public boolean isTimestampEmpty() {
        return this.timestamp == 0;
    }

    public static Collection<String> getUninterestingKeys() {
        if (uninteresting == null) {
            uninteresting = Main.pref.getCollection("tags.uninteresting", Arrays.asList("source", "note", "comment", "converted_by", "created_by"));
        }
        return uninteresting;
    }

    public static Collection<String> getDirectionKeys() {
        if (directionKeys == null) {
            directionKeys = Main.pref.getCollection("tags.direction", Arrays.asList("oneway", "incline", "incline_steep", "aerialway"));
        }
        return directionKeys;
    }

    public abstract void visit(Visitor var1);

    public void setDeleted(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 8) : (byte)(this.flags & 0xFFFFFFF7);
        this.setModified(bl);
        this.setSelected(false);
    }

    public boolean equals(Object object) {
        if (this.id == 0L) {
            return object == this;
        }
        if (object instanceof OsmPrimitive) {
            return ((OsmPrimitive)object).id == this.id && object.getClass() == this.getClass();
        }
        return false;
    }

    public final int hashCode() {
        if (this.id == 0L) {
            return super.hashCode();
        }
        final int[] nArray = new int[1];
        Visitor visitor = new Visitor(){

            public void visit(Node node) {
                nArray[0] = 0;
            }

            public void visit(Way way) {
                nArray[0] = 1;
            }

            public void visit(Relation relation) {
                nArray[0] = 2;
            }

            public void visit(Changeset changeset) {
                nArray[0] = 3;
            }
        };
        this.visit(visitor);
        return this.id == 0L ? super.hashCode() : (int)(this.id << 2) + nArray[0];
    }

    @Override
    public Map<String, String> getKeys() {
        if (this.keys == null) {
            return new HashMap<String, String>();
        }
        return new HashMap<String, String>(this.keys);
    }

    @Override
    public void setKeys(Map<String, String> map) {
        this.keys = map == null ? null : new HashMap<String, String>(map);
        this.keysChangedImpl();
    }

    @Override
    public final void put(String string, String string2) {
        if (string == null) {
            return;
        }
        if (string2 == null) {
            this.remove(string);
        } else {
            if (this.keys == null) {
                this.keys = new HashMap<String, String>();
            }
            this.keys.put(string, string2);
        }
        this.mappaintStyle = null;
        this.keysChangedImpl();
    }

    @Override
    public final void remove(String string) {
        if (this.keys != null) {
            this.keys.remove(string);
            if (this.keys.isEmpty()) {
                this.keys = null;
            }
        }
        this.mappaintStyle = null;
        this.keysChangedImpl();
    }

    public final void removeAll() {
        this.keys = null;
        this.mappaintStyle = null;
        this.keysChangedImpl();
    }

    @Override
    public final String get(String string) {
        if (string == null) {
            return null;
        }
        return this.keys == null ? null : this.keys.get(string);
    }

    public final Collection<Map.Entry<String, String>> entrySet() {
        if (this.keys == null) {
            return Collections.emptyList();
        }
        return this.keys.entrySet();
    }

    @Override
    public final Collection<String> keySet() {
        if (this.keys == null) {
            return Collections.emptyList();
        }
        return this.keys.keySet();
    }

    @Override
    public final boolean hasKeys() {
        return this.keys != null && !this.keys.isEmpty();
    }

    private void keysChangedImpl() {
        this.updateHasDirectionKeys();
        this.updateTagged();
    }

    public void cloneFrom(OsmPrimitive osmPrimitive) {
        this.keys = osmPrimitive.keys == null ? null : new HashMap<String, String>(osmPrimitive.keys);
        this.id = osmPrimitive.id;
        this.timestamp = osmPrimitive.timestamp;
        this.version = osmPrimitive.version;
        this.incomplete = osmPrimitive.incomplete;
        this.flags = osmPrimitive.flags;
        this.user = osmPrimitive.user;
        this.clearCached();
        this.clearErrors();
    }

    public boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive) {
        if (this.id != osmPrimitive.id) {
            return false;
        }
        if (this.incomplete && !osmPrimitive.incomplete || !this.incomplete && osmPrimitive.incomplete) {
            return false;
        }
        return this.keys == null ? osmPrimitive.keys == null : ((Object)this.keys).equals(osmPrimitive.keys);
    }

    public boolean hasEqualTechnicalAttributes(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null) {
            return false;
        }
        return this.isDeleted() == osmPrimitive.isDeleted() && this.isModified() == osmPrimitive.isModified() && this.timestamp == osmPrimitive.timestamp && this.version == osmPrimitive.version && this.isVisible() == osmPrimitive.isVisible() && (this.user == null ? osmPrimitive.user == null : this.user == osmPrimitive.user);
    }

    private void updateTagged() {
        OsmPrimitive.getUninterestingKeys();
        if (this.keys != null) {
            for (Map.Entry<String, String> entry : this.keys.entrySet()) {
                if (uninteresting.contains(entry.getKey())) continue;
                this.flags = (byte)(this.flags | 0x80);
                return;
            }
        }
        this.flags = (byte)(this.flags & 0xFFFFFF7F);
    }

    public boolean isTagged() {
        return (this.flags & 0x80) != 0;
    }

    private void updateHasDirectionKeys() {
        OsmPrimitive.getDirectionKeys();
        if (this.keys != null) {
            for (Map.Entry<String, String> entry : this.keys.entrySet()) {
                if (!directionKeys.contains(entry.getKey())) continue;
                this.flags = (byte)(this.flags | 0x40);
                return;
            }
        }
        this.flags = (byte)(this.flags & 0xFFFFFFBF);
    }

    public boolean hasDirectionKeys() {
        return (this.flags & 0x40) != 0;
    }

    public String getName() {
        if (this.get("name") != null) {
            return this.get("name");
        }
        return null;
    }

    public String getLocalName() {
        String string = "name:" + Locale.getDefault().toString();
        if (this.get(string) != null) {
            return this.get(string);
        }
        string = "name:" + Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry();
        if (this.get(string) != null) {
            return this.get(string);
        }
        string = "name:" + Locale.getDefault().getLanguage();
        if (this.get(string) != null) {
            return this.get(string);
        }
        return this.getName();
    }

    public abstract String getDisplayName(NameFormatter var1);
}

