/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.Visitor;

public final class Node
extends OsmPrimitive {
    private CachedLatLon coor;

    public final void setCoor(LatLon latLon) {
        if (latLon != null) {
            if (this.coor == null) {
                this.coor = new CachedLatLon(latLon);
            } else {
                this.coor.setCoor(latLon);
            }
        }
    }

    public final LatLon getCoor() {
        return this.coor;
    }

    public final void setEastNorth(EastNorth eastNorth) {
        if (eastNorth != null) {
            if (this.coor != null) {
                this.coor.setEastNorth(eastNorth);
            } else {
                this.coor = new CachedLatLon(eastNorth);
            }
        }
    }

    public final EastNorth getEastNorth() {
        return this.coor != null ? this.coor.getEastNorth() : null;
    }

    public Node() {
        this(0L);
    }

    public Node(long l) {
        super(l);
    }

    public Node(Node node) {
        super(node.getId());
        this.cloneFrom(node);
    }

    public Node(LatLon latLon) {
        super(0L);
        this.setCoor(latLon);
    }

    public Node(EastNorth eastNorth) {
        super(0L);
        this.setEastNorth(eastNorth);
    }

    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    public void cloneFrom(OsmPrimitive osmPrimitive) {
        super.cloneFrom(osmPrimitive);
        this.setCoor(((Node)osmPrimitive).coor);
    }

    public String toString() {
        if (this.coor == null) {
            return "{Node id=" + this.getId() + "}";
        }
        return "{Node id=" + this.getId() + ",version=" + this.getVersion() + ",lat=" + this.coor.lat() + ",lon=" + this.coor.lon() + "}";
    }

    public boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null || !(osmPrimitive instanceof Node)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(osmPrimitive)) {
            return false;
        }
        Node node = (Node)osmPrimitive;
        if (this.coor == null && node.coor == null) {
            return true;
        }
        if (this.coor != null && node.coor != null) {
            return this.coor.equals(node.coor);
        }
        return false;
    }

    public int compareTo(OsmPrimitive osmPrimitive) {
        return osmPrimitive instanceof Node ? Long.valueOf(this.getId()).compareTo(osmPrimitive.getId()) : 1;
    }

    public String getDisplayName(NameFormatter nameFormatter) {
        return nameFormatter.format(this);
    }
}

