/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSet
implements Cloneable {
    public String version;
    public Collection<Node> nodes = new QuadBuckets();
    public Collection<Way> ways = new LinkedList<Way>();
    public Collection<Relation> relations = new LinkedList<Relation>();
    public Collection<DataSource> dataSources = new LinkedList<DataSource>();
    public static Collection<SelectionChangedListener> selListeners = new LinkedList<SelectionChangedListener>();

    public List<OsmPrimitive> allPrimitives() {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        linkedList.addAll(this.nodes);
        linkedList.addAll(this.ways);
        linkedList.addAll(this.relations);
        return linkedList;
    }

    public Collection<OsmPrimitive> allNonDeletedPrimitives() {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : this.allPrimitives()) {
            if (!osmPrimitive.isVisible() || osmPrimitive.isDeleted()) continue;
            linkedList.add(osmPrimitive);
        }
        return linkedList;
    }

    public Collection<OsmPrimitive> allNonDeletedCompletePrimitives() {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : this.allPrimitives()) {
            if (!osmPrimitive.isVisible() || osmPrimitive.isDeleted() || osmPrimitive.incomplete) continue;
            linkedList.add(osmPrimitive);
        }
        return linkedList;
    }

    public Collection<OsmPrimitive> allNonDeletedPhysicalPrimitives() {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : this.allPrimitives()) {
            if (!osmPrimitive.isVisible() || osmPrimitive.isDeleted() || osmPrimitive.incomplete || osmPrimitive instanceof Relation) continue;
            linkedList.add(osmPrimitive);
        }
        return linkedList;
    }

    public void addPrimitive(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null) {
            return;
        }
        if (osmPrimitive instanceof Node) {
            this.nodes.add((Node)osmPrimitive);
        } else if (osmPrimitive instanceof Way) {
            this.ways.add((Way)osmPrimitive);
        } else if (osmPrimitive instanceof Relation) {
            this.relations.add((Relation)osmPrimitive);
        }
    }

    public void removePrimitive(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null) {
            return;
        }
        if (osmPrimitive instanceof Node) {
            this.nodes.remove(osmPrimitive);
        } else if (osmPrimitive instanceof Way) {
            this.ways.remove(osmPrimitive);
        } else if (osmPrimitive instanceof Relation) {
            this.relations.remove(osmPrimitive);
        }
    }

    public Collection<OsmPrimitive> getSelectedNodesAndWays() {
        Collection<OsmPrimitive> collection = this.getSelected(this.nodes);
        collection.addAll(this.getSelected(this.ways));
        return collection;
    }

    public Collection<OsmPrimitive> getSelected() {
        Collection<OsmPrimitive> collection = this.getSelected(this.nodes);
        collection.addAll(this.getSelected(this.ways));
        collection.addAll(this.getSelected(this.relations));
        return collection;
    }

    public Collection<OsmPrimitive> getSelectedNodes() {
        return this.getSelected(this.nodes);
    }

    public Collection<OsmPrimitive> getSelectedWays() {
        return this.getSelected(this.ways);
    }

    public Collection<OsmPrimitive> getSelectedRelations() {
        return this.getSelected(this.relations);
    }

    public void setFiltered(Collection<? extends OsmPrimitive> collection) {
        this.clearFiltered(this.nodes);
        this.clearFiltered(this.ways);
        this.clearFiltered(this.relations);
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.setFiltered(true);
        }
    }

    public void setFiltered(OsmPrimitive ... osmPrimitiveArray) {
        if (osmPrimitiveArray.length == 1 && osmPrimitiveArray[0] == null) {
            this.setFiltered(new OsmPrimitive[0]);
            return;
        }
        this.clearFiltered(this.nodes);
        this.clearFiltered(this.ways);
        this.clearFiltered(this.relations);
        for (OsmPrimitive osmPrimitive : osmPrimitiveArray) {
            if (osmPrimitive == null) continue;
            osmPrimitive.setFiltered(true);
        }
    }

    public void setDisabled(Collection<? extends OsmPrimitive> collection) {
        this.clearDisabled(this.nodes);
        this.clearDisabled(this.ways);
        this.clearDisabled(this.relations);
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.setDisabled(true);
        }
    }

    public void setDisabled(OsmPrimitive ... osmPrimitiveArray) {
        if (osmPrimitiveArray.length == 1 && osmPrimitiveArray[0] == null) {
            this.setDisabled(new OsmPrimitive[0]);
            return;
        }
        this.clearDisabled(this.nodes);
        this.clearDisabled(this.ways);
        this.clearDisabled(this.relations);
        for (OsmPrimitive osmPrimitive : osmPrimitiveArray) {
            if (osmPrimitive == null) continue;
            osmPrimitive.setDisabled(true);
        }
    }

    public void setSelected(Collection<? extends OsmPrimitive> collection) {
        this.clearSelection(this.nodes);
        this.clearSelection(this.ways);
        this.clearSelection(this.relations);
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.setSelected(true);
        }
        DataSet.fireSelectionChanged(collection);
    }

    public void setSelected(OsmPrimitive ... osmPrimitiveArray) {
        if (osmPrimitiveArray.length == 1 && osmPrimitiveArray[0] == null) {
            this.setSelected(new OsmPrimitive[0]);
            return;
        }
        this.clearSelection(this.nodes);
        this.clearSelection(this.ways);
        this.clearSelection(this.relations);
        for (OsmPrimitive osmPrimitive : osmPrimitiveArray) {
            if (osmPrimitive == null) continue;
            osmPrimitive.setSelected(true);
        }
        DataSet.fireSelectionChanged(Arrays.asList(osmPrimitiveArray));
    }

    private void clearFiltered(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.setFiltered(false);
        }
    }

    private void clearDisabled(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.setDisabled(false);
        }
    }

    private void clearSelection(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.setSelected(false);
        }
    }

    private Collection<OsmPrimitive> getSelected(Collection<? extends OsmPrimitive> collection) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        if (collection == null) {
            return hashSet;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (!osmPrimitive.isSelected() || osmPrimitive.isDeleted()) continue;
            hashSet.add(osmPrimitive);
        }
        return hashSet;
    }

    public static void fireSelectionChanged(Collection<? extends OsmPrimitive> collection) {
        for (SelectionChangedListener selectionChangedListener : selListeners) {
            selectionChangedListener.selectionChanged(collection);
        }
    }

    public DataSet clone() {
        DataSet dataSet = new DataSet();
        for (Node object : this.nodes) {
            dataSet.nodes.add(new Node(object));
        }
        for (Way way : this.ways) {
            dataSet.ways.add(new Way(way));
        }
        for (Relation relation : this.relations) {
            dataSet.relations.add(new Relation(relation));
        }
        for (DataSource dataSource : this.dataSources) {
            dataSet.dataSources.add(new DataSource(dataSource.bounds, dataSource.origin));
        }
        dataSet.version = this.version;
        return dataSet;
    }

    public Area getDataSourceArea() {
        if (this.dataSources.isEmpty()) {
            return null;
        }
        Area area = new Area();
        for (DataSource dataSource : this.dataSources) {
            area.add(new Area(dataSource.bounds.asRect()));
        }
        return area;
    }

    public static OsmPrimitive[] sort(Collection<? extends OsmPrimitive> collection) {
        OsmPrimitive[] osmPrimitiveArray = new OsmPrimitive[collection.size()];
        final HashMap hashMap = new HashMap();
        osmPrimitiveArray = collection.toArray(osmPrimitiveArray);
        Arrays.sort(osmPrimitiveArray, new Comparator<OsmPrimitive>(){

            @Override
            public int compare(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
                if (osmPrimitive.getClass() == osmPrimitive2.getClass()) {
                    int n;
                    String string;
                    String string2 = (String)hashMap.get(osmPrimitive);
                    if (string2 == null) {
                        string2 = osmPrimitive.getName() != null ? osmPrimitive.getName() : Long.toString(osmPrimitive.getId());
                        hashMap.put(osmPrimitive, string2);
                    }
                    if ((string = (String)hashMap.get(osmPrimitive2)) == null) {
                        string = osmPrimitive2.getName() != null ? osmPrimitive2.getName() : Long.toString(osmPrimitive2.getId());
                        hashMap.put(osmPrimitive2, string);
                    }
                    if ((n = string2.compareTo(string)) != 0) {
                        return n;
                    }
                }
                return osmPrimitive.compareTo(osmPrimitive2);
            }
        });
        return osmPrimitiveArray;
    }

    public OsmPrimitive getPrimitiveById(long l, OsmPrimitiveType osmPrimitiveType) {
        if (l <= 0L) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "id", l));
        }
        if (l <= 0L) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "type"));
        }
        Collection<OsmPrimitive> collection = null;
        switch (osmPrimitiveType) {
            case NODE: {
                collection = this.nodes;
                break;
            }
            case WAY: {
                collection = this.ways;
                break;
            }
            case RELATION: {
                collection = this.relations;
            }
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive.getId() != l) continue;
            return osmPrimitive;
        }
        return null;
    }

    public Set<Long> getPrimitiveIds() {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (Node osmPrimitive : this.nodes) {
            hashSet.add(osmPrimitive.getId());
        }
        for (Way way : this.ways) {
            hashSet.add(way.getId());
        }
        for (Relation relation : this.relations) {
            hashSet.add(relation.getId());
        }
        return hashSet;
    }

    protected void deleteWay(Way way) {
        way.setNodes(null);
        way.setDeleted(true);
    }

    public void unlinkNodeFromWays(Node node) {
        for (Way way : this.ways) {
            List<Node> list = way.getNodes();
            if (!list.remove(node)) continue;
            if (list.size() < 2) {
                this.deleteWay(way);
                continue;
            }
            way.setNodes(list);
        }
    }

    public void unlinkPrimitiveFromRelations(OsmPrimitive osmPrimitive) {
        for (Relation relation : this.relations) {
            Iterator<RelationMember> iterator = relation.getMembers().iterator();
            while (iterator.hasNext()) {
                RelationMember relationMember = iterator.next();
                if (!relationMember.getMember().equals(osmPrimitive)) continue;
                iterator.remove();
            }
        }
    }

    public void unlinkReferencesToPrimitive(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Node) {
            this.unlinkNodeFromWays((Node)osmPrimitive);
            this.unlinkPrimitiveFromRelations(osmPrimitive);
        } else {
            this.unlinkPrimitiveFromRelations(osmPrimitive);
        }
    }

    public List<Relation> getParentRelations(Relation relation) {
        ArrayList<Relation> arrayList = new ArrayList<Relation>();
        if (relation == null) {
            return arrayList;
        }
        block0: for (Relation relation2 : this.relations) {
            if (relation2 == relation) continue;
            for (RelationMember relationMember : relation2.getMembers()) {
                if (!relationMember.refersTo(relation)) continue;
                arrayList.add(relation2);
                continue block0;
            }
        }
        return arrayList;
    }

    public boolean isModified() {
        for (Node osmPrimitive : this.nodes) {
            if (!osmPrimitive.isModified()) continue;
            return true;
        }
        for (Way way : this.ways) {
            if (!way.isModified()) continue;
            return true;
        }
        for (Relation relation : this.relations) {
            if (!relation.isModified()) continue;
            return true;
        }
        return false;
    }

    public Set<Relation> getReferringRelations(Collection<? extends OsmPrimitive> collection) {
        HashSet<Relation> hashSet = new HashSet<Relation>();
        if (collection == null) {
            return hashSet;
        }
        HashSet<? extends OsmPrimitive> hashSet2 = collection instanceof Set ? (HashSet<? extends OsmPrimitive>)collection : new HashSet<OsmPrimitive>(collection);
        hashSet2.remove(null);
        for (Relation relation : this.relations) {
            if (relation.isDeleted() || relation.incomplete) continue;
            Set<OsmPrimitive> set = relation.getMemberPrimitives();
            set.retainAll(hashSet2);
            if (set.isEmpty()) continue;
            hashSet.add(relation);
        }
        return hashSet;
    }
}

