/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.gpx.WithAttributes;

public class GpxData
extends WithAttributes {
    public static final String META_PREFIX = "meta.";
    public static final String META_AUTHOR_NAME = "meta.author.name";
    public static final String META_AUTHOR_EMAIL = "meta.author.email";
    public static final String META_AUTHOR_LINK = "meta.author.link";
    public static final String META_COPYRIGHT_AUTHOR = "meta.copyright.author";
    public static final String META_COPYRIGHT_LICENSE = "meta.copyright.license";
    public static final String META_COPYRIGHT_YEAR = "meta.copyright.year";
    public static final String META_DESC = "meta.desc";
    public static final String META_KEYWORDS = "meta.keywords";
    public static final String META_LINKS = "meta.links";
    public static final String META_NAME = "meta.name";
    public static final String META_TIME = "meta.time";
    public File storageFile;
    public boolean fromServer;
    public Collection<GpxTrack> tracks = new LinkedList<GpxTrack>();
    public Collection<GpxRoute> routes = new LinkedList<GpxRoute>();
    public Collection<WayPoint> waypoints = new LinkedList<WayPoint>();

    public void mergeFrom(GpxData gpxData) {
        if (this.storageFile == null && gpxData.storageFile != null) {
            this.storageFile = gpxData.storageFile;
        }
        this.fromServer = this.fromServer && gpxData.fromServer;
        for (Map.Entry entry : gpxData.attr.entrySet()) {
            String string = (String)entry.getKey();
            if (string.equals(META_LINKS) && this.attr.containsKey(META_LINKS)) {
                ((Collection)this.attr.get(META_LINKS)).addAll((Collection)entry.getValue());
                continue;
            }
            this.attr.put(string, entry.getValue());
        }
        this.tracks.addAll(gpxData.tracks);
        this.routes.addAll(gpxData.routes);
        this.waypoints.addAll(gpxData.waypoints);
    }

    public boolean hasTrackPoints() {
        for (GpxTrack gpxTrack : this.tracks) {
            for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                if (collection.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRoutePoints() {
        for (GpxRoute gpxRoute : this.routes) {
            if (gpxRoute.routePoints.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Bounds recalculateBounds() {
        Bounds bounds = null;
        for (WayPoint withAttributes : this.waypoints) {
            if (bounds == null) {
                bounds = new Bounds(withAttributes.getCoor());
                continue;
            }
            bounds.extend(withAttributes.getCoor());
        }
        for (GpxRoute gpxRoute : this.routes) {
            for (WayPoint wayPoint : gpxRoute.routePoints) {
                if (bounds == null) {
                    bounds = new Bounds(wayPoint.getCoor());
                    continue;
                }
                bounds.extend(wayPoint.getCoor());
            }
        }
        for (GpxTrack gpxTrack : this.tracks) {
            for (Collection collection : gpxTrack.trackSegs) {
                for (WayPoint wayPoint : collection) {
                    if (bounds == null) {
                        bounds = new Bounds(wayPoint.getCoor());
                        continue;
                    }
                    bounds.extend(wayPoint.getCoor());
                }
            }
        }
        return bounds;
    }

    public double length() {
        double d = 0.0;
        for (GpxTrack gpxTrack : this.tracks) {
            d += gpxTrack.length();
        }
        return d;
    }
}

