/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;

public class QuadTiling {
    public static int NR_LEVELS = 24;
    public static double WORLD_PARTS = 1 << NR_LEVELS;
    public static int MAX_OBJECTS_PER_LEVEL = 16;
    public static int TILES_PER_LEVEL_SHIFT = 2;
    public static int TILES_PER_LEVEL = 1 << TILES_PER_LEVEL_SHIFT;
    public static int X_PARTS = 360;
    public static int X_BIAS = -180;
    public static int Y_PARTS = 180;
    public static int Y_BIAS = -90;

    public static LatLon tile2LatLon(long l) {
        double d = X_PARTS / 2;
        double d2 = Y_PARTS / 2;
        long l2 = NR_LEVELS * 2 - 2;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < NR_LEVELS; ++i) {
            long l3 = l >> (int)l2 & 3L;
            if ((l3 & 2L) != 0L) {
                d3 += d;
            }
            if ((l3 & 1L) != 0L) {
                d4 += d2;
            }
            d /= 2.0;
            d2 /= 2.0;
            l2 -= 2L;
        }
        return new LatLon(d4 += (double)Y_BIAS, d3 += (double)X_BIAS);
    }

    static long xy2tile(long l, long l2) {
        long l3 = 0L;
        for (int i = NR_LEVELS - 1; i >= 0; --i) {
            long l4 = l >> i & 1L;
            long l5 = l2 >> i & 1L;
            l3 <<= 2;
            l3 |= l4 << 1 | l5;
        }
        return l3;
    }

    static long coorToTile(LatLon latLon) {
        return QuadTiling.quadTile(latLon);
    }

    static long lon2x(double d) {
        long l = (long)Math.floor((d + 180.0) * WORLD_PARTS / 360.0);
        if ((double)l == WORLD_PARTS) {
            --l;
        }
        return l;
    }

    static long lat2y(double d) {
        long l = (long)Math.floor((d + 90.0) * WORLD_PARTS / 180.0);
        if ((double)l == WORLD_PARTS) {
            --l;
        }
        return l;
    }

    public static long quadTile(LatLon latLon) {
        return QuadTiling.xy2tile(QuadTiling.lon2x(latLon.lon()), QuadTiling.lat2y(latLon.lat()));
    }

    public static int index(int n, long l) {
        long l2 = 3L;
        int n2 = TILES_PER_LEVEL_SHIFT * (NR_LEVELS - n - 1);
        return (int)(l2 & l >> n2);
    }

    public static int index(Node node, int n) {
        LatLon latLon = node.getCoor();
        if (latLon == null) {
            return 0;
        }
        long l = QuadTiling.coorToTile(node.getCoor());
        return QuadTiling.index(n, l);
    }
}

