/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.conflict;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.IConflictListener;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictCollection
implements Iterable<Conflict<?>> {
    private ArrayList<Conflict<?>> conflicts = new ArrayList();
    private CopyOnWriteArrayList<IConflictListener> listeners = new CopyOnWriteArrayList();

    public void addConflictListener(IConflictListener iConflictListener) {
        if (iConflictListener != null && !this.listeners.contains(iConflictListener)) {
            this.listeners.add(iConflictListener);
        }
    }

    public void removeConflictListener(IConflictListener iConflictListener) {
        if (iConflictListener != null) {
            this.listeners.remove(iConflictListener);
        }
    }

    protected void fireConflictAdded() {
        Iterator<IConflictListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onConflictsAdded(this);
        }
    }

    protected void fireConflictRemoved() {
        Iterator<IConflictListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onConflictsRemoved(this);
        }
    }

    protected void addConflict(Conflict<?> conflict) throws IllegalStateException {
        if (this.hasConflictForMy((OsmPrimitive)conflict.getMy())) {
            throw new IllegalStateException(I18n.tr("Already registered a conflict for primitive ''{0}''.", conflict.getMy().toString()));
        }
        if (!this.conflicts.contains(conflict)) {
            this.conflicts.add(conflict);
        }
    }

    public void add(Conflict<?> conflict) throws IllegalStateException, IllegalArgumentException {
        if (conflict == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "conflict"));
        }
        this.addConflict(conflict);
        this.fireConflictAdded();
    }

    public void add(Collection<Conflict<?>> collection) {
        if (collection == null) {
            return;
        }
        for (Conflict<?> conflict : collection) {
            this.addConflict(conflict);
        }
        this.fireConflictAdded();
    }

    public void add(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        this.addConflict(new Conflict<OsmPrimitive>(osmPrimitive, osmPrimitive2));
        this.fireConflictAdded();
    }

    public void remove(Conflict<?> conflict) {
        this.conflicts.remove(conflict);
        this.fireConflictRemoved();
    }

    public void remove(OsmPrimitive osmPrimitive) {
        Iterator<Conflict<?>> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isMatchingMy(osmPrimitive)) continue;
            iterator.remove();
        }
        this.fireConflictRemoved();
    }

    public Conflict<?> getConflictForMy(OsmPrimitive osmPrimitive) {
        for (Conflict<?> conflict : this.conflicts) {
            if (!conflict.isMatchingMy(osmPrimitive)) continue;
            return conflict;
        }
        return null;
    }

    public Conflict<?> getConflictForTheir(OsmPrimitive osmPrimitive) {
        for (Conflict<?> conflict : this.conflicts) {
            if (!conflict.isMatchingTheir(osmPrimitive)) continue;
            return conflict;
        }
        return null;
    }

    public boolean hasConflictForMy(OsmPrimitive osmPrimitive) {
        return this.getConflictForMy(osmPrimitive) != null;
    }

    public boolean hasConflict(Conflict<?> conflict) {
        return this.hasConflictForMy((OsmPrimitive)conflict.getMy());
    }

    public boolean hasConflictForTheir(OsmPrimitive osmPrimitive) {
        return this.getConflictForTheir(osmPrimitive) != null;
    }

    public void removeForMy(OsmPrimitive osmPrimitive) {
        Iterator<Conflict<?>> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isMatchingMy(osmPrimitive)) continue;
            iterator.remove();
        }
    }

    public void removeForTheir(OsmPrimitive osmPrimitive) {
        Iterator<Conflict<?>> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isMatchingTheir(osmPrimitive)) continue;
            iterator.remove();
        }
    }

    public List<Conflict<?>> get() {
        return this.conflicts;
    }

    public int size() {
        return this.conflicts.size();
    }

    public Conflict<?> get(int n) {
        return this.conflicts.get(n);
    }

    @Override
    public Iterator<Conflict<?>> iterator() {
        return this.conflicts.iterator();
    }

    public void add(ConflictCollection conflictCollection) {
        for (Conflict<?> conflict : conflictCollection) {
            this.add(conflict);
        }
    }

    public Set<OsmPrimitive> getMyConflictParties() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (Conflict<?> conflict : this.conflicts) {
            hashSet.add((OsmPrimitive)conflict.getMy());
        }
        return hashSet;
    }

    public Set<OsmPrimitive> getTheirConflictParties() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (Conflict<?> conflict : this.conflicts) {
            hashSet.add((OsmPrimitive)conflict.getTheir());
        }
        return hashSet;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

