/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AboutAction;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preferences {
    private File preferencesDirFile = null;
    public final ArrayList<PreferenceChangedListener> listener = new ArrayList();
    protected final SortedMap<String, String> properties = new TreeMap<String, String>();
    protected final SortedMap<String, String> defaults = new TreeMap<String, String>();
    protected static final SortedMap<String, String> override = new TreeMap<String, String>();

    public String getPreferencesDir() {
        String string = this.getPreferencesDirFile().getPath();
        if (string.endsWith(File.separator)) {
            return string;
        }
        return string + File.separator;
    }

    public File getPreferencesDirFile() {
        if (this.preferencesDirFile != null) {
            return this.preferencesDirFile;
        }
        String string = System.getProperty("josm.home");
        this.preferencesDirFile = string != null ? new File(string) : ((string = System.getenv("APPDATA")) != null ? new File(string, "JOSM") : new File(System.getProperty("user.home"), ".josm"));
        return this.preferencesDirFile;
    }

    public File getPreferenceFile() {
        return new File(this.getPreferencesDirFile(), "preferences");
    }

    public File getPluginsDirFile() {
        return new File(this.getPreferencesDirFile(), "plugins");
    }

    public Collection<String> getAllPossiblePreferenceDirs() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(Main.pref.getPreferencesDir());
        String string = System.getenv("JOSM_RESOURCES");
        if (string != null) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            linkedList.add(string);
        }
        if ((string = System.getProperty("josm.resources")) != null) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            linkedList.add(string);
        }
        String string2 = System.getenv("APPDATA");
        if (System.getenv("ALLUSERSPROFILE") != null && string2 != null && string2.lastIndexOf(File.separator) != -1) {
            string2 = string2.substring(string2.lastIndexOf(File.separator));
            linkedList.add(new File(new File(System.getenv("ALLUSERSPROFILE"), string2), "JOSM").getPath());
        }
        linkedList.add("/usr/local/share/josm/");
        linkedList.add("/usr/local/lib/josm/");
        linkedList.add("/usr/share/josm/");
        linkedList.add("/usr/lib/josm/");
        return linkedList;
    }

    public synchronized boolean hasKey(String string) {
        return override.containsKey(string) ? override.get(string) != null : this.properties.containsKey(string);
    }

    public synchronized String get(String string) {
        this.putDefault(string, null);
        if (override.containsKey(string)) {
            return (String)override.get(string);
        }
        if (!this.properties.containsKey(string)) {
            return "";
        }
        return (String)this.properties.get(string);
    }

    public synchronized String get(String string, String string2) {
        this.putDefault(string, string2);
        if (override.containsKey(string)) {
            return (String)override.get(string);
        }
        String string3 = (String)this.properties.get(string);
        if (string3 == null || string3.equals("")) {
            return string2;
        }
        return string3;
    }

    public synchronized Map<String, String> getAllPrefix(String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (!entry.getKey().startsWith(string)) continue;
            treeMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : override.entrySet()) {
            if (!entry.getKey().startsWith(string)) continue;
            if (entry.getValue() == null) {
                treeMap.remove(entry.getKey());
                continue;
            }
            treeMap.put(entry.getKey(), entry.getValue());
        }
        return treeMap;
    }

    public synchronized TreeMap<String, String> getAllColors() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : this.defaults.entrySet()) {
            if (!entry.getKey().startsWith("color.") || entry.getValue() == null) continue;
            treeMap.put(entry.getKey().substring(6), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (!entry.getKey().startsWith("color.")) continue;
            treeMap.put(entry.getKey().substring(6), entry.getValue());
        }
        for (Map.Entry<String, String> entry : override.entrySet()) {
            if (!entry.getKey().startsWith("color.")) continue;
            if (entry.getValue() == null) {
                treeMap.remove(entry.getKey().substring(6));
                continue;
            }
            treeMap.put(entry.getKey().substring(6), entry.getValue());
        }
        return treeMap;
    }

    public synchronized Map<String, String> getDefaults() {
        return this.defaults;
    }

    public synchronized void putDefault(String string, String string2) {
        if (!this.defaults.containsKey(string) || this.defaults.get(string) == null) {
            this.defaults.put(string, string2);
        } else if (string2 != null && !((String)this.defaults.get(string)).equals(string2)) {
            System.out.println("Defaults for " + string + " differ: " + string2 + " != " + (String)this.defaults.get(string));
        }
    }

    public synchronized boolean getBoolean(String string) {
        this.putDefault(string, null);
        if (override.containsKey(string)) {
            return override.get(string) == null ? false : Boolean.parseBoolean((String)override.get(string));
        }
        return this.properties.containsKey(string) ? Boolean.parseBoolean((String)this.properties.get(string)) : false;
    }

    public synchronized boolean getBoolean(String string, boolean bl) {
        this.putDefault(string, Boolean.toString(bl));
        if (override.containsKey(string)) {
            return override.get(string) == null ? bl : Boolean.parseBoolean((String)override.get(string));
        }
        return this.properties.containsKey(string) ? Boolean.parseBoolean((String)this.properties.get(string)) : bl;
    }

    public synchronized boolean put(String string, String string2) {
        String string3 = (String)this.properties.get(string);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (!(string3 == null && (string2 == null || string2.equals(this.defaults.get(string))) || string2 != null && string3 != null && string3.equals(string2))) {
            if (string2 == null) {
                this.properties.remove(string);
            } else {
                this.properties.put(string, string2);
            }
            try {
                this.save();
            }
            catch (IOException iOException) {
                System.out.println(I18n.tr("Warning: failed to persist preferences to ''{0}''", this.getPreferenceFile().getAbsoluteFile()));
            }
            this.firePreferenceChanged(string, string2);
            return true;
        }
        return false;
    }

    public synchronized boolean put(String string, boolean bl) {
        return this.put(string, Boolean.toString(bl));
    }

    public synchronized boolean putInteger(String string, Integer n) {
        return this.put(string, Integer.toString(n));
    }

    public synchronized boolean putDouble(String string, Double d) {
        return this.put(string, Double.toString(d));
    }

    public synchronized boolean putLong(String string, Long l) {
        return this.put(string, Long.toString(l));
    }

    private final void firePreferenceChanged(String string, String string2) {
        for (PreferenceChangedListener preferenceChangedListener : this.listener) {
            preferenceChangedListener.preferenceChanged(string, string2);
        }
    }

    public void save() throws IOException {
        this.properties.put("josm.version", AboutAction.getVersionString());
        this.setSystemProperties();
        File file = new File(this.getPreferencesDirFile(), "preferences");
        if (file.exists()) {
            Preferences.copyFile(file, new File(file + "_backup"));
        }
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file + "_tmp"), "utf-8"), false);
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String string = (String)this.defaults.get(entry.getKey());
            if (string != null && string.equals(entry.getValue())) continue;
            printWriter.println(entry.getKey() + "=" + entry.getValue());
        }
        printWriter.close();
        File file2 = new File(file + "_tmp");
        Preferences.copyFile(file2, file);
        file2.delete();
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
        try {
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (fileChannel2 != null) {
                fileChannel2.close();
            }
        }
    }

    public void load() throws IOException {
        this.properties.clear();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getPreferencesDir() + "preferences"), "utf-8"));
        int n = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String string = bufferedReader.readLine();
        while (string != null) {
            int n2 = string.indexOf(61);
            if (n2 == -1 || n2 == 0) {
                arrayList.add(n);
            } else {
                this.properties.put(string.substring(0, n2), string.substring(n2 + 1));
            }
            string = bufferedReader.readLine();
            ++n;
        }
        if (!arrayList.isEmpty()) {
            throw new IOException(I18n.tr("Malformed config file at lines {0}", arrayList));
        }
        this.setSystemProperties();
    }

    public void init(boolean bl) {
        File file = this.getPreferencesDirFile();
        if (file.exists()) {
            if (!file.isDirectory()) {
                System.err.println(I18n.tr("Warning: Failed to initialize preferences. Preference directory ''{0}'' isn't a directory.", file.getAbsoluteFile()));
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Preference directory ''{0}'' isn't a directory.</html>", file.getAbsoluteFile()), I18n.tr("Error"), 0);
                return;
            }
        } else if (!file.mkdirs()) {
            System.err.println(I18n.tr("Warning: Failed to initialize preferences. Failed to create missing preference directory: {0}", file.getAbsoluteFile()));
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Failed to create missing preference directory: {0}</html>", file.getAbsoluteFile()), I18n.tr("Error"), 0);
            return;
        }
        File file2 = this.getPreferenceFile();
        try {
            if (!file2.exists()) {
                System.out.println(I18n.tr("Warning: Missing preference file ''{0}''. Creating a default preference file.", file2.getAbsoluteFile()));
                this.resetToDefault();
                this.save();
            } else if (bl) {
                System.out.println(I18n.tr("Warning: Replacing existing preference file ''{0}'' with default preference file.", file2.getAbsoluteFile()));
                this.resetToDefault();
                this.save();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Failed to reset preference file to default: {0}</html>", this.getPreferenceFile().getAbsoluteFile()), I18n.tr("Error"), 0);
            return;
        }
        try {
            this.load();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            File file3 = new File(file, "preferences.bak");
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Preferences file had errors.<br> Making backup of old one to <br>{0}<br> and creating a new default preference file.</html>", file3.getAbsoluteFile()), I18n.tr("Error"), 0);
            file2.renameTo(file3);
            try {
                this.resetToDefault();
                this.save();
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
                System.err.println(I18n.tr("Warning: Failed to initialize preferences.Failed to reset preference file to default: {0}", this.getPreferenceFile()));
            }
        }
    }

    public final void resetToDefault() {
        this.properties.clear();
        if (System.getProperty("os.name").toUpperCase().indexOf("WINDOWS") == -1) {
            this.put("laf", "javax.swing.plaf.metal.MetalLookAndFeel");
        } else {
            this.put("laf", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
    }

    public File getBookmarksFile() {
        return new File(this.getPreferencesDir(), "bookmarks");
    }

    public Collection<Bookmark> loadBookmarks() throws IOException {
        File file = this.getBookmarksFile();
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
        LinkedList<Bookmark> linkedList = new LinkedList<Bookmark>();
        String string = bufferedReader.readLine();
        while (string != null) {
            Matcher matcher = Pattern.compile("^(.+)[,\u001e](-?\\d+.\\d+)[,\u001e](-?\\d+.\\d+)[,\u001e](-?\\d+.\\d+)[,\u001e](-?\\d+.\\d+)$").matcher(string);
            if (matcher.matches()) {
                Bookmark bookmark = new Bookmark();
                bookmark.name = matcher.group(1);
                for (int i = 0; i < bookmark.latlon.length; ++i) {
                    bookmark.latlon[i] = Double.parseDouble(matcher.group(i + 2));
                }
                linkedList.add(bookmark);
            }
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        Collections.sort(linkedList);
        return linkedList;
    }

    public void saveBookmarks(Collection<Bookmark> collection) throws IOException {
        File file = new File(Main.pref.getPreferencesDir() + "bookmarks");
        if (!file.exists()) {
            file.createNewFile();
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));
        for (Bookmark bookmark : collection) {
            printWriter.print(bookmark.name + "\u001e");
            for (int i = 0; i < bookmark.latlon.length; ++i) {
                printWriter.print(bookmark.latlon[i] + (i < bookmark.latlon.length - 1 ? "\u001e" : ""));
            }
            printWriter.println();
        }
        printWriter.close();
    }

    public synchronized Color getColor(String string, Color color) {
        return this.getColor(string, null, color);
    }

    public synchronized Color getColor(String string, String string2, Color color) {
        String string3;
        this.putDefault("color." + string, ColorHelper.color2html(color));
        String string4 = string3 = string2 != null ? this.get("color." + string2) : "";
        if (string3.equals("")) {
            string3 = this.get("color." + string);
        }
        return string3.equals("") ? color : ColorHelper.html2color(string3);
    }

    public synchronized Color getDefaultColor(String string) {
        String string2 = (String)this.defaults.get("color." + string);
        return string2.equals("") ? null : ColorHelper.html2color(string2);
    }

    public synchronized boolean putColor(String string, Color color) {
        return this.put("color." + string, color != null ? ColorHelper.color2html(color) : null);
    }

    public synchronized int getInteger(String string, int n) {
        this.putDefault(string, Integer.toString(n));
        String string2 = this.get(string);
        if (null == string2) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public synchronized long getLong(String string, long l) {
        this.putDefault(string, Long.toString(l));
        String string2 = this.get(string);
        if (null == string2) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public synchronized double getDouble(String string, double d) {
        this.putDefault(string, Double.toString(d));
        String string2 = this.get(string);
        if (null == string2) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public synchronized double getDouble(String string, String string2) {
        this.putDefault(string, string2);
        String string3 = this.get(string);
        if (string3 != null && string3.length() != 0) {
            try {
                return Double.parseDouble(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public synchronized Collection<String> getCollection(String string, Collection<String> collection) {
        String string2;
        String string3 = this.get(string);
        if (collection != null) {
            string2 = null;
            for (String string4 : collection) {
                if (string2 != null) {
                    string2 = string2 + "\u001e" + string4;
                    continue;
                }
                string2 = string4;
            }
            this.putDefault(string, string2);
        }
        if (string3 != null && string3.length() != 0) {
            if (string3.indexOf("\u001e") < 0 && !(string2 = (string2 = string3).indexOf("\u00c2\u00a7\u00c2\u00a7\u00c2\u00a7") > 0 ? string2.replaceAll("\u00c2\u00a7\u00c2\u00a7\u00c2\u00a7", "\u001e") : string2.replace(';', '\u001e')).equals(string3)) {
                this.put(string, string2);
                string3 = string2;
            }
            return Arrays.asList(string3.split("\u001e"));
        }
        return collection;
    }

    public synchronized void removeFromCollection(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(this.getCollection(string, null));
        if (arrayList != null) {
            arrayList.remove(string2);
            this.putCollection(string, arrayList);
        }
    }

    public synchronized boolean putCollection(String string, Collection<String> collection) {
        String string2 = null;
        if (collection != null) {
            for (String string3 : collection) {
                if (string2 != null) {
                    string2 = string2 + "\u001e" + string3;
                    continue;
                }
                string2 = string3;
            }
        }
        return this.put(string, string2);
    }

    private void setSystemProperties() {
        if (this.getBoolean("proxy.enable")) {
            Properties properties = System.getProperties();
            properties.put("proxySet", "true");
            properties.put("http.proxyHost", this.get("proxy.host"));
            properties.put("proxyPort", this.get("proxy.port"));
            if (!this.getBoolean("proxy.anonymous")) {
                properties.put("proxyUser", this.get("proxy.user"));
                properties.put("proxyPassword", this.get("proxy.pass"));
            }
            System.setProperties(properties);
        }
        AboutAction.setUserAgent();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Bookmark
    implements Comparable<Bookmark> {
        public String name;
        public double[] latlon = new double[4];

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Bookmark bookmark) {
            return this.name.toLowerCase().compareTo(bookmark.name.toLowerCase());
        }
    }

    public static interface PreferenceChangedListener {
        public void preferenceChanged(String var1, String var2);
    }
}

