/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiPreconditionCheckerHook
implements UploadHook {
    @Override
    public boolean checkUpload(APIDataSet aPIDataSet) {
        OsmApi osmApi = OsmApi.getOsmApi();
        try {
            osmApi.initialize(NullProgressMonitor.INSTANCE);
            long l = 0L;
            if (osmApi.getCapabilities().isDefined("waynodes", "maximum")) {
                l = osmApi.getCapabilities().getLong("waynodes", "maximum");
            }
            long l2 = 0L;
            if (osmApi.getCapabilities().isDefined("changesets", "maximum_elements")) {
                l2 = osmApi.getCapabilities().getLong("changesets", "maximum_elements");
            }
            if (l > 0L) {
                if (!this.checkMaxNodes(aPIDataSet.getPrimitivesToAdd(), l)) {
                    return false;
                }
                if (!this.checkMaxNodes(aPIDataSet.getPrimitivesToUpdate(), l)) {
                    return false;
                }
                if (!this.checkMaxNodes(aPIDataSet.getPrimitivesToDelete(), l)) {
                    return false;
                }
            }
            if (l2 > 0L) {
                int n = 0;
                n = aPIDataSet.getPrimitivesToAdd().size() + aPIDataSet.getPrimitivesToUpdate().size() + aPIDataSet.getPrimitivesToDelete().size();
                if ((long)n > l2) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Current number of changes exceeds the max. number of changes, current is {0}, max is {1}", n, l2), I18n.tr("API Capabilities Violation"), 0);
                    return false;
                }
            }
        }
        catch (OsmApiInitializationException osmApiInitializationException) {
            ExceptionDialogUtil.explainOsmTransferException(osmApiInitializationException);
            return false;
        }
        return true;
    }

    private boolean checkMaxNodes(Collection<OsmPrimitive> collection, long l) {
        for (OsmPrimitive osmPrimitive : collection) {
            for (Map.Entry<String, String> entry : osmPrimitive.entrySet()) {
                if (entry.getValue().length() <= 255) continue;
                if (osmPrimitive.isDeleted()) {
                    System.out.println(I18n.tr("Warning: automatically truncating value of tag ''{0}'' on deleted primitive {1}", entry.getKey(), Long.toString(osmPrimitive.getId())));
                    osmPrimitive.put(entry.getKey(), entry.getValue().substring(0, 255));
                    continue;
                }
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Length of value for tag ''{0}'' on primitive {1} exceeds the max. allowed length {2}. Values length is {3}.", entry.getKey(), Long.toString(osmPrimitive.getId()), 255, entry.getValue().length()), I18n.tr("Precondition Violation"), 0);
                Main.main.getCurrentDataSet().setSelected(Collections.singleton(osmPrimitive));
                return false;
            }
            if (!(osmPrimitive instanceof Way) || (long)((Way)osmPrimitive).getNodesCount() <= l) continue;
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("{0} nodes in way {1} exceed the max. allowed number of nodes {2}", ((Way)osmPrimitive).getNodesCount(), Long.toString(osmPrimitive.getId()), l), I18n.tr("API Capabilities Violation"), 0);
            Main.main.getCurrentDataSet().setSelected(Collections.singleton(osmPrimitive));
            return false;
        }
        return true;
    }
}

