/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.io.IOException;
import java.io.PushbackReader;
import java.util.LinkedList;

public class PushbackTokenizer {
    private PushbackReader search;
    private LinkedList<String> pushBackBuf = new LinkedList();

    public PushbackTokenizer(PushbackReader pushbackReader) {
        this.search = pushbackReader;
    }

    public String nextToken() {
        if (!this.pushBackBuf.isEmpty()) {
            return this.pushBackBuf.removeLast();
        }
        try {
            int n;
            char c = ' ';
            while (c == ' ' || c == '\t' || c == '\n') {
                n = this.search.read();
                if (n == -1) {
                    return null;
                }
                c = (char)n;
            }
            switch (c) {
                case ':': 
                case '=': {
                    n = this.search.read();
                    if (n == -1 || n == 32 || n == 9) {
                        this.pushBack(" ");
                    } else {
                        this.search.unread(n);
                    }
                    return String.valueOf(c);
                }
                case '-': {
                    return "-";
                }
                case '(': {
                    return "(";
                }
                case ')': {
                    return ")";
                }
                case '|': {
                    return "|";
                }
                case '\"': {
                    StringBuilder stringBuilder = new StringBuilder(" ");
                    int n2 = this.search.read();
                    while (n2 != -1 && n2 != 34) {
                        stringBuilder.append((char)n2);
                        n2 = this.search.read();
                    }
                    return stringBuilder.toString();
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            do {
                stringBuilder.append(c);
                n = this.search.read();
                if (n != -1) continue;
                if (stringBuilder.toString().equals("OR")) {
                    return "|";
                }
                return " " + stringBuilder.toString();
            } while ((c = (char)n) != ' ' && c != '\t' && c != '\"' && c != ':' && c != '(' && c != ')' && c != '|' && c != 61);
            this.search.unread(n);
            if (stringBuilder.toString().equals("OR")) {
                return "|";
            }
            return " " + stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    public boolean readIfEqual(String string) {
        String string2 = this.nextToken();
        if (string2 == null ? string == null : string2.equals(string)) {
            return true;
        }
        this.pushBack(string2);
        return false;
    }

    public String readText() {
        String string = this.nextToken();
        if (string != null && string.startsWith(" ")) {
            return string.substring(1);
        }
        this.pushBack(string);
        return null;
    }

    public void pushBack(String string) {
        this.pushBackBuf.addLast(string);
    }
}

