/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.RotateCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.data.osm.visitor.SimplePaintVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SelectionManager;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectAction
extends MapMode
implements SelectionManager.SelectionEnded {
    private static final Logger logger = Logger.getLogger(SelectAction.class.getName());
    private Mode mode = null;
    private long mouseDownTime = 0L;
    private boolean didMove = false;
    private boolean cancelDrawMode = false;
    Node virtualNode = null;
    Collection<WaySegment> virtualWays = new ArrayList<WaySegment>();
    SequenceCommand virtualCmds = null;
    private Cursor oldCursor;
    private Point mousePos;
    private SelectionManager selectionManager;
    private int initialMoveDelay;
    private int initialMoveThreshold;
    private boolean initialMoveThresholdExceeded = false;

    public static boolean isPlatformOsx() {
        return Main.platform != null && Main.platform instanceof PlatformHookOsx;
    }

    public SelectAction(MapFrame mapFrame) {
        super(I18n.tr("Select"), "move/move", I18n.tr("Select, move and rotate objects"), Shortcut.registerShortcut("mapmode:select", I18n.tr("Mode: {0}", I18n.tr("Select")), 83, 3), mapFrame, SelectAction.getCursor("normal", "selection", 0));
        this.putValue("help", "Action/Move/Move");
        this.selectionManager = new SelectionManager(this, false, mapFrame.mapView);
        this.initialMoveDelay = Main.pref.getInteger("edit.initial-move-delay", 200);
        this.initialMoveThreshold = Main.pref.getInteger("edit.initial-move-threshold", 5);
    }

    private static Cursor getCursor(String string, String string2, int n) {
        try {
            return ImageProvider.getCursor(string, string2);
        }
        catch (Exception exception) {
            return Cursor.getPredefinedCursor(n);
        }
    }

    private void setCursor(Cursor cursor) {
        if (this.oldCursor == null) {
            this.oldCursor = Main.map.mapView.getCursor();
            Main.map.mapView.setCursor(cursor);
        }
    }

    private void restoreCursor() {
        if (this.oldCursor != null) {
            Main.map.mapView.setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    @Override
    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        Main.map.mapView.setVirtualNodesEnabled(Main.pref.getInteger("mappaint.node.virtual-size", 8) != 0);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        this.selectionManager.unregister(Main.map.mapView);
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.setVirtualNodesEnabled(false);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        this.cancelDrawMode = true;
        if (this.mode == Mode.select) {
            return;
        }
        if (this.mode == Mode.move && System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if (this.mode != Mode.rotate && (mouseEvent.getModifiersEx() & 0x400) == 0) {
            return;
        }
        if (this.mode == Mode.move) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        }
        if (this.mousePos == null) {
            this.mousePos = mouseEvent.getPoint();
            return;
        }
        if (!this.initialMoveThresholdExceeded) {
            int n;
            int n2 = this.mousePos.x - mouseEvent.getX();
            int n3 = (int)Math.sqrt(n2 * n2 + (n = this.mousePos.y - mouseEvent.getY()) * n);
            if (n3 < this.initialMoveThreshold) {
                return;
            }
            this.initialMoveThresholdExceeded = true;
        }
        EastNorth eastNorth = Main.map.mapView.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
        EastNorth eastNorth2 = Main.map.mapView.getEastNorth(this.mousePos.x, this.mousePos.y);
        double d = eastNorth.east() - eastNorth2.east();
        double d2 = eastNorth.north() - eastNorth2.north();
        if (d == 0.0 && d2 == 0.0) {
            return;
        }
        if (this.virtualWays.size() > 0) {
            LinkedList<Command> linkedList = new LinkedList<Command>();
            linkedList.add(new AddCommand(this.virtualNode));
            for (WaySegment waySegment : this.virtualWays) {
                Way way = waySegment.way;
                Way way2 = new Way(way);
                way2.addNode(waySegment.lowerIndex + 1, this.virtualNode);
                linkedList.add(new ChangeCommand(way, way2));
            }
            linkedList.add(new MoveCommand(this.virtualNode, d, d2));
            String string = I18n.trn("Add and move a virtual new node to way", "Add and move a virtual new node to {0} ways", this.virtualWays.size(), this.virtualWays.size());
            Main.main.undoRedo.add(new SequenceCommand(string, linkedList));
            this.selectPrims(Collections.singleton(this.virtualNode), false, false, false, false);
            this.virtualWays.clear();
            this.virtualNode = null;
        } else {
            Command command;
            Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelectedNodesAndWays();
            Collection<Node> collection2 = AllNodesVisitor.getAllNodes(collection);
            if (this.mode == Mode.rotate && collection2.size() < 2) {
                return;
            }
            Command command2 = command = !Main.main.undoRedo.commands.isEmpty() ? Main.main.undoRedo.commands.getLast() : null;
            if (command instanceof SequenceCommand) {
                command = ((SequenceCommand)command).getLastCommand();
            }
            if (this.mode == Mode.move) {
                if (command instanceof MoveCommand && ((Object)collection2).equals(((MoveCommand)command).getMovedNodes())) {
                    ((MoveCommand)command).moveAgain(d, d2);
                } else {
                    command = new MoveCommand(collection, d, d2);
                    Main.main.undoRedo.add(command);
                }
                for (Node node : collection2) {
                    if (!node.getCoor().isOutSideWorld()) continue;
                    ((MoveCommand)command).moveAgain(-d, -d2);
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot move objects outside of the world."), I18n.tr("Warning"), 2);
                    this.restoreCursor();
                    return;
                }
            } else if (this.mode == Mode.rotate) {
                if (command instanceof RotateCommand && ((Object)collection2).equals(((RotateCommand)command).getRotatedNodes())) {
                    ((RotateCommand)command).rotateAgain(eastNorth2, eastNorth);
                } else {
                    Main.main.undoRedo.add(new RotateCommand(collection, eastNorth2, eastNorth));
                }
            }
        }
        Main.map.mapView.repaint();
        this.mousePos = mouseEvent.getPoint();
        this.didMove = true;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (SelectAction.isPlatformOsx() && this.mode == Mode.rotate) {
            this.mouseDragged(mouseEvent);
        }
    }

    private Collection<OsmPrimitive> getNearestCollectionVirtual(Point point, boolean bl) {
        MapView mapView = Main.map.mapView;
        int n = Main.pref.getInteger("mappaint.node.virtual-snap-distance", 8);
        n *= n;
        OsmPrimitive osmPrimitive = mapView.getNearestNode(point);
        this.virtualWays.clear();
        this.virtualNode = null;
        Node node = null;
        if (osmPrimitive == null) {
            Collection<WaySegment> collection = bl ? mapView.getNearestWaySegments(point) : Collections.singleton(mapView.getNearestWaySegment(point));
            for (WaySegment waySegment : collection) {
                Point point2;
                Point point3;
                Way way;
                Point point4;
                if (waySegment == null) continue;
                osmPrimitive = waySegment.way;
                if (Main.pref.getInteger("mappaint.node.virtual-size", 8) <= 0 || !SimplePaintVisitor.isLargeSegment(point4 = mapView.getPoint((way = (Way)osmPrimitive).getNode(waySegment.lowerIndex)), point3 = mapView.getPoint(way.getNode(waySegment.lowerIndex + 1)), Main.pref.getInteger("mappaint.node.virtual-space", 70)).booleanValue() || !(point.distanceSq(point2 = new Point((point4.x + point3.x) / 2, (point4.y + point3.y) / 2)) < (double)n)) continue;
                if (node != null) {
                    if (!way.getNode(waySegment.lowerIndex + 1).equals(node) && !way.getNode(waySegment.lowerIndex).equals(node)) {
                        continue;
                    }
                } else {
                    node = way.getNode(waySegment.lowerIndex + 1);
                }
                this.virtualWays.add(waySegment);
                if (this.virtualNode != null) continue;
                this.virtualNode = new Node(Main.map.mapView.getLatLon(point2.x, point2.y));
            }
        }
        if (osmPrimitive == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(osmPrimitive);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl;
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        Main.map.mapView.requestFocus();
        this.cancelDrawMode = false;
        if (!((Boolean)this.getValue("active")).booleanValue()) {
            return;
        }
        if (mouseEvent.getButton() != 1) {
            return;
        }
        boolean bl2 = (mouseEvent.getModifiers() & 2) != 0;
        boolean bl3 = (mouseEvent.getModifiers() & 0x28) != 0;
        boolean bl4 = bl = (mouseEvent.getModifiers() & 1) != 0;
        if (bl || bl2) {
            this.cancelDrawMode = true;
        }
        this.mouseDownTime = System.currentTimeMillis();
        this.didMove = false;
        this.initialMoveThresholdExceeded = false;
        Collection<OsmPrimitive> collection = this.getNearestCollectionVirtual(mouseEvent.getPoint(), bl3);
        if (bl2 && bl) {
            if (this.getCurrentDataSet().getSelected().isEmpty()) {
                this.selectPrims(collection, true, false, false, false);
            }
            this.mode = Mode.rotate;
            this.setCursor(ImageProvider.getCursor("rotate", null));
        } else if (!collection.isEmpty()) {
            this.selectPrims(collection, bl || this.getCurrentDataSet().getSelected().containsAll(collection), bl2, false, false);
            this.mode = Mode.move;
        } else {
            this.mode = Mode.select;
            this.oldCursor = Main.map.mapView.getCursor();
            this.selectionManager.register(Main.map.mapView);
            this.selectionManager.mousePressed(mouseEvent);
        }
        if (this.mode != Mode.move || bl || bl2) {
            this.virtualNode = null;
            this.virtualWays.clear();
        }
        this.updateStatusLine();
        if (this.mode == Mode.rotate) {
            Main.map.mapView.repaint();
        }
        this.mousePos = mouseEvent.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (this.mode == Mode.select) {
            this.selectionManager.unregister(Main.map.mapView);
            if (this.getCurrentDataSet().getSelected().size() == 0 && !this.cancelDrawMode) {
                Main.map.selectDrawTool(true);
                return;
            }
        }
        this.restoreCursor();
        if (this.mode == Mode.move) {
            boolean bl;
            boolean bl2 = (mouseEvent.getModifiers() & 2) != 0;
            boolean bl3 = bl = (mouseEvent.getModifiers() & 1) != 0;
            if (!this.didMove) {
                this.selectPrims(Main.map.mapView.getNearestCollection(mouseEvent.getPoint()), bl, bl2, true, false);
                ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(this.getCurrentDataSet().getSelected());
                if (mouseEvent.getClickCount() >= 2 && arrayList.size() == 1 && arrayList.get(0) instanceof Node) {
                    Main.worker.execute(new Runnable(){

                        public void run() {
                            Main.map.selectDrawTool(true);
                        }
                    });
                    return;
                }
            } else {
                Object object;
                Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
                TreeSet<OsmPrimitive> treeSet = new TreeSet<OsmPrimitive>();
                int n = Main.pref.getInteger("warn.move.maxelements", 20);
                for (OsmPrimitive collection2 : collection) {
                    if (collection2 instanceof Node) {
                        treeSet.add(collection2);
                    } else if (collection2 instanceof Way) {
                        treeSet.add(collection2);
                        treeSet.addAll(((Way)collection2).getNodes());
                    }
                    if (treeSet.size() <= n) continue;
                    object = new ExtendedDialog(Main.parent, I18n.tr("Move elements"), new String[]{I18n.tr("Move them"), I18n.tr("Undo move")});
                    ((ExtendedDialog)object).setButtonIcons(new String[]{"reorder.png", "cancel.png"});
                    ((ExtendedDialog)object).setContent(I18n.tr("You moved more than {0} elements. Moving a large number of elements is often an error.\nReally move them?", n));
                    ((ExtendedDialog)object).toggleEnable("movedManyElements");
                    ((ExtendedDialog)object).setToggleCheckboxText(I18n.tr("Always move and don't show dialog again"));
                    ((ExtendedDialog)object).showDialog();
                    if (((ExtendedDialog)object).getValue() == 1 || ((ExtendedDialog)object).getValue() == -99) break;
                    Main.main.undoRedo.undo();
                    break;
                }
                if (bl2) {
                    Collection<Node> collection3 = AllNodesVisitor.getAllNodes(collection);
                    Collection<Node> collection2 = Main.map.mapView.getNearestNodes(mouseEvent.getPoint(), collection3);
                    if (collection2 != null) {
                        object = collection2.iterator().next();
                        Set<Node> set = OsmPrimitive.getFilteredSet(collection, Node.class);
                        if (!set.isEmpty()) {
                            set.add((Node)object);
                            Node node = MergeNodesAction.selectTargetNode(set);
                            Command command = MergeNodesAction.mergeNodes(Main.main.getEditLayer(), set, node);
                            Main.main.undoRedo.add(command);
                        }
                    }
                }
                DataSet.fireSelectionChanged(collection);
            }
        }
        this.mode = null;
        this.updateStatusLine();
    }

    @Override
    public void selectionEnded(Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        this.selectPrims(this.selectionManager.getObjectsInRectangle(rectangle, bl), bl2, bl3, true, true);
    }

    public void selectPrims(Collection<OsmPrimitive> collection, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl && bl2 || bl2 && !bl3) {
            return;
        }
        Collection<OsmPrimitive> collection2 = !bl2 && !bl ? new LinkedList<OsmPrimitive>() : this.getCurrentDataSet().getSelected();
        for (OsmPrimitive osmPrimitive : collection) {
            if (bl2) {
                if (collection2.contains(osmPrimitive)) {
                    collection2.remove(osmPrimitive);
                    continue;
                }
                if (bl4) continue;
                collection2.add(osmPrimitive);
                continue;
            }
            collection2.add(osmPrimitive);
        }
        this.getCurrentDataSet().setSelected(collection2);
        Main.map.mapView.repaint();
    }

    @Override
    public String getModeHelpText() {
        if (this.mode == Mode.select) {
            return I18n.tr("Release the mouse button to select the objects in the rectangle.");
        }
        if (this.mode == Mode.move) {
            return I18n.tr("Release the mouse button to stop moving. Ctrl to merge with nearest node.");
        }
        if (this.mode == Mode.rotate) {
            return I18n.tr("Release the mouse button to stop rotating.");
        }
        return I18n.tr("Move objects by dragging; Shift to add to selection (Ctrl to toggle); Shift-Ctrl to rotate selected; or change selection");
    }

    @Override
    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        move,
        rotate,
        select;

    }
}

