/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class OpenFileAction
extends DiskAccessAction {
    public OpenFileAction() {
        super(I18n.tr("Open..."), "open", I18n.tr("Open a file."), Shortcut.registerShortcut("system:open", I18n.tr("File: {0}", I18n.tr("Open...")), 79, 2));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = OpenFileAction.createAndOpenFileChooser(true, true, null);
        if (jFileChooser == null) {
            return;
        }
        File[] fileArray = jFileChooser.getSelectedFiles();
        OpenFileTask openFileTask = new OpenFileTask(Arrays.asList(fileArray));
        Main.worker.submit(openFileTask);
    }

    protected void updateEnabledState() {
        this.setEnabled(!Main.applet);
    }

    public static void openFile(File file) throws IOException, IllegalDataException {
        for (FileImporter fileImporter : ExtensionFileFilter.importers) {
            if (!fileImporter.acceptFile(file)) continue;
            fileImporter.importData(file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OpenFileTask
    extends PleaseWaitRunnable {
        private List<File> files;
        private boolean cancelled;

        public OpenFileTask(List<File> list) {
            super(I18n.tr("Opening files"), false);
            this.files = list;
        }

        @Override
        protected void cancel() {
            this.cancelled = true;
        }

        @Override
        protected void finish() {
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            if (this.files == null || this.files.isEmpty()) {
                return;
            }
            this.getProgressMonitor().setTicks(this.files.size());
            for (File file : this.files) {
                if (this.cancelled) {
                    return;
                }
                this.getProgressMonitor().subTask(I18n.tr("Opening file ''{0}'' ...", file.getAbsolutePath()));
                try {
                    System.out.println("Open file: " + file.getAbsolutePath() + " (" + file.length() + " bytes)");
                    OpenFileAction.openFile(file);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Could not read file ''{0}''.<br> Error is: <br>{1}</html>", file.getName(), exception.getMessage()), I18n.tr("Error"), 0);
                }
                this.getProgressMonitor().worked(1);
            }
        }
    }
}

