/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class MirrorAction
extends JosmAction {
    public MirrorAction() {
        super(I18n.tr("Mirror"), "mirror", I18n.tr("Mirror selected nodes and ways."), Shortcut.registerShortcut("tools:mirror", I18n.tr("Tool: {0}", I18n.tr("Mirror")), 77, 3, 1), true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        HashSet<Node> hashSet = new HashSet<Node>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive instanceof Node) {
                hashSet.add((Node)osmPrimitive);
                continue;
            }
            if (!(osmPrimitive instanceof Way)) continue;
            hashSet.addAll(((Way)osmPrimitive).getNodes());
        }
        if (hashSet.size() == 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one node or way."), I18n.tr("Information"), 1);
            return;
        }
        double d = 2.0E10;
        double d2 = -2.0E10;
        for (Node node : hashSet) {
            double d3 = node.getEastNorth().east();
            d = Math.min(d, d3);
            d2 = Math.max(d2, d3);
        }
        double d4 = (d + d2) / 2.0;
        LinkedList<Command> linkedList = new LinkedList<Command>();
        for (Node node : hashSet) {
            linkedList.add(new MoveCommand(node, 2.0 * (d4 - node.getEastNorth().east()), 0.0));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Mirror"), linkedList));
        Main.map.repaint();
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getCurrentDataSet() != null && !this.getCurrentDataSet().getSelected().isEmpty());
    }
}

