/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import org.openstreetmap.josm.actions.AbstractMergeAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.visitor.MergeSourceBuildingVisitor;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MergeSelectionAction
extends AbstractMergeAction {
    public MergeSelectionAction() {
        super(I18n.tr("Merge selection"), "dialogs/mergedown", I18n.tr("Merge the currently selected primitives into another layer"), Shortcut.registerShortcut("system:mergeselection", I18n.tr("Edit: {0}", I18n.tr("Merge selection")), 77, 2, 1), true);
    }

    public void mergeSelected(DataSet dataSet) {
        List<Layer> list = LayerListDialog.getInstance().getModel().getPossibleMergeTargets(this.getEditLayer());
        if (list.isEmpty()) {
            this.warnNoTargetLayersForSourceLayer(this.getEditLayer());
            return;
        }
        Layer layer = this.askTargetLayer(list);
        if (layer == null) {
            return;
        }
        MergeSourceBuildingVisitor mergeSourceBuildingVisitor = new MergeSourceBuildingVisitor(this.getEditLayer().data);
        ((OsmDataLayer)layer).mergeFrom(mergeSourceBuildingVisitor.build());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getEditLayer() == null || this.getEditLayer().data.getSelected().isEmpty()) {
            return;
        }
        this.mergeSelected(this.getEditLayer().data);
    }

    protected void updateEnabledState() {
        if (this.getEditLayer() == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!this.getEditLayer().data.getSelected().isEmpty());
    }
}

