/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinNodeWayAction
extends JosmAction {
    public JoinNodeWayAction() {
        super(I18n.tr("Join Node to Way"), "joinnodeway", I18n.tr("Join a node into the nearest way segments"), Shortcut.registerShortcut("tools:joinnodeway", I18n.tr("Tool: {0}", I18n.tr("Join Node to Way")), 74, 3), true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        if (collection.size() != 1 || !(collection.iterator().next() instanceof Node)) {
            return;
        }
        Node node = (Node)collection.iterator().next();
        List<WaySegment> list = Main.map.mapView.getNearestWaySegments(Main.map.mapView.getPoint(node));
        HashMap hashMap = new HashMap();
        for (WaySegment object : list) {
            void var8_9;
            if (hashMap.containsKey(object.way)) {
                List list2 = (List)hashMap.get(object.way);
            } else {
                ArrayList arrayList = new ArrayList();
                hashMap.put(object.way, arrayList);
            }
            if (object.way.getNode(object.lowerIndex) == node || object.way.getNode(object.lowerIndex + 1) == node) continue;
            var8_9.add(object.lowerIndex);
        }
        LinkedList linkedList = new LinkedList();
        for (Map.Entry entry : hashMap.entrySet()) {
            Way way = (Way)entry.getKey();
            List<Node> list3 = way.getNodes();
            List list4 = (List)entry.getValue();
            JoinNodeWayAction.pruneSuccsAndReverse(list4);
            Object object = list4.iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                list3.add(n + 1, node);
            }
            object = new Way(way);
            ((Way)object).setNodes(list3);
            linkedList.add(new ChangeCommand(way, (OsmPrimitive)object));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Join Node and Line"), linkedList));
        Main.map.repaint();
    }

    private static void pruneSuccsAndReverse(List<Integer> list) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int n : list) {
            if (hashSet.contains(n - 1) || hashSet.contains(n + 1)) continue;
            hashSet.add(n);
        }
        list.clear();
        list.addAll(hashSet);
        Collections.sort(list);
        Collections.reverse(list);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getCurrentDataSet() != null && !this.getCurrentDataSet().getSelected().isEmpty());
    }
}

