/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class HelpAction
extends AbstractAction {
    private HelpBrowser helpBrowser;
    private String pathhelp = Main.pref.get("help.pathhelp", "Help/");
    private String pathmenu = Main.pref.get("help.pathmenu", "Menu/");

    public HelpAction() {
        super(I18n.tr("Help"), ImageProvider.get("help"));
        this.helpBrowser = new HelpBrowser();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == null) {
            String string = null;
            if (actionEvent.getSource() instanceof Component) {
                Component component = SwingUtilities.getRoot((Component)actionEvent.getSource());
                Point point = component.getMousePosition();
                component = SwingUtilities.getDeepestComponentAt(component, point.x, point.y);
                string = this.contextSensitiveHelp(component);
            } else {
                Point point = Main.parent.getMousePosition();
                string = this.contextSensitiveHelp(SwingUtilities.getDeepestComponentAt(Main.parent, point.x, point.y));
            }
            if (string == null) {
                this.helpBrowser.setVisible(false);
                this.helpBrowser.setUrlForHelpTopic("Help");
            } else {
                this.help(string);
            }
        } else {
            this.helpBrowser.setVisible(false);
            this.helpBrowser.setUrlForHelpTopic("Help");
        }
    }

    private String contextSensitiveHelp(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Helpful) {
            return ((Helpful)object).helpTopic();
        }
        if (object instanceof JMenu) {
            JMenu jMenu = (JMenu)object;
            if (jMenu.getClientProperty("help") != null) {
                return (String)jMenu.getClientProperty("help");
            }
            return this.pathmenu + jMenu.getText();
        }
        if (object instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)object;
            if (abstractButton.getClientProperty("help") != null) {
                return (String)abstractButton.getClientProperty("help");
            }
            return this.contextSensitiveHelp(((AbstractButton)object).getAction());
        }
        if (object instanceof Action) {
            return (String)((Action)object).getValue("help");
        }
        if (object instanceof JComponent && ((JComponent)object).getClientProperty("help") != null) {
            return (String)((JComponent)object).getClientProperty("help");
        }
        if (object instanceof Component) {
            return this.contextSensitiveHelp(((Component)object).getParent());
        }
        return null;
    }

    public void help(String string) {
        this.helpBrowser.setVisible(false);
        this.helpBrowser.setUrlForHelpTopic(this.pathhelp + string);
    }
}

