/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class AlignInLineAction
extends JosmAction {
    public AlignInLineAction() {
        super(I18n.tr("Align Nodes in Line"), "alignline", I18n.tr("Move the selected nodes in to a line."), Shortcut.registerShortcut("tools:alignline", I18n.tr("Tool: {0}", I18n.tr("Align Nodes in Line")), 76, 3), true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        double d;
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        LinkedList<Node> linkedList2 = new LinkedList<Node>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Node)) continue;
            linkedList.add((Node)osmPrimitive);
            linkedList2.add((Node)osmPrimitive);
        }
        if (linkedList.size() == 0 && collection.size() == 1) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (!(osmPrimitive instanceof Way)) continue;
                linkedList.addAll(((Way)osmPrimitive).getNodes());
                linkedList2.addAll(((Way)osmPrimitive).getNodes());
            }
        }
        if (linkedList.size() < 3) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least three nodes."), I18n.tr("Information"), 1);
            return;
        }
        double d2 = 0.0;
        Node node = null;
        Node node2 = null;
        for (Node node3 : linkedList) {
            linkedList2.remove(node3);
            for (Node node4 : linkedList2) {
                d = Math.sqrt(node3.getEastNorth().distance(node4.getEastNorth()));
                if (!(d > d2)) continue;
                node = node3;
                node2 = node4;
                d2 = d;
            }
        }
        linkedList.remove(node);
        linkedList.remove(node2);
        double d3 = node.getEastNorth().east();
        double d4 = node.getEastNorth().north();
        d = node2.getEastNorth().east();
        double d5 = node2.getEastNorth().north();
        LinkedList<Command> linkedList3 = new LinkedList<Command>();
        for (Node node5 : linkedList) {
            double d6 = node5.getEastNorth().east();
            double d7 = node5.getEastNorth().north();
            if (d3 == d) {
                d6 = d3;
            } else if (d4 == d5) {
                d7 = d4;
            } else {
                double d8 = (d5 - d4) / (d - d3);
                double d9 = d4 - d3 * d8;
                double d10 = -1.0 / d8;
                double d11 = node5.getEastNorth().north() - node5.getEastNorth().east() * d10;
                d6 = (d11 - d9) / (d8 - d10);
                d7 = d8 * d6 + d9;
            }
            linkedList3.add(new MoveCommand(node5, d6 - node5.getEastNorth().east(), d7 - node5.getEastNorth().north()));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Align Nodes in Line"), linkedList3));
        Main.map.repaint();
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getCurrentDataSet() != null && !this.getCurrentDataSet().getSelected().isEmpty());
    }
}

