/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AboutAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.plugins.PluginDownloader;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginPreferenceFactory;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginHandler {
    public static final Collection<PluginProxy> pluginList = new LinkedList<PluginProxy>();

    public static void loadPlugins(boolean bl) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Collection<String> collection = Main.pref.getCollection("plugins", null);
        if (collection != null) {
            linkedList.addAll(collection);
        }
        if (System.getProperty("josm.plugins") != null) {
            linkedList.addAll(Arrays.asList(System.getProperty("josm.plugins").split(",")));
        }
        String[] stringArray = new String[]{"mappaint", "unglueplugin", "lang-de", "lang-en_GB", "lang-fr", "lang-it", "lang-pl", "lang-ro", "lang-ru", "ewmsplugin", "ywms", "tways-0.2", "geotagged", "landsat", "namefinder", "waypoints", "slippy_map_chooser", "tcx-support"};
        for (String object : stringArray) {
            if (!linkedList.contains(object)) continue;
            linkedList.remove(object);
            Main.pref.removeFromCollection("plugins", object);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Warning - loading of {0} plugin was requested. This plugin is no longer required.", object));
        }
        if (linkedList.isEmpty()) {
            return;
        }
        TreeMap treeMap = new TreeMap();
        for (String string : linkedList) {
            PluginInformation collection2 = PluginInformation.findPlugin(string);
            if (collection2 != null) {
                if (collection2.early != bl) continue;
                if (collection2.mainversion > AboutAction.getVersionNumber()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Plugin {0} requires JOSM update to version {1}.", string, collection2.mainversion));
                    continue;
                }
                if (collection2.requires != null) {
                    Object object = null;
                    for (String string2 : collection2.requires.split(";")) {
                        if (linkedList.contains(string2)) continue;
                        object = string2;
                        break;
                    }
                    if (object != null) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Plugin {0} is required by plugin {1} but was not found.", object, string));
                        continue;
                    }
                }
                if (!treeMap.containsKey(collection2.stage)) {
                    treeMap.put(collection2.stage, new LinkedList());
                }
                ((Collection)treeMap.get(collection2.stage)).add(collection2);
                continue;
            }
            if (!bl) continue;
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Plugin not found: {0}.", string));
        }
        if (!bl) {
            long l = System.currentTimeMillis();
            long uRLClassLoader = Main.pref.getLong("pluginmanager.lastupdate", 0L);
            Object object = Integer.valueOf(Main.pref.getInteger("pluginmanager.warntime", 30));
            long l2 = (l - uRLClassLoader) / 86400000L;
            if (uRLClassLoader <= 0L || (Integer)object <= 0) {
                Main.pref.put("pluginmanager.lastupdate", Long.toString(l));
            } else if (l2 > (long)((Integer)object).intValue()) {
                JOptionPane.showMessageDialog(Main.parent, "<html>" + I18n.tr("Last plugin update more than {0} days ago.", l2) + "<br><em>" + I18n.tr("(You can change the number of days after which this warning appears<br>by setting the config option 'pluginmanager.warntime'.)") + "</html>");
            }
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (Collection collection2 : treeMap.values()) {
            for (Object object : collection2) {
                arrayList.addAll(((PluginInformation)object).libraries);
            }
        }
        URL[] uRLArray = new URL[arrayList.size()];
        uRLArray = arrayList.toArray(uRLArray);
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, Main.class.getClassLoader());
        ImageProvider.sources.add(0, uRLClassLoader);
        for (Object object : treeMap.values()) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                PluginInformation pluginInformation = (PluginInformation)iterator.next();
                try {
                    Class<?> clazz = pluginInformation.loadClass(uRLClassLoader);
                    if (clazz == null) continue;
                    System.out.println("loading " + pluginInformation.name);
                    pluginList.add(pluginInformation.load(clazz));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    int n = new ExtendedDialog(Main.parent, I18n.tr("Disable plugin"), I18n.tr("Could not load plugin {0}. Delete from preferences?", pluginInformation.name), new String[]{I18n.tr("Disable plugin"), I18n.tr("Keep plugin")}, new String[]{"dialogs/delete.png", "cancel.png"}).getValue();
                    if (n != 1) continue;
                    linkedList.remove(pluginInformation.name);
                    Main.pref.removeFromCollection("plugins", pluginInformation.name);
                }
            }
        }
    }

    public static void setMapFrame(MapFrame mapFrame, MapFrame mapFrame2) {
        for (PluginProxy pluginProxy : pluginList) {
            pluginProxy.mapFrameInitialized(mapFrame, mapFrame2);
        }
    }

    public static Object getPlugin(String string) {
        for (PluginProxy pluginProxy : pluginList) {
            if (!pluginProxy.info.name.equals(string)) continue;
            return pluginProxy.plugin;
        }
        return null;
    }

    public static void addDownloadSelection(List<DownloadSelection> list) {
        for (PluginProxy pluginProxy : pluginList) {
            pluginProxy.addDownloadSelection(list);
        }
    }

    public static void getPreferenceSetting(Collection<PreferenceSettingFactory> collection) {
        for (PluginProxy pluginProxy : pluginList) {
            collection.add(new PluginPreferenceFactory(pluginProxy));
        }
    }

    public static void earlyCleanup() {
        if (!PluginDownloader.moveUpdatedPlugins()) {
            JOptionPane.showMessageDialog(null, I18n.tr("Activating the updated plugins failed. Check if JOSM has the permission to overwrite the existing ones."), I18n.tr("Plugins"), 0);
        }
    }

    public static Boolean checkException(Throwable throwable) {
        int n;
        PluginProxy pluginProxy = null;
        if (throwable instanceof PluginException) {
            pluginProxy = ((PluginException)throwable).plugin;
        }
        if (pluginProxy == null) {
            String string = null;
            for (StackTraceElement object : throwable.getStackTrace()) {
                String string2;
                String string3 = object.getClassName();
                if (string3.contains("wmsplugin.") || string3.contains(".WMSLayer")) {
                    string = "wmsplugin";
                }
                if (string3.contains("livegps.")) {
                    string = "livegps";
                }
                if (string3.startsWith("UtilsPlugin.")) {
                    string = "UtilsPlugin";
                }
                if (string3.startsWith("org.openstreetmap.josm.plugins.") && (string2 = string3.substring("org.openstreetmap.josm.plugins.".length())).indexOf(46) != -1 && string2.matches("[a-z].*")) {
                    string = string2.substring(0, string2.indexOf(46));
                }
                if (string != null) break;
            }
            for (PluginProxy pluginProxy2 : pluginList) {
                if (!pluginProxy2.info.name.equals(string)) continue;
                pluginProxy = pluginProxy2;
                break;
            }
        }
        if (pluginProxy != null && (n = new ExtendedDialog(Main.parent, I18n.tr("Disable plugin"), I18n.tr("An unexpected exception occurred that may have come from the ''{0}'' plugin.", pluginProxy.info.name) + "\n" + (pluginProxy.info.author != null ? I18n.tr("According to the information within the plugin, the author is {0}.", pluginProxy.info.author) : "") + "\n" + I18n.tr("Try updating to the newest version of this plugin before reporting a bug.") + "\n" + I18n.tr("Should the plugin be disabled?"), new String[]{I18n.tr("Disable plugin"), I18n.tr("Cancel")}, new String[]{"dialogs/delete.png", "cancel.png"}).getValue()) == 1) {
            LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(Main.pref.get("plugins").split(",")));
            if (linkedList.contains(pluginProxy.info.name)) {
                while (linkedList.remove(pluginProxy.info.name)) {
                }
                String string = "";
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    string = string + "," + string4;
                }
                if (string.length() > 0) {
                    string = string.substring(1);
                }
                Main.pref.put("plugins", string);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The plugin has been removed from the configuration. Please restart JOSM to unload the plugin."));
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The plugin could not be removed. Please tell the people you got JOSM from about the problem."));
            }
            return true;
        }
        return false;
    }

    public static String getBugReportText() {
        String string = "";
        String string2 = Main.pref.get("plugins");
        if (string2 != null && string2.length() != 0) {
            string = string + "Plugins: " + string2 + "\n";
        }
        for (PluginProxy pluginProxy : pluginList) {
            string = string + "Plugin " + pluginProxy.info.name + (pluginProxy.info.version != null && !pluginProxy.info.version.equals("") ? " Version: " + pluginProxy.info.version + "\n" : "\n");
        }
        return string;
    }

    public static JPanel getInfoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        for (final PluginProxy pluginProxy : pluginList) {
            String string = pluginProxy.info.name + (pluginProxy.info.version != null && !pluginProxy.info.version.equals("") ? " Version: " + pluginProxy.info.version : "");
            jPanel.add((Component)new JLabel(string), GBC.std());
            jPanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
            jPanel.add((Component)new JButton(new AbstractAction(I18n.tr("Information")){

                public void actionPerformed(ActionEvent actionEvent) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Map.Entry<String, String> entry : pluginProxy.info.attr.entrySet()) {
                        stringBuilder.append(entry.getKey());
                        stringBuilder.append(": ");
                        stringBuilder.append(entry.getValue());
                        stringBuilder.append("\n");
                    }
                    JTextArea jTextArea = new JTextArea(10, 40);
                    jTextArea.setEditable(false);
                    jTextArea.setText(stringBuilder.toString());
                    JOptionPane.showMessageDialog(Main.parent, new JScrollPane(jTextArea));
                }
            }), GBC.eol());
            JTextArea jTextArea = new JTextArea(pluginProxy.info.description == null ? I18n.tr("no description available") : pluginProxy.info.description);
            jTextArea.setEditable(false);
            jTextArea.setFont(new JLabel().getFont().deriveFont(2));
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            jTextArea.setBackground(UIManager.getColor("Panel.background"));
            jPanel.add((Component)jTextArea, GBC.eop().fill(2));
        }
        return jPanel;
    }
}

