/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.io.OsmHistoryReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class OsmServerHistoryReader
extends OsmServerReader {
    private OsmPrimitiveType primitiveType;
    private long id;

    public OsmServerHistoryReader(OsmPrimitiveType osmPrimitiveType, long l) throws IllegalArgumentException {
        if (osmPrimitiveType == null) {
            throw new IllegalArgumentException(I18n.tr("parameter ''{0}'' must not be null", "type"));
        }
        if (l < 0L) {
            throw new IllegalArgumentException(I18n.tr("parameter ''{0}'' >= 0 expected, got ''{1}''", "id", l));
        }
        this.primitiveType = osmPrimitiveType;
        this.id = l;
    }

    public DataSet parseOsm() throws OsmTransferException {
        throw new NotImplementedException();
    }

    public HistoryDataSet parseHistory() throws OsmTransferException {
        InputStream inputStream = null;
        try {
            HistoryDataSet historyDataSet;
            Main.pleaseWaitDlg.progress.setValue(0);
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Contacting OSM Server..."));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.primitiveType.getAPIName()).append("/").append(this.id).append("/history");
            inputStream = this.getInputStream(stringBuffer.toString(), Main.pleaseWaitDlg);
            if (inputStream == null) {
                HistoryDataSet historyDataSet2 = null;
                return historyDataSet2;
            }
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Downloading history..."));
            OsmHistoryReader osmHistoryReader = new OsmHistoryReader(inputStream);
            HistoryDataSet historyDataSet3 = historyDataSet = osmHistoryReader.parse(Main.pleaseWaitDlg);
            return historyDataSet3;
        }
        catch (IOException iOException) {
            if (this.cancel) {
                HistoryDataSet historyDataSet = null;
                return historyDataSet;
            }
            throw new OsmTransferException(iOException);
        }
        catch (SAXException sAXException) {
            throw new OsmTransferException(sAXException);
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            if (this.cancel) {
                HistoryDataSet historyDataSet = null;
                return historyDataSet;
            }
            throw new OsmTransferException(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                this.activeConnection = null;
            }
        }
    }
}

