/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.visitor.CreateOsmChangeVisitor;
import org.openstreetmap.josm.io.Capabilities;
import org.openstreetmap.josm.io.DiffResultReader;
import org.openstreetmap.josm.io.MyHttpHandler;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferCancelledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmApi
extends OsmConnection {
    public static final int DEFAULT_MAX_NUM_RETRIES = 5;
    private static HashMap<String, OsmApi> instances = new HashMap();
    private String serverUrl;
    private Changeset changeset;
    private String version = null;
    private Capabilities capabilities = new Capabilities();
    private boolean initialized = false;
    private StringWriter swriter = new StringWriter();
    private OsmWriter osmWriter = new OsmWriter(new PrintWriter(this.swriter), true, null);

    public static OsmApi getOsmApi(String string) {
        OsmApi osmApi = instances.get(string);
        if (osmApi == null) {
            osmApi = new OsmApi(string);
            instances.put(string, osmApi);
        }
        return osmApi;
    }

    public static OsmApi getOsmApi() {
        String string = Main.pref.get("osm-server.url", "http://api.openstreetmap.org/api");
        if (string == null) {
            throw new IllegalStateException(I18n.tr("preference ''{0}'' missing. Can't initialize OsmApi", "osm-server.url"));
        }
        return OsmApi.getOsmApi(string);
    }

    protected OsmApi(String string) {
        if (string == null) {
            throw new IllegalArgumentException(I18n.tr("parameter '{0}' must not be null", "serverUrl"));
        }
        this.serverUrl = string;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasChangesetSupport() {
        return this.version != null && this.version.compareTo("0.6") >= 0;
    }

    public void initialize() throws OsmApiInitializationException {
        if (this.initialized) {
            return;
        }
        this.initAuthentication();
        try {
            String string = this.sendRequest("GET", "capabilities", null);
            InputSource inputSource = new InputSource(new StringReader(string));
            SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)new CapabilitiesParser());
            if (this.capabilities.supportsVersion("0.6")) {
                this.version = "0.6";
            } else if (this.capabilities.supportsVersion("0.5")) {
                this.version = "0.5";
            } else {
                System.err.println(I18n.tr("This version of JOSM is incompatible with the configured server."));
                System.err.println(I18n.tr("It supports protocol versions 0.5 and 0.6, while the server says it supports {0} to {1}.", this.capabilities.get("version", "minimum"), this.capabilities.get("version", "maximum")));
                this.initialized = false;
            }
            System.out.println(I18n.tr("Communications with {0} established using protocol version {1}", this.serverUrl, this.version));
            this.osmWriter.setVersion(this.version);
            this.initialized = true;
        }
        catch (Exception exception) {
            this.initialized = false;
            throw new OsmApiInitializationException(exception);
        }
    }

    private String toXml(OsmPrimitive osmPrimitive, boolean bl) {
        this.swriter.getBuffer().setLength(0);
        this.osmWriter.setWithBody(bl);
        this.osmWriter.setChangeset(this.changeset);
        this.osmWriter.header();
        osmPrimitive.visit(this.osmWriter);
        this.osmWriter.footer();
        this.osmWriter.out.flush();
        return this.swriter.toString();
    }

    public String getBaseUrl() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(this.serverUrl);
        if (this.version != null) {
            stringBuffer.append("/");
            stringBuffer.append(this.version);
        }
        stringBuffer.append("/");
        while ((n = stringBuffer.indexOf("//", 6)) > -1) {
            stringBuffer.delete(n, n + 1);
        }
        return stringBuffer.toString();
    }

    public void createPrimitive(OsmPrimitive osmPrimitive) throws OsmTransferException {
        this.initialize();
        String string = "";
        try {
            string = this.sendRequest("PUT", OsmPrimitiveType.from(osmPrimitive).getAPIName() + "/create", this.toXml(osmPrimitive, true));
            osmPrimitive.id = Long.parseLong(string.trim());
            osmPrimitive.version = 1;
        }
        catch (NumberFormatException numberFormatException) {
            throw new OsmTransferException(I18n.tr("unexpected format of id replied by the server, got ''{0}''", string));
        }
    }

    public void modifyPrimitive(OsmPrimitive osmPrimitive) throws OsmTransferException {
        this.initialize();
        if (this.version.equals("0.5")) {
            this.sendRequest("PUT", OsmPrimitiveType.from(osmPrimitive).getAPIName() + "/" + osmPrimitive.id, this.toXml(osmPrimitive, true));
        } else {
            String string = null;
            try {
                string = this.sendRequest("PUT", OsmPrimitiveType.from(osmPrimitive).getAPIName() + "/" + osmPrimitive.id, this.toXml(osmPrimitive, true));
                osmPrimitive.version = Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new OsmTransferException(I18n.tr("unexpected format of new version of modified primitive ''{0}'', got ''{1}''", osmPrimitive.id, string));
            }
        }
    }

    public void deletePrimitive(OsmPrimitive osmPrimitive) throws OsmTransferException {
        this.initialize();
        this.sendRequest("DELETE", OsmPrimitiveType.from(osmPrimitive).getAPIName() + "/" + osmPrimitive.id, this.version.equals("0.5") ? null : this.toXml(osmPrimitive, false));
    }

    public void createChangeset(String string) throws OsmTransferException {
        this.changeset = new Changeset();
        this.notifyStatusMessage(I18n.tr("Opening changeset..."));
        Properties properties = System.getProperties();
        Object object = properties.get("http.agent");
        this.changeset.put("created_by", object == null ? "JOSM" : object.toString());
        this.changeset.put("comment", string);
        this.createPrimitive(this.changeset);
    }

    public void stopChangeset() throws OsmTransferException {
        this.initialize();
        this.notifyStatusMessage(I18n.tr("Closing changeset..."));
        this.sendRequest("PUT", "changeset/" + this.changeset.id + "/close", null);
        this.changeset = null;
    }

    public Collection<OsmPrimitive> uploadDiff(Collection<OsmPrimitive> collection) throws OsmTransferException {
        if (this.changeset == null) {
            throw new OsmTransferException(I18n.tr("No changeset present for diff upload"));
        }
        this.initialize();
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        CreateOsmChangeVisitor createOsmChangeVisitor = new CreateOsmChangeVisitor(this.changeset, this);
        this.notifyStatusMessage(I18n.tr("Preparing..."));
        for (OsmPrimitive object : collection) {
            object.visit(createOsmChangeVisitor);
            this.notifyRelativeProgress(1);
        }
        this.notifyStatusMessage(I18n.tr("Uploading..."));
        this.setAutoProgressIndication(true);
        String string = createOsmChangeVisitor.getDocument();
        try {
            String osmTransferException = this.sendRequest("POST", "changeset/" + this.changeset.id + "/upload", string);
            DiffResultReader.parseDiffResult(osmTransferException, collection, arrayList, createOsmChangeVisitor.getNewIdMap(), Main.pleaseWaitDlg);
        }
        catch (OsmTransferException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new OsmTransferException(exception);
        }
        finally {
            this.setAutoProgressIndication(false);
        }
        return arrayList;
    }

    private void sleepAndListen() throws OsmTransferCancelledException {
        for (int i = 0; i < 10; ++i) {
            if (this.cancel || this.isAuthCancelled()) {
                throw new OsmTransferCancelledException();
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private String sendRequest(String string, String string2, String string3) throws OsmTransferException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = Main.pref.getInteger("osm-server.max-num-retries", 5);
        n = Math.max(0, n);
        while (true) {
            try {
                String string4;
                void var8_17;
                int n2;
                while (true) {
                    URL uRL = new URL(new URL(this.getBaseUrl()), string2, new MyHttpHandler());
                    System.out.print(string + " " + uRL + "... ");
                    this.activeConnection = (HttpURLConnection)uRL.openConnection();
                    this.activeConnection.setConnectTimeout(15000);
                    this.activeConnection.setRequestMethod(string);
                    this.addAuth(this.activeConnection);
                    if (string.equals("PUT") || string.equals("POST") || string.equals("DELETE")) {
                        this.activeConnection.setDoOutput(true);
                        this.activeConnection.setRequestProperty("Content-type", "text/xml");
                        OutputStream outputStream = this.activeConnection.getOutputStream();
                        if (string3 != null) {
                            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                            bufferedWriter.write(string3);
                            bufferedWriter.flush();
                        }
                        outputStream.close();
                    }
                    this.activeConnection.connect();
                    System.out.println(this.activeConnection.getResponseMessage());
                    n2 = this.activeConnection.getResponseCode();
                    if (n2 < 500 || n-- <= 0) break;
                    this.sleepAndListen();
                }
                stringBuffer.setLength(0);
                Object var8_14 = null;
                try {
                    InputStream inputStream = this.activeConnection.getInputStream();
                }
                catch (IOException iOException) {
                    InputStream inputStream = this.activeConnection.getErrorStream();
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)var8_17));
                while ((string4 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string4);
                    stringBuffer.append("\n");
                }
                String string5 = null;
                if (this.activeConnection.getHeaderField("Error") != null) {
                    string5 = this.activeConnection.getHeaderField("Error");
                    System.err.println("Error header: " + string5);
                } else if (n2 != 200 && stringBuffer.length() > 0) {
                    System.err.println("Error body: " + stringBuffer);
                }
                this.activeConnection.disconnect();
                if (n2 == 200) return stringBuffer.toString();
                throw new OsmApiException(n2, string5.trim(), stringBuffer.toString().trim());
            }
            catch (UnknownHostException unknownHostException) {
                throw new OsmTransferException(unknownHostException);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (n-- <= 0) throw new OsmTransferException(socketTimeoutException);
                continue;
            }
            catch (ConnectException connectException) {
                if (n-- <= 0) throw new OsmTransferException(connectException);
                continue;
            }
            catch (Exception exception) {
                if (!(exception instanceof OsmTransferException)) throw new OsmTransferException(exception);
                throw (OsmTransferException)exception;
            }
            break;
        }
    }

    protected void notifyStatusMessage(String string) {
        Main.pleaseWaitDlg.currentAction.setText(string);
    }

    protected void notifyRelativeProgress(int n) {
        int n2 = Main.pleaseWaitDlg.progress.getValue();
        Main.pleaseWaitDlg.progress.setValue(n2 + n);
    }

    protected void setAutoProgressIndication(final boolean bl) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Main.pleaseWaitDlg.setIndeterminate(bl);
            }
        });
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    private class CapabilitiesParser
    extends DefaultHandler {
        private CapabilitiesParser() {
        }

        public void startDocument() throws SAXException {
            OsmApi.this.capabilities.clear();
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            for (int i = 0; i < string3.length(); ++i) {
                OsmApi.this.capabilities.put(string3, attributes.getQName(i), attributes.getValue(i));
            }
        }
    }
}

