/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.openstreetmap.josm.Main;

public class MirroredInputStream
extends InputStream {
    InputStream fs = null;
    File file = null;

    public MirroredInputStream(String string) throws IOException {
        this(string, null, -1L);
    }

    public MirroredInputStream(String string, long l) throws IOException {
        this(string, null, l);
    }

    public MirroredInputStream(String string, String string2) throws IOException {
        this(string, string2, -1L);
    }

    public MirroredInputStream(String string, String string2, long l) throws IOException {
        try {
            URL uRL = new URL(string);
            if (uRL.getProtocol().equals("file")) {
                this.file = new File(string.substring("file:/".length()));
                if (!this.file.exists()) {
                    this.file = new File(string.substring("file://".length()));
                }
            } else {
                this.file = this.checkLocal(uRL, string2, l);
            }
        }
        catch (MalformedURLException malformedURLException) {
            if (string.startsWith("resource://")) {
                this.fs = this.getClass().getResourceAsStream(string.substring("resource:/".length()));
                return;
            }
            this.file = new File(string);
        }
        if (this.file == null) {
            throw new IOException();
        }
        this.fs = new FileInputStream(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public static void cleanup(String string) {
        MirroredInputStream.cleanup(string, null);
    }

    public static void cleanup(String string, String string2) {
        try {
            URL uRL = new URL(string);
            if (!uRL.getProtocol().equals("file")) {
                String[] stringArray;
                File file;
                String string3 = Main.pref.get("mirror." + uRL);
                if (string3 != null && string3.length() > 0 && (file = new File((stringArray = string3.split(";"))[1])).exists()) {
                    file.delete();
                }
                Main.pref.put("mirror." + uRL, null);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File checkLocal(URL uRL, String string, long l) {
        Object object;
        String string2 = Main.pref.get("mirror." + uRL);
        File file = null;
        if (string2 != null && string2.length() > 0) {
            object = string2.split(";");
            file = new File((String)object[1]);
            if (l <= 0L) {
                l = Main.pref.getInteger("mirror.maxtime", 604800);
            }
            if (System.currentTimeMillis() - Long.parseLong((String)object[0]) < l * 1000L && file.exists()) {
                return file;
            }
        }
        if (string == null) {
            string = Main.pref.getPreferencesDir();
        }
        if (!((File)(object = new File(string))).exists()) {
            ((File)object).mkdirs();
        }
        String string3 = uRL.toString().replaceAll("[^A-Za-z0-9_.-]", "_");
        string2 = "mirror_" + string3;
        object = new File(string, string2 + ".tmp");
        FilterOutputStream filterOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(5000);
            bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
            filterOutputStream = new BufferedOutputStream(new FileOutputStream((File)object));
            byte[] byArray = new byte[4096];
            while ((n = bufferedInputStream.read(byArray)) > -1) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            if (file != null) {
                File file2 = file;
                return file2;
            }
            File file3 = null;
            return file3;
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            file = new File(string, string2);
            ((File)object).renameTo(file);
            Main.pref.put("mirror." + uRL, System.currentTimeMillis() + ";" + file);
        }
        return file;
    }

    public int available() throws IOException {
        return this.fs.available();
    }

    public void close() throws IOException {
        this.fs.close();
    }

    public int read() throws IOException {
        return this.fs.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.fs.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.fs.read(byArray, n, n2);
    }

    public long skip(long l) throws IOException {
        return this.fs.skip(l);
    }
}

