/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class GpxImporter
extends FileImporter {
    public GpxImporter() {
        super(new ExtensionFileFilter("gpx,gpx.gz", "gpx", I18n.tr("GPX Files") + " (*.gpx *.gpx.gz)"));
    }

    public void importData(File file) throws IOException {
        String string = file.getName();
        try {
            GpxReader gpxReader = null;
            InputStream inputStream = file.getName().endsWith(".gpx.gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
            if (inputStream.read() != 239 || inputStream.read() != 187 || inputStream.read() != 191) {
                inputStream.close();
                inputStream = file.getName().endsWith(".gpx.gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
            }
            gpxReader = new GpxReader(inputStream, file.getAbsoluteFile().getParentFile());
            gpxReader.data.storageFile = file;
            GpxLayer gpxLayer = new GpxLayer(gpxReader.data, string, true);
            Main.main.addLayer(gpxLayer);
            if (Main.pref.getBoolean("marker.makeautomarkers", true)) {
                MarkerLayer markerLayer = new MarkerLayer(gpxReader.data, I18n.tr("Markers from {0}", string), file, gpxLayer);
                if (markerLayer.data.size() > 0) {
                    Main.main.addLayer(markerLayer);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw new IOException(I18n.tr("File \"{0}\" does not exist", file.getName()));
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new IOException(I18n.tr("Parsing file \"{0}\" failed", file.getName()));
        }
    }
}

