/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class BoundingBoxDownloader
extends OsmServerReader {
    private final double lat1;
    private final double lon1;
    private final double lat2;
    private final double lon2;

    public BoundingBoxDownloader(double d, double d2, double d3, double d4) {
        this.lat1 = d;
        this.lon1 = d2;
        this.lat2 = d3;
        this.lon2 = d4;
        Main.pref.put("osm-download.bounds", d + ";" + d2 + ";" + d3 + ";" + d4);
    }

    public GpxData parseRawGps() throws IOException, SAXException {
        Main.pleaseWaitDlg.progress.setValue(0);
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Contacting OSM Server..."));
        try {
            String string = "trackpoints?bbox=" + this.lon1 + "," + this.lat1 + "," + this.lon2 + "," + this.lat2 + "&page=";
            boolean bl = false;
            GpxData gpxData = null;
            int n = 0;
            while (!bl) {
                Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Downloading points {0} to {1}...", n * 5000, (n + 1) * 5000));
                InputStream inputStream = this.getInputStream(string + n, Main.pleaseWaitDlg);
                if (inputStream == null) break;
                GpxData gpxData2 = new GpxReader((InputStream)inputStream, null).data;
                if (gpxData == null) {
                    gpxData = gpxData2;
                } else if (gpxData2.hasTrackPoints()) {
                    gpxData.mergeFrom(gpxData2);
                } else {
                    bl = true;
                }
                inputStream.close();
                this.activeConnection = null;
                ++n;
            }
            gpxData.fromServer = true;
            return gpxData;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.cancel) {
                return null;
            }
            throw new SAXException("Illegal characters within the HTTP-header response", illegalArgumentException);
        }
        catch (IOException iOException) {
            if (this.cancel) {
                return null;
            }
            throw iOException;
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Exception exception) {
            if (this.cancel) {
                return null;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
    }

    public DataSet parseOsm() throws OsmTransferException {
        try {
            Main.pleaseWaitDlg.progress.setValue(0);
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Contacting OSM Server..."));
            Main.pleaseWaitDlg.setIndeterminate(true);
            InputStream inputStream = this.getInputStream("map?bbox=" + this.lon1 + "," + this.lat1 + "," + this.lon2 + "," + this.lat2, Main.pleaseWaitDlg);
            Main.pleaseWaitDlg.setIndeterminate(false);
            if (inputStream == null) {
                return null;
            }
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Downloading OSM data..."));
            DataSet dataSet = OsmReader.parseDataSet(inputStream, Main.pleaseWaitDlg);
            inputStream.close();
            this.activeConnection = null;
            return dataSet;
        }
        catch (IOException iOException) {
            if (this.cancel) {
                return null;
            }
            throw new OsmTransferException(iOException);
        }
        catch (SAXException sAXException) {
            throw new OsmTransferException(sAXException);
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            if (this.cancel) {
                return null;
            }
            throw new OsmTransferException(exception);
        }
    }
}

