/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ServerAccessPreference
implements PreferenceSetting {
    private JTextField osmDataServer = new JTextField(20);
    private JTextField osmDataUsername = new JTextField(20);
    private JPasswordField osmDataPassword = new JPasswordField(20);

    public void addGui(PreferenceDialog preferenceDialog) {
        this.osmDataServer.setText(Main.pref.get("osm-server.url", "http://api.openstreetmap.org/api"));
        this.osmDataUsername.setText(Main.pref.get("osm-server.username"));
        this.osmDataPassword.setText(Main.pref.get("osm-server.password"));
        this.osmDataServer.setToolTipText(I18n.tr("The base URL for the OSM server (REST API)"));
        this.osmDataUsername.setToolTipText(I18n.tr("Login name (e-mail) to the OSM account."));
        this.osmDataPassword.setToolTipText(I18n.tr("Login password to the OSM account. Leave blank to not store any password."));
        preferenceDialog.connection.add((Component)new JLabel(I18n.tr("Base Server URL")), GBC.std());
        preferenceDialog.connection.add((Component)this.osmDataServer, GBC.eol().fill(2).insets(5, 0, 0, 5));
        preferenceDialog.connection.add((Component)new JLabel(I18n.tr("OSM username (e-mail)")), GBC.std());
        preferenceDialog.connection.add((Component)this.osmDataUsername, GBC.eol().fill(2).insets(5, 0, 0, 5));
        preferenceDialog.connection.add((Component)new JLabel(I18n.tr("OSM password")), GBC.std());
        preferenceDialog.connection.add((Component)this.osmDataPassword, GBC.eol().fill(2).insets(5, 0, 0, 0));
        JLabel jLabel = new JLabel(I18n.tr("<html>WARNING: The password is stored in plain text in the preferences file.<br>The password is transferred in plain text to the server, encoded in the URL.<br><b>Do not use a valuable Password.</b></html>"));
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        preferenceDialog.connection.add((Component)jLabel, GBC.eop().fill(2));
    }

    public boolean ok() {
        Main.pref.put("osm-server.url", this.osmDataServer.getText());
        Main.pref.put("osm-server.username", this.osmDataUsername.getText());
        Main.pref.put("osm-server.password", String.valueOf(this.osmDataPassword.getPassword()));
        return false;
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new ServerAccessPreference();
        }
    }
}

