/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.VersionTableColumnModel;

public class VersionTable
extends JTable
implements Observer {
    private static Logger logger = Logger.getLogger(VersionTable.class.getName());

    protected void build() {
        this.setSelectionMode(0);
        this.addMouseListener(new MouseHandler());
        this.getSelectionModel().addListSelectionListener(new SelectionHandler());
    }

    public VersionTable(HistoryBrowserModel historyBrowserModel) {
        super(historyBrowserModel.getVersionTableModel(), new VersionTableColumnModel());
        historyBrowserModel.addObserver(this);
        this.build();
    }

    protected void handleSelectReferencePointInTime(int n) {
        this.getVesionTableModel().setReferencePointInTime(n);
    }

    protected void handleSelectCurrentPointInTime(int n) {
        this.getVesionTableModel().setCurrentPointInTime(n);
    }

    protected HistoryBrowserModel.VersionTableModel getVesionTableModel() {
        return (HistoryBrowserModel.VersionTableModel)this.getModel();
    }

    public void update(Observable observable, Object object) {
        this.repaint();
    }

    class SelectionHandler
    implements ListSelectionListener {
        SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
            if (defaultListSelectionModel.getMinSelectionIndex() >= 0) {
                VersionTable.this.handleSelectCurrentPointInTime(defaultListSelectionModel.getMinSelectionIndex());
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        protected void handleDoubleClick(MouseEvent mouseEvent) {
            int n = VersionTable.this.rowAtPoint(mouseEvent.getPoint());
            VersionTable.this.handleSelectReferencePointInTime(n);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            switch (mouseEvent.getClickCount()) {
                case 2: {
                    this.handleDoubleClick(mouseEvent);
                }
            }
        }
    }
}

