/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.tools.I18n;

public class TagTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private static Logger logger = Logger.getLogger(TagTableCellRenderer.class.getName());
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    public static final Color BGCOLOR_DIFFERENCE = new Color(255, 197, 197);

    public TagTableCellRenderer() {
        this.setOpaque(true);
        this.setForeground(Color.BLACK);
    }

    protected void renderName(String string, HistoryBrowserModel.TagTableModel tagTableModel, boolean bl) {
        String string2 = string;
        Color color = Color.WHITE;
        if (!tagTableModel.hasTag(string)) {
            string2 = I18n.tr("<undefined>");
            color = BGCOLOR_DIFFERENCE;
        } else if (!tagTableModel.oppositeHasTag(string)) {
            color = BGCOLOR_DIFFERENCE;
        }
        if (bl) {
            color = BGCOLOR_SELECTED;
        }
        this.setText(string2);
        this.setToolTipText(string2);
        this.setBackground(color);
    }

    protected void renderValue(String string, HistoryBrowserModel.TagTableModel tagTableModel, boolean bl) {
        String string2 = "";
        Color color = Color.WHITE;
        if (!tagTableModel.hasTag(string)) {
            string2 = I18n.tr("<undefined>");
            color = BGCOLOR_DIFFERENCE;
        } else {
            string2 = tagTableModel.getValue(string);
            if (!tagTableModel.hasSameValueAsOpposite(string)) {
                color = BGCOLOR_DIFFERENCE;
            }
        }
        if (bl) {
            color = BGCOLOR_SELECTED;
        }
        this.setText(string2);
        this.setToolTipText(string2);
        this.setBackground(color);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = (String)object;
        HistoryBrowserModel.TagTableModel tagTableModel = this.getTagTableModel(jTable);
        switch (n2) {
            case 0: {
                this.renderName(string, tagTableModel, bl);
                break;
            }
            case 1: {
                this.renderValue(string, tagTableModel, bl);
            }
        }
        return this;
    }

    protected HistoryBrowserModel.TagTableModel getTagTableModel(JTable jTable) {
        return (HistoryBrowserModel.TagTableModel)jTable.getModel();
    }
}

