/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Observable;
import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.tools.I18n;

public class HistoryBrowserModel
extends Observable {
    private static Logger logger = Logger.getLogger(HistoryBrowserModel.class.getName());
    private History history;
    private HistoryOsmPrimitive reference;
    private HistoryOsmPrimitive current;
    private VersionTableModel versionTableModel = new VersionTableModel();
    private TagTableModel currentTagTableModel = new TagTableModel(PointInTimeType.CURRENT_POINT_IN_TIME);
    private TagTableModel referenceTagTableModel = new TagTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME);
    private NodeListTableModel currentNodeListTableModel = new NodeListTableModel(PointInTimeType.CURRENT_POINT_IN_TIME);
    private NodeListTableModel referenceNodeListTableModel = new NodeListTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME);
    private RelationMemberTableModel currentRelationMemberTableModel = new RelationMemberTableModel(PointInTimeType.CURRENT_POINT_IN_TIME);
    private RelationMemberTableModel referenceRelationMemberTableModel = new RelationMemberTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME);

    public HistoryBrowserModel() {
    }

    public HistoryBrowserModel(History history) {
        this();
        this.setHistory(history);
    }

    public History getHistory() {
        return this.history;
    }

    public void setHistory(History history) {
        this.history = history;
        if (history.getNumVersions() > 0) {
            this.current = history.getEarliest();
            this.reference = history.getEarliest();
        }
        this.initTagTableModels();
        this.fireModelChange();
    }

    protected void fireModelChange() {
        this.setChanged();
        this.notifyObservers();
    }

    public VersionTableModel getVersionTableModel() {
        return this.versionTableModel;
    }

    protected void initTagTableModels() {
        this.currentTagTableModel.initKeyList();
        this.referenceTagTableModel.initKeyList();
    }

    protected void initNodeListTabeModel() {
        this.currentNodeListTableModel.fireTableDataChanged();
        this.referenceNodeListTableModel.fireTableDataChanged();
    }

    protected void initMemberListTableModel() {
        this.currentRelationMemberTableModel.fireTableDataChanged();
        this.referenceRelationMemberTableModel.fireTableDataChanged();
    }

    public TagTableModel getTagTableModel(PointInTimeType pointInTimeType) throws IllegalArgumentException {
        if (pointInTimeType == null) {
            throw new IllegalArgumentException(I18n.tr("parameter ''{0}'' must not be null", "pointInTimeType"));
        }
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentTagTableModel;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.referenceTagTableModel;
        }
        return null;
    }

    public NodeListTableModel getNodeListTableModel(PointInTimeType pointInTimeType) throws IllegalArgumentException {
        if (pointInTimeType == null) {
            throw new IllegalArgumentException(I18n.tr("parameter ''{0}'' must not be null", "pointInTimeType"));
        }
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentNodeListTableModel;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.referenceNodeListTableModel;
        }
        return null;
    }

    public RelationMemberTableModel getRelationMemberTableModel(PointInTimeType pointInTimeType) throws IllegalArgumentException {
        if (pointInTimeType == null) {
            throw new IllegalArgumentException(I18n.tr("parameter ''{0}'' must not be null", "pointInTimeType"));
        }
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentRelationMemberTableModel;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.referenceRelationMemberTableModel;
        }
        return null;
    }

    public void setReferencePointInTime(HistoryOsmPrimitive historyOsmPrimitive) throws IllegalArgumentException, IllegalStateException {
        if (historyOsmPrimitive == null) {
            throw new IllegalArgumentException(I18n.tr("parameter ''{0}'' must not be null", "reference"));
        }
        if (this.history == null) {
            throw new IllegalStateException(I18n.tr("history not initialized yet. Failed to set reference primitive."));
        }
        if (historyOsmPrimitive.getId() != this.history.getId()) {
            throw new IllegalArgumentException(I18n.tr("failed to set reference. reference id {0} doesn't match history id {1}", historyOsmPrimitive.getId(), this.history.getId()));
        }
        HistoryOsmPrimitive historyOsmPrimitive2 = this.history.getByVersion(historyOsmPrimitive.getVersion());
        if (historyOsmPrimitive2 == null) {
            throw new IllegalArgumentException(I18n.tr("failed to set reference. reference version {0} not available in history", historyOsmPrimitive.getVersion()));
        }
        this.reference = historyOsmPrimitive;
        this.initTagTableModels();
        this.initNodeListTabeModel();
        this.initMemberListTableModel();
        this.setChanged();
        this.notifyObservers();
    }

    public void setCurrentPointInTime(HistoryOsmPrimitive historyOsmPrimitive) throws IllegalArgumentException, IllegalStateException {
        if (historyOsmPrimitive == null) {
            throw new IllegalArgumentException(I18n.tr("parameter ''{0}'' must not be null", "current"));
        }
        if (this.history == null) {
            throw new IllegalStateException(I18n.tr("history not initialized yet. Failed to set current primitive."));
        }
        if (historyOsmPrimitive.getId() != this.history.getId()) {
            throw new IllegalArgumentException(I18n.tr("failed to set reference. reference id {0} doesn't match history id {1}", historyOsmPrimitive.getId(), this.history.getId()));
        }
        HistoryOsmPrimitive historyOsmPrimitive2 = this.history.getByVersion(historyOsmPrimitive.getVersion());
        if (historyOsmPrimitive2 == null) {
            throw new IllegalArgumentException(I18n.tr("failed to set current. current version {0} not available in history", historyOsmPrimitive.getVersion()));
        }
        this.current = historyOsmPrimitive;
        this.initTagTableModels();
        this.initNodeListTabeModel();
        this.initMemberListTableModel();
        this.setChanged();
        this.notifyObservers();
    }

    public HistoryOsmPrimitive getCurrentPointInTime() {
        return this.getPointInTime(PointInTimeType.CURRENT_POINT_IN_TIME);
    }

    public HistoryOsmPrimitive getReferencePointInTime() {
        return this.getPointInTime(PointInTimeType.REFERENCE_POINT_IN_TIME);
    }

    public HistoryOsmPrimitive getPointInTime(PointInTimeType pointInTimeType) throws IllegalArgumentException {
        if (pointInTimeType == null) {
            throw new IllegalArgumentException(I18n.tr("parameter ''{0}'' must not be null", "type"));
        }
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.current;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.reference;
        }
        return null;
    }

    public class RelationMemberTableModel
    extends DefaultTableModel {
        private PointInTimeType pointInTimeType;

        private RelationMemberTableModel(PointInTimeType pointInTimeType) {
            this.pointInTimeType = pointInTimeType;
        }

        public int getRowCount() {
            int n = 0;
            if (HistoryBrowserModel.this.current != null && HistoryBrowserModel.this.current.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                n = ((HistoryRelation)HistoryBrowserModel.this.current).getNumMembers();
            }
            if (HistoryBrowserModel.this.reference != null && HistoryBrowserModel.this.reference.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                n = Math.max(n, ((HistoryRelation)HistoryBrowserModel.this.reference).getNumMembers());
            }
            return n;
        }

        protected HistoryRelation getRelation() {
            if (this.pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.current.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                    return null;
                }
                return (HistoryRelation)HistoryBrowserModel.this.current;
            }
            if (this.pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.reference.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                    return null;
                }
                return (HistoryRelation)HistoryBrowserModel.this.reference;
            }
            return null;
        }

        protected HistoryRelation getOppositeRelation() {
            PointInTimeType pointInTimeType = this.pointInTimeType.opposite();
            if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.current.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                    return null;
                }
                return (HistoryRelation)HistoryBrowserModel.this.current;
            }
            if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.reference.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                    return null;
                }
                return (HistoryRelation)HistoryBrowserModel.this.reference;
            }
            return null;
        }

        public Object getValueAt(int n, int n2) {
            HistoryRelation historyRelation = this.getRelation();
            if (historyRelation == null) {
                return null;
            }
            if (n >= historyRelation.getNumMembers()) {
                return null;
            }
            return historyRelation.getMembers().get(n);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public boolean isSameInOppositeWay(int n) {
            HistoryRelation historyRelation = this.getRelation();
            HistoryRelation historyRelation2 = this.getOppositeRelation();
            if (historyRelation == null || historyRelation2 == null) {
                return false;
            }
            if (n >= historyRelation2.getNumMembers()) {
                return false;
            }
            return historyRelation.getMembers().get(n).getPrimitiveId() == historyRelation2.getMembers().get(n).getPrimitiveId() && historyRelation.getMembers().get(n).getRole().equals(historyRelation2.getMembers().get(n).getRole());
        }

        public boolean isInOppositeWay(int n) {
            HistoryRelation historyRelation = this.getRelation();
            HistoryRelation historyRelation2 = this.getOppositeRelation();
            if (historyRelation == null || historyRelation2 == null) {
                return false;
            }
            return historyRelation2.getMembers().contains(historyRelation.getMembers().get(n));
        }
    }

    public class NodeListTableModel
    extends DefaultTableModel {
        private PointInTimeType pointInTimeType;

        private NodeListTableModel(PointInTimeType pointInTimeType) {
            this.pointInTimeType = pointInTimeType;
        }

        public int getRowCount() {
            int n = 0;
            if (HistoryBrowserModel.this.current != null && HistoryBrowserModel.this.current.getType().equals((Object)OsmPrimitiveType.WAY)) {
                n = ((HistoryWay)HistoryBrowserModel.this.current).getNumNodes();
            }
            if (HistoryBrowserModel.this.reference != null && HistoryBrowserModel.this.reference.getType().equals((Object)OsmPrimitiveType.WAY)) {
                n = Math.max(n, ((HistoryWay)HistoryBrowserModel.this.reference).getNumNodes());
            }
            return n;
        }

        protected HistoryWay getWay() {
            if (this.pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.current.getType().equals((Object)OsmPrimitiveType.WAY)) {
                    return null;
                }
                return (HistoryWay)HistoryBrowserModel.this.current;
            }
            if (this.pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.reference.getType().equals((Object)OsmPrimitiveType.WAY)) {
                    return null;
                }
                return (HistoryWay)HistoryBrowserModel.this.reference;
            }
            return null;
        }

        protected HistoryWay getOppositeWay() {
            PointInTimeType pointInTimeType = this.pointInTimeType.opposite();
            if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.current.getType().equals((Object)OsmPrimitiveType.WAY)) {
                    return null;
                }
                return (HistoryWay)HistoryBrowserModel.this.current;
            }
            if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.reference.getType().equals((Object)OsmPrimitiveType.WAY)) {
                    return null;
                }
                return (HistoryWay)HistoryBrowserModel.this.reference;
            }
            return null;
        }

        public Object getValueAt(int n, int n2) {
            HistoryWay historyWay = this.getWay();
            if (historyWay == null) {
                return null;
            }
            if (n >= historyWay.getNumNodes()) {
                return null;
            }
            return historyWay.getNodes().get(n);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public boolean isSameInOppositeWay(int n) {
            HistoryWay historyWay = this.getWay();
            HistoryWay historyWay2 = this.getOppositeWay();
            if (historyWay == null || historyWay2 == null) {
                return false;
            }
            if (n >= historyWay2.getNumNodes()) {
                return false;
            }
            return historyWay.getNodeId(n) == historyWay2.getNodeId(n);
        }

        public boolean isInOppositeWay(int n) {
            HistoryWay historyWay = this.getWay();
            HistoryWay historyWay2 = this.getOppositeWay();
            if (historyWay == null || historyWay2 == null) {
                return false;
            }
            return historyWay2.getNodes().contains(historyWay.getNodeId(n));
        }
    }

    public class TagTableModel
    extends DefaultTableModel {
        private ArrayList<String> keys;
        private PointInTimeType pointInTimeType;

        protected void initKeyList() {
            HashSet<String> hashSet = new HashSet<String>();
            if (HistoryBrowserModel.this.current != null) {
                hashSet.addAll(HistoryBrowserModel.this.current.getTags().keySet());
            }
            if (HistoryBrowserModel.this.reference != null) {
                hashSet.addAll(HistoryBrowserModel.this.reference.getTags().keySet());
            }
            this.keys = new ArrayList(hashSet);
            Collections.sort(this.keys);
            this.fireTableDataChanged();
        }

        protected TagTableModel(PointInTimeType pointInTimeType) {
            this.pointInTimeType = pointInTimeType;
            this.initKeyList();
        }

        public int getRowCount() {
            if (this.keys == null) {
                return 0;
            }
            return this.keys.size();
        }

        public Object getValueAt(int n, int n2) {
            return this.keys.get(n);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public boolean hasTag(String string) {
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.getPointInTime(this.pointInTimeType);
            if (historyOsmPrimitive == null) {
                return false;
            }
            return historyOsmPrimitive.hasTag(string);
        }

        public String getValue(String string) {
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.getPointInTime(this.pointInTimeType);
            if (historyOsmPrimitive == null) {
                return null;
            }
            return historyOsmPrimitive.get(string);
        }

        public boolean oppositeHasTag(String string) {
            PointInTimeType pointInTimeType = this.pointInTimeType.opposite();
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.getPointInTime(pointInTimeType);
            if (historyOsmPrimitive == null) {
                return false;
            }
            return historyOsmPrimitive.hasTag(string);
        }

        public String getOppositeValue(String string) {
            PointInTimeType pointInTimeType = this.pointInTimeType.opposite();
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.getPointInTime(pointInTimeType);
            if (historyOsmPrimitive == null) {
                return null;
            }
            return historyOsmPrimitive.get(string);
        }

        public boolean hasSameValueAsOpposite(String string) {
            String string2 = this.getValue(string);
            String string3 = this.getOppositeValue(string);
            if (string2 == null || string3 == null) {
                return false;
            }
            return string2.equals(string3);
        }

        public PointInTimeType getPointInTimeType() {
            return this.pointInTimeType;
        }

        public boolean isCurrentPointInTime() {
            return this.pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME);
        }

        public boolean isReferencePointInTime() {
            return this.pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME);
        }
    }

    public class VersionTableModel
    extends DefaultTableModel {
        private VersionTableModel() {
        }

        public int getRowCount() {
            if (HistoryBrowserModel.this.history == null) {
                return 0;
            }
            return HistoryBrowserModel.this.history.getNumVersions();
        }

        public Object getValueAt(int n, int n2) {
            if (HistoryBrowserModel.this.history == null) {
                return null;
            }
            return HistoryBrowserModel.this.history.get(n);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setReferencePointInTime(int n) {
            if (HistoryBrowserModel.this.history == null) {
                return;
            }
            if (n < 0 || n > HistoryBrowserModel.this.history.getNumVersions()) {
                return;
            }
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.history.get(n);
            HistoryBrowserModel.this.setReferencePointInTime(historyOsmPrimitive);
        }

        public void setCurrentPointInTime(int n) {
            if (HistoryBrowserModel.this.history == null) {
                return;
            }
            if (n < 0 || n > HistoryBrowserModel.this.history.getNumVersions()) {
                return;
            }
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.history.get(n);
            HistoryBrowserModel.this.setCurrentPointInTime(historyOsmPrimitive);
        }

        public boolean isReferencePointInTime(int n) {
            if (HistoryBrowserModel.this.history == null) {
                return false;
            }
            if (n < 0 || n > HistoryBrowserModel.this.history.getNumVersions()) {
                return false;
            }
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.history.get(n);
            return historyOsmPrimitive.equals(HistoryBrowserModel.this.reference);
        }
    }
}

